/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.audiodevice;

import de.maxhenkel.voicechat.gui.audiodevice.AudioDeviceEntry;
import de.maxhenkel.voicechat.gui.tooltips.TestSpeakerSupplier;
import de.maxhenkel.voicechat.gui.widgets.ImageButton;
import de.maxhenkel.voicechat.voice.client.TestSoundPlayer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SpeakerAudioDeviceEntry
extends AudioDeviceEntry {
    public static final ResourceLocation SPEAKER_ICON = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/test_speaker.png");
    private ImageButton testButton = new ImageButton(0, 0, SPEAKER_ICON, button -> {
        this.testButton.active = false;
        TestSoundPlayer.playTestSound(() -> {
            this.testButton.active = true;
        });
    }, new TestSpeakerSupplier());

    public SpeakerAudioDeviceEntry(String device, Component name, @Nullable ResourceLocation icon, Supplier<Boolean> isSelected) {
        super(device, name, icon, isSelected);
        this.children.add(this.testButton);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
        super.render(guiGraphics, index, top, left, width, height, mouseX, mouseY, hovered, delta);
        boolean selected = (Boolean)this.isSelected.get();
        if (selected && hovered) {
            this.testButton.visible = true;
            this.testButton.setPosition(left + (width - this.testButton.getWidth() - 4), top + (height - this.testButton.getHeight()) / 2);
            this.testButton.render(guiGraphics, mouseX, mouseY, delta);
        } else {
            this.testButton.visible = false;
        }
    }
}

