/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.network.packet.clientbound;

import com.aetherteam.aether.perk.data.ClientDeveloperGlowPerkData;
import com.aetherteam.aether.perk.types.DeveloperGlow;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ClientDeveloperGlowPacket {

    public record Sync(Map<UUID, DeveloperGlow> developerGlows) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<Sync> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"sync_developer_glow"));
        public static final StreamCodec<RegistryFriendlyByteBuf, Sync> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(Maps::newHashMapWithExpectedSize, (StreamCodec)UUIDUtil.STREAM_CODEC, DeveloperGlow.STREAM_CODEC), Sync::developerGlows, Sync::new);

        public CustomPacketPayload.Type<Sync> type() {
            return TYPE;
        }

        public static void execute(Sync payload, IPayloadContext context) {
            if (Minecraft.getInstance().player != null && Minecraft.getInstance().level != null && payload.developerGlows() != null && !payload.developerGlows().isEmpty()) {
                for (Map.Entry<UUID, DeveloperGlow> developerGlowEntry : payload.developerGlows().entrySet()) {
                    ClientDeveloperGlowPerkData.INSTANCE.applyPerk(developerGlowEntry.getKey(), developerGlowEntry.getValue());
                }
            }
        }
    }

    public record Remove(UUID playerUUID) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<Remove> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"remove_developer_glow"));
        public static final StreamCodec<RegistryFriendlyByteBuf, Remove> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, Remove::playerUUID, Remove::new);

        public CustomPacketPayload.Type<Remove> type() {
            return TYPE;
        }

        public static void execute(Remove payload, IPayloadContext context) {
            if (Minecraft.getInstance().player != null && Minecraft.getInstance().level != null && payload.playerUUID() != null) {
                ClientDeveloperGlowPerkData.INSTANCE.removePerk(payload.playerUUID());
            }
        }
    }

    public record Apply(UUID playerUUID, DeveloperGlow developerGlow) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<Apply> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"apply_developer_glow"));
        public static final StreamCodec<RegistryFriendlyByteBuf, Apply> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, Apply::playerUUID, DeveloperGlow.STREAM_CODEC, Apply::developerGlow, Apply::new);

        public CustomPacketPayload.Type<Apply> type() {
            return TYPE;
        }

        public static void execute(Apply payload, IPayloadContext context) {
            if (Minecraft.getInstance().player != null && Minecraft.getInstance().level != null && payload.playerUUID() != null && payload.developerGlow() != null) {
                ClientDeveloperGlowPerkData.INSTANCE.applyPerk(payload.playerUUID(), payload.developerGlow());
            }
        }
    }
}

