/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item.combat.abilities.armor;

import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.AetherPlayerAttachment;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.item.EquipmentUtil;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public interface PhoenixArmor {
    public static void boostLavaSwimming(LivingEntity entity) {
        Player player;
        if (EquipmentUtil.hasFullPhoenixSet(entity)) {
            Level level;
            entity.clearFire();
            if (entity.isInLava()) {
                entity.resetFallDistance();
                if (entity instanceof Player) {
                    player = (Player)entity;
                    AetherPlayerAttachment data = (AetherPlayerAttachment)player.getData(AetherDataAttachments.AETHER_PLAYER);
                    float defaultBoost = PhoenixArmor.boostWithDepthStrider(entity, 1.75f, 1.0f);
                    data.setPhoenixSubmergeLength(Math.min(data.getPhoenixSubmergeLength() + 0.1, 1.0));
                    entity.moveRelative(0.04f * (defaultBoost *= (float)data.getPhoenixSubmergeLength()), new Vec3((double)entity.xxa, (double)entity.yya, (double)entity.zza));
                } else {
                    float defaultBoost = PhoenixArmor.boostWithDepthStrider(entity, 1.75f, 1.0f);
                    entity.moveRelative(0.04f * defaultBoost, new Vec3((double)entity.xxa, (double)entity.yya, (double)entity.zza));
                }
            }
            if ((level = entity.level()) instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                level2.sendParticles((ParticleOptions)ParticleTypes.FLAME, entity.getX() + level2.getRandom().nextGaussian() / 5.0, entity.getY() + level2.getRandom().nextGaussian() / 3.0, entity.getZ() + level2.getRandom().nextGaussian() / 5.0, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (!(EquipmentUtil.hasFullPhoenixSet(entity) && entity.isInLava() || !(entity instanceof Player))) {
            player = (Player)entity;
            ((AetherPlayerAttachment)player.getData(AetherDataAttachments.AETHER_PLAYER)).setPhoenixSubmergeLength(0.0);
        }
    }

    public static void boostVerticalLavaSwimming(LivingEntity entity) {
        if (EquipmentUtil.hasFullPhoenixSet(entity)) {
            entity.clearFire();
            if (entity.isInLava()) {
                entity.resetFallDistance();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    AetherPlayerAttachment data = (AetherPlayerAttachment)player.getData(AetherDataAttachments.AETHER_PLAYER);
                    float defaultBoost = PhoenixArmor.boostWithDepthStrider(entity, 1.5f, 0.05f);
                    data.setPhoenixSubmergeLength(Math.min(data.getPhoenixSubmergeLength() + 0.1, 1.0));
                    defaultBoost *= (float)data.getPhoenixSubmergeLength();
                    if (entity.getDeltaMovement().y() > 0.0 || entity.isCrouching()) {
                        entity.setDeltaMovement(entity.getDeltaMovement().multiply(1.0, (double)defaultBoost, 1.0));
                    }
                } else {
                    float defaultBoost = PhoenixArmor.boostWithDepthStrider(entity, 1.5f, 0.05f);
                    if (entity.getDeltaMovement().y() > 0.0 || entity.isCrouching()) {
                        entity.setDeltaMovement(entity.getDeltaMovement().multiply(1.0, (double)defaultBoost, 1.0));
                    }
                }
            }
        }
    }

    private static float boostWithDepthStrider(LivingEntity entity, float start, float increment) {
        float defaultBoost = start;
        float depthStriderModifier = Math.min((float)EnchantmentHelper.getEnchantmentLevel((Holder)entity.level().holderOrThrow(Enchantments.DEPTH_STRIDER), (LivingEntity)entity), 3.0f);
        if (depthStriderModifier > 0.0f) {
            defaultBoost += depthStriderModifier * increment;
        }
        return defaultBoost;
    }

    public static void damageArmor(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            AetherPlayerAttachment data = (AetherPlayerAttachment)player.getData(AetherDataAttachments.AETHER_PLAYER);
            if (EquipmentUtil.hasAnyPhoenixArmor(entity) && entity.isInWaterRainOrBubble()) {
                if (entity.level().getGameTime() % 15L == 0L) {
                    data.setObsidianConversionTime(data.getObsidianConversionTime() + 1);
                    entity.level().levelEvent(1501, entity.blockPosition(), 0);
                }
            } else {
                data.setObsidianConversionTime(0);
            }
            if (data.getObsidianConversionTime() >= data.getObsidianConversionTimerMax()) {
                for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                    if (equipmentSlot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
                    ItemStack equippedStack = entity.getItemBySlot(equipmentSlot);
                    if (equippedStack.is((Item)AetherItems.PHOENIX_HELMET.get())) {
                        PhoenixArmor.breakPhoenixArmor(entity, equippedStack, new ItemStack((ItemLike)AetherItems.OBSIDIAN_HELMET.get()), equipmentSlot);
                        continue;
                    }
                    if (equippedStack.is((Item)AetherItems.PHOENIX_CHESTPLATE.get())) {
                        PhoenixArmor.breakPhoenixArmor(entity, equippedStack, new ItemStack((ItemLike)AetherItems.OBSIDIAN_CHESTPLATE.get()), equipmentSlot);
                        continue;
                    }
                    if (equippedStack.is((Item)AetherItems.PHOENIX_LEGGINGS.get())) {
                        PhoenixArmor.breakPhoenixArmor(entity, equippedStack, new ItemStack((ItemLike)AetherItems.OBSIDIAN_LEGGINGS.get()), equipmentSlot);
                        continue;
                    }
                    if (!equippedStack.is((Item)AetherItems.PHOENIX_BOOTS.get())) continue;
                    PhoenixArmor.breakPhoenixArmor(entity, equippedStack, new ItemStack((ItemLike)AetherItems.OBSIDIAN_BOOTS.get()), equipmentSlot);
                }
                SlotEntryReference slotResult = EquipmentUtil.getAccessory(entity, (Item)AetherItems.PHOENIX_GLOVES.get());
                if (slotResult != null) {
                    PhoenixArmor.breakPhoenixGloves(entity, slotResult, new ItemStack((ItemLike)AetherItems.OBSIDIAN_GLOVES.get()));
                }
            }
        }
    }

    private static void breakPhoenixArmor(LivingEntity entity, ItemStack equippedStack, ItemStack outcomeStack, EquipmentSlot slot) {
        outcomeStack = new ItemStack(outcomeStack.getItemHolder(), 1, equippedStack.getComponentsPatch());
        entity.setItemSlot(slot, outcomeStack);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            CriteriaTriggers.INVENTORY_CHANGED.trigger(serverPlayer, serverPlayer.getInventory(), outcomeStack);
        }
    }

    private static void breakPhoenixGloves(LivingEntity entity, SlotEntryReference slotResult, ItemStack outcomeStack) {
        AccessoriesContainer accessoriesContainer;
        outcomeStack = new ItemStack(outcomeStack.getItemHolder(), 1, slotResult.stack().getComponentsPatch());
        AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)entity);
        if (accessories != null && (accessoriesContainer = accessories.getContainer(slotResult.reference().type())) != null) {
            accessoriesContainer.getAccessories().setItem(slotResult.reference().slot(), outcomeStack);
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            CriteriaTriggers.INVENTORY_CHANGED.trigger(serverPlayer, serverPlayer.getInventory(), outcomeStack);
        }
    }

    public static boolean extinguishUser(LivingEntity entity, DamageSource source) {
        return EquipmentUtil.hasFullPhoenixSet(entity) && source.is(DamageTypeTags.IS_FIRE);
    }
}

