/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.entity;

import com.aetherteam.aether.client.renderer.AetherModelLayers;
import com.aetherteam.aether.client.renderer.entity.layers.SentryGlowLayer;
import com.aetherteam.aether.entity.monster.dungeon.Sentry;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SlimeModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;

public class SentryRenderer
extends MobRenderer<Sentry, SlimeModel<Sentry>> {
    private static final ResourceLocation SENTRY_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"textures/entity/mobs/sentry/sentry.png");
    private static final ResourceLocation SENTRY_LIT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"textures/entity/mobs/sentry/sentry_lit.png");

    public SentryRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new SlimeModel(context.bakeLayer(AetherModelLayers.SENTRY)), 0.3f);
        this.addLayer((RenderLayer)new SentryGlowLayer((RenderLayerParent<Sentry, SlimeModel<Sentry>>)this));
    }

    protected void scale(Sentry sentry, PoseStack poseStack, float partialTicks) {
        float f = 0.879f;
        poseStack.scale(f, f, f);
        float f1 = (float)sentry.getSize() + 1.0f;
        float f2 = 0.0f;
        float f3 = 1.0f / (f2 + 1.0f);
        poseStack.scale(f3 * f1, 1.0f / f3 * f1, f3 * f1);
    }

    public ResourceLocation getTextureLocation(Sentry sentry) {
        return sentry.isAwake() ? SENTRY_LIT_TEXTURE : SENTRY_TEXTURE;
    }
}

