/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.content.block;

import dev.xkmc.fruitsdelight.content.block.DoubleBushBlock;
import dev.xkmc.fruitsdelight.init.plants.FDBushType;
import dev.xkmc.l2harvester.api.HarvestResult;
import dev.xkmc.l2harvester.api.HarvestableBlock;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DoubleFruitBushBlock
extends DoubleBushBlock
implements HarvestableBlock {
    private static final VoxelShape TALL_SMALL = Shapes.or((VoxelShape)Block.box((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0), (VoxelShape)Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)3.0, (double)9.0));
    private static final VoxelShape TALL_MID = Shapes.or((VoxelShape)Block.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)6.0, (double)9.0));
    private static final VoxelShape TALL_LOWER = Shapes.or((VoxelShape)Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0));
    private static final VoxelShape TALL_UPPER = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private final Supplier<Item> item;
    private final FDBushType type;

    public DoubleFruitBushBlock(BlockBehaviour.Properties properties, Supplier<Item> item, FDBushType type) {
        super(properties);
        this.item = item;
        this.type = type;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(2)));
    }

    @Override
    public int getDoubleBlockStart() {
        return 2;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (state.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
            state = level.getBlockState(pos.below());
            pos = pos.below();
        }
        if (state.is((Block)this) && state.getValue((Property)HALF) == DoubleBlockHalf.LOWER && (Integer)state.getValue((Property)AGE) == 4) {
            if (!level.isClientSide()) {
                int j = 1 + level.random.nextInt(2);
                DoubleFruitBushBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.item.get(), j));
                level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
                this.setGrowth(level, pos, 2, 2);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public HarvestResult getHarvestResult(Level level, BlockState state, BlockPos pos) {
        BlockPos lower;
        if (state.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
            lower = pos.below();
            state = level.getBlockState(lower);
            if (state.getBlock() != this) {
                return null;
            }
        } else {
            lower = pos;
        }
        if ((Integer)state.getValue((Property)AGE) < 4) {
            return null;
        }
        return new HarvestResult((l, p) -> this.setGrowth((Level)l, lower, 2, 2), List.of(new ItemStack((ItemLike)this.item.get(), 1 + level.random.nextInt(2))));
    }

    @Deprecated
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        boolean lower;
        int age = (Integer)state.getValue((Property)AGE);
        boolean bl = lower = state.getValue((Property)HALF) == DoubleBlockHalf.LOWER;
        return age == 0 ? TALL_SMALL : (age == 1 ? TALL_MID : (lower ? TALL_LOWER : TALL_UPPER));
    }
}

