/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.content.logic;

import dev.xkmc.cuisinedelight.content.item.BaseFoodItem;
import dev.xkmc.cuisinedelight.content.logic.FoodType;
import dev.xkmc.cuisinedelight.init.CuisineDelight;
import dev.xkmc.l2core.serial.config.BaseConfig;
import dev.xkmc.l2core.serial.config.CollectType;
import dev.xkmc.l2core.serial.config.ConfigCollect;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class IngredientConfig
extends BaseConfig {
    @SerialField
    @ConfigCollect(value=CollectType.COLLECT)
    public ArrayList<IngredientEntry> entries = new ArrayList();
    private final HashMap<Item, IngredientEntry> cache = new HashMap();
    private final HashSet<Item> empty = new HashSet();
    private final ItemStack[][] byType = new ItemStack[FoodType.values().length][];

    public static IngredientConfig get() {
        return (IngredientConfig)CuisineDelight.INGREDIENT.getMerged();
    }

    @Nullable
    public IngredientEntry getEntry(ItemStack stack) {
        if (stack.isComponentsPatchEmpty()) {
            if (this.empty.contains(stack.getItem())) {
                return null;
            }
            if (this.cache.containsKey(stack.getItem())) {
                return this.cache.get(stack.getItem());
            }
        }
        for (IngredientEntry e : this.entries) {
            if (!e.ingredient.test(stack)) continue;
            if (stack.isComponentsPatchEmpty()) {
                this.cache.put(stack.getItem(), e);
            }
            return e;
        }
        if (stack.isComponentsPatchEmpty()) {
            this.empty.add(stack.getItem());
        }
        return null;
    }

    public ItemStack[] getAll(FoodType type) {
        if (this.byType[type.ordinal()] != null) {
            return this.byType[type.ordinal()];
        }
        this.byType[type.ordinal()] = (ItemStack[])this.entries.stream().filter(e -> e.type == type).flatMap(e -> Arrays.stream(e.ingredient.getItems())).map(BaseFoodItem::setIngredientDisplay).toArray(ItemStack[]::new);
        return this.byType[type.ordinal()];
    }

    public static IngredientEntry get(Ingredient ingredient, FoodType type, int min_time, int max_time, int stir_time, float raw_penalty, float overcook_penalty, int size, int nutrition, EffectEntry ... effects) {
        IngredientEntry ans = new IngredientEntry();
        ans.ingredient = ingredient;
        ans.type = type;
        ans.min_time = min_time;
        ans.max_time = max_time;
        ans.stir_time = stir_time;
        ans.raw_penalty = raw_penalty;
        ans.overcook_penalty = overcook_penalty;
        ans.size = size;
        ans.nutrition = nutrition;
        ans.effects.addAll(Arrays.asList(effects));
        return ans;
    }

    public static IngredientConfig build(IngredientEntry ... entries) {
        IngredientConfig ans = new IngredientConfig();
        Collections.addAll(ans.entries, entries);
        return ans;
    }

    @SerialClass
    public static class IngredientEntry {
        @SerialField
        public Ingredient ingredient;
        @SerialField
        public FoodType type;
        @SerialField
        public int min_time;
        @SerialField
        public int max_time;
        @SerialField
        public int stir_time;
        @SerialField
        public float raw_penalty;
        @SerialField
        public float overcook_penalty;
        @SerialField
        public int size;
        @SerialField
        public int nutrition;
        @SerialField
        public ArrayList<EffectEntry> effects = new ArrayList();
    }

    public record EffectEntry(Holder<MobEffect> effect, int level, int time) {
    }
}

