/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.content.item;

import dev.xkmc.cuisinedelight.content.block.CuisineSkilletBlockEntity;
import dev.xkmc.cuisinedelight.content.item.CuisineSkilletItem;
import dev.xkmc.cuisinedelight.content.logic.CookingData;
import dev.xkmc.cuisinedelight.init.data.LangData;
import dev.xkmc.cuisinedelight.init.registrate.CDItems;
import dev.xkmc.l2core.init.reg.ench.EnchHelper;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import vectorwing.farmersdelight.common.registry.ModSounds;

public class SpatulaItem
extends Item {
    public static final int ANIM_TIME = 20;

    public SpatulaItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack spatulaStack = player.getItemInHand(hand);
        InteractionHand otherHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack skilletStack = player.getItemInHand(otherHand);
        if (!skilletStack.is((Item)CDItems.SKILLET.get())) {
            return InteractionResultHolder.pass((Object)spatulaStack);
        }
        CookingData data = CuisineSkilletItem.getData(skilletStack);
        if (data != null) {
            if (!level.isClientSide()) {
                data.stir(level.getGameTime(), SpatulaItem.getReduction(spatulaStack));
                CuisineSkilletItem.setData(skilletStack, data);
                player.getCooldowns().addCooldown((Item)this, 20);
                player.getCooldowns().addCooldown((Item)CDItems.SKILLET.get(), 20);
            } else {
                CuisineSkilletItem.playSound(player, level, (SoundEvent)ModSounds.BLOCK_SKILLET_ADD_FOOD.get());
            }
            return InteractionResultHolder.success((Object)spatulaStack);
        }
        return InteractionResultHolder.fail((Object)spatulaStack);
    }

    private static int getReduction(ItemStack stack) {
        return EnchHelper.getLv((ItemStack)stack, (ResourceKey)Enchantments.SILK_TOUCH) > 0 ? 20 : 0;
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Level level = ctx.getLevel();
        Player player = ctx.getPlayer();
        BlockEntity blockEntity = level.getBlockEntity(ctx.getClickedPos());
        if (blockEntity instanceof CuisineSkilletBlockEntity) {
            CuisineSkilletBlockEntity be = (CuisineSkilletBlockEntity)blockEntity;
            if (!be.cookingData.contents.isEmpty()) {
                if (!level.isClientSide()) {
                    be.stir(level.getGameTime(), SpatulaItem.getReduction(ctx.getItemInHand()));
                    if (player != null) {
                        player.getCooldowns().addCooldown((Item)CDItems.SPATULA.get(), 20);
                    }
                } else if (player != null) {
                    CuisineSkilletItem.playSound(player, level, (SoundEvent)ModSounds.BLOCK_SKILLET_SIZZLE.get());
                }
            }
        }
        return InteractionResult.PASS;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        if (enchantment.is(Enchantments.SILK_TOUCH)) {
            return true;
        }
        return super.supportsEnchantment(stack, enchantment);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> list, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            list.add((Component)LangData.ENCH_SILK.get(new Object[0]));
        } else {
            list.add((Component)LangData.ENCH_SHIFT.get(new Object[0]));
        }
    }
}

