/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.fantasy.util;

import com.google.common.collect.Iterators;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Lifecycle;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilteredRegistry<T>
extends MappedRegistry<T> {
    private final Registry<T> source;
    private final Predicate<T> check;

    public FilteredRegistry(Registry<T> source, Predicate<T> check) {
        super(source.key(), source.registryLifecycle());
        this.source = source;
        this.check = check;
    }

    public Registry<T> getSource() {
        return this.source;
    }

    @Nullable
    public ResourceLocation getKey(T value) {
        return this.check.test(value) ? this.source.getKey(value) : null;
    }

    public Optional<ResourceKey<T>> getResourceKey(T entry) {
        return this.check.test(entry) ? this.source.getResourceKey(entry) : Optional.empty();
    }

    public int getId(@Nullable T value) {
        return this.check.test(value) ? this.source.getId(value) : -1;
    }

    @Nullable
    public T byId(int index) {
        return (T)this.source.byId(index);
    }

    public int size() {
        return this.source.size();
    }

    @Nullable
    public T get(@Nullable ResourceKey<T> key) {
        return (T)this.source.get(key);
    }

    @Nullable
    public T get(@Nullable ResourceLocation id) {
        return (T)super.get(id);
    }

    public Lifecycle registryLifecycle() {
        return this.source.registryLifecycle();
    }

    public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
        HashSet<Map.Entry<ResourceKey<T>, T>> set = new HashSet<Map.Entry<ResourceKey<T>, T>>();
        for (Map.Entry e : this.source.entrySet()) {
            if (!this.check.test(e.getValue())) continue;
            set.add(e);
        }
        return set;
    }

    public Set<ResourceKey<T>> registryKeySet() {
        return null;
    }

    public Optional<Holder.Reference<T>> getRandom(RandomSource random) {
        return Optional.empty();
    }

    public boolean containsKey(ResourceLocation id) {
        return this.source.containsKey(id);
    }

    public boolean containsKey(ResourceKey<T> key) {
        return this.source.containsKey(key);
    }

    public Registry<T> freeze() {
        return this;
    }

    public Holder.Reference<T> createIntrusiveHolder(T value) {
        return null;
    }

    public Optional<Holder.Reference<T>> getHolder(int rawId) {
        return this.source.getHolder(rawId);
    }

    public Optional<Holder.Reference<T>> getHolder(ResourceKey<T> key) {
        return this.source.getHolder(key);
    }

    public Stream<Holder.Reference<T>> holders() {
        return this.source.holders().filter(e -> this.check.test(e.value()));
    }

    public Optional<HolderSet.Named<T>> getTag(TagKey<T> tag) {
        return Optional.empty();
    }

    public HolderSet.Named<T> getOrCreateTag(TagKey<T> tag) {
        return null;
    }

    public Stream<Pair<TagKey<T>, HolderSet.Named<T>>> getTags() {
        return null;
    }

    public Stream<TagKey<T>> getTagNames() {
        return null;
    }

    public void resetTags() {
    }

    public void bindTags(Map<TagKey<T>, List<Holder<T>>> tagEntries) {
    }

    @NotNull
    public Iterator<T> iterator() {
        return Iterators.filter((Iterator)this.source.iterator(), this.check::test);
    }
}

