/*
 * Decompiled with CFR 0.152.
 */
package multiworld.mixin;

import me.isaiah.multiworld.I18n;
import me.isaiah.multiworld.MultiworldMod;
import me.isaiah.multiworld.command.PortalCommand;
import me.isaiah.multiworld.portal.Portal;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NetherPortalBlock.class})
public class MixinNetherPortalBlock {
    @Inject(at={@At(value="HEAD")}, method={"entityInside(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/Entity;)V"}, cancellable=true)
    private void onEntityCollision(BlockState state, Level world, BlockPos pos, Entity entity, CallbackInfo ci) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        boolean is_our_portal = true;
        if (is_our_portal) {
            for (Portal p : PortalCommand.KNOWN_PORTALS.values()) {
                BlockPos min = p.getMinPos();
                BlockPos max = p.getMaxPos();
                boolean isInside = pos.getX() >= min.getX() && pos.getX() <= max.getX() && pos.getY() >= min.getY() && pos.getY() <= max.getY() && pos.getZ() >= min.getZ() && pos.getZ() <= max.getZ();
                if (!isInside) continue;
                I18n.message((ServerPlayer)entity, "&6Teleporting...");
                BlockPos dest = p.getDestLocation();
                MultiworldMod.get_world_creator().teleleport((ServerPlayer)entity, p.getDestWorld(), dest.getX(), dest.getY(), dest.getZ());
                ci.cancel();
                return;
            }
        }
    }
}

