/*
 * Decompiled with CFR 0.152.
 */
package me.isaiah.multiworld.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import me.isaiah.multiworld.config.Configuration;

public class FileConfiguration
extends Configuration {
    private File file;
    private ArrayList<Integer> blanks;

    public FileConfiguration(LinkedHashMap<String, Object> contentMap) {
        super(contentMap);
    }

    public FileConfiguration() {
    }

    public FileConfiguration(File f) throws IOException {
        this.file = f;
        this.loadFile(f);
    }

    public void loadFile(File f) throws IOException {
        this.file = f;
        this.blanks = new ArrayList();
        this.contentMap = new LinkedHashMap();
        if (!f.isFile() || !f.exists()) {
            return;
        }
        List<String> list = Files.readAllLines(f.toPath());
        Object section = "";
        int lastSpace = -1;
        for (int i = 0; i < list.size(); ++i) {
            String line = list.get(i);
            if (line.startsWith("#")) {
                this.contentMap.put(line + ":" + i, i);
                continue;
            }
            if (line.isEmpty() || line.trim().isEmpty()) {
                this.blanks.add(i);
            }
            if (line.indexOf(58) == -1) continue;
            String[] spl = line.split("[:]");
            Object key = spl[0];
            int sp = ((String)key).length() - ((String)key).trim().length();
            if (sp > lastSpace) {
                lastSpace = sp;
                section = (String)section + "." + ((String)key).trim();
            }
            if (sp == lastSpace) {
                if (((String)section).indexOf(46) != -1) {
                    section = ((String)section).substring(0, ((String)section).lastIndexOf(46));
                    section = (String)section + "." + ((String)key).trim();
                } else {
                    section = ((String)key).trim();
                }
            }
            if (sp < lastSpace) {
                lastSpace = sp;
                section = ((String)section).substring(0, ((String)section).lastIndexOf(46));
                section = ((String)section).substring(0, ((String)section).lastIndexOf(46));
                section = (String)section + "." + ((String)key).trim();
            }
            if (((String)section).startsWith(".")) {
                section = ((String)section).substring(1);
            }
            key = section;
            if ((spl.length == 1 || spl[1].trim().length() == 0) && i + 1 < list.size() && list.get(i + 1).trim().startsWith("-")) {
                ArrayList<Object> o = new ArrayList<Object>();
                int b = i;
                ++b;
                while (b < list.size() && list.get(b).trim().startsWith("-")) {
                    o.add(this.parseLine(list.get(b).trim().substring(1).trim()));
                    ++b;
                }
                this.contentMap.put(key, o);
                continue;
            }
            if (spl.length == 1) continue;
            String spl_1 = line.substring(line.indexOf(58) + 1);
            this.contentMap.put(key, this.parseLine(spl_1.trim()));
        }
    }

    @Override
    public void save() throws IOException {
        this.save(this.file);
    }

    public static String getTextAfterLastDot(String str) {
        int lastIndex = str.lastIndexOf(".");
        if (lastIndex != -1) {
            return str.substring(lastIndex + 1);
        }
        return "";
    }

    @Override
    public void save(File to) throws IOException {
        ArrayList<Object> s = new ArrayList<Object>();
        int a = 0;
        ArrayList<Object> sectSet = new ArrayList<Object>();
        for (Object key : this.contentMap.keySet()) {
            Object v = this.contentMap.get(key);
            if (((String)key).contains(".")) {
                String[] k = ((String)key).split("[.]");
                int spaces = 0;
                Object cc = "";
                for (String st : k) {
                    if (((String)(cc = (String)cc + "." + st)).startsWith(".")) {
                        cc = ((String)cc).substring(1);
                    }
                    if (sectSet.contains(cc)) {
                        spaces += 4;
                        continue;
                    }
                    sectSet.add(cc);
                    for (int i = 0; i < spaces; ++i) {
                        s.add(" ");
                    }
                    if (st.equals(((String)key).substring(((String)key).lastIndexOf(46) + 1))) {
                        if (v instanceof List) {
                            s.add(st + ": \n");
                            String sp = this.repeat(" ", spaces + 2);
                            for (Object z : (List)v) {
                                s.add(sp + "- " + String.valueOf(z) + "\n");
                            }
                        } else if (((String)key).startsWith("#")) {
                            s.add(st.substring(0, st.lastIndexOf(58)) + "\n");
                        } else {
                            s.add(st + ": " + String.valueOf(v) + "\n");
                        }
                    } else {
                        s.add(st + ": \n");
                    }
                    spaces += 4;
                }
            } else {
                sectSet.add(key);
                if (v instanceof List) {
                    s.add((String)key + ": \n");
                    for (Object z : (List)v) {
                        s.add("    - " + String.valueOf(z) + "\n");
                    }
                } else if (((String)key).startsWith("#")) {
                    s.add(((String)key).substring(0, ((String)key).lastIndexOf(58)) + "\n");
                } else {
                    s.add((String)key + ": " + String.valueOf(v) + "\n");
                }
            }
            ++a;
        }
        Object raw = "";
        for (String string : s) {
            raw = (String)raw + string;
        }
        Object zz = "";
        a = 0;
        for (String z : ((String)raw).split("\n")) {
            if (this.blanks.contains(a)) {
                zz = (String)zz + "\n";
                ++a;
            }
            zz = (String)zz + z + "\n";
            ++a;
        }
        Files.write(to.toPath(), ((String)zz).getBytes(), new OpenOption[0]);
    }

    private Object parseLine(String val) {
        if (val.equalsIgnoreCase("true") || val.equalsIgnoreCase("false")) {
            return Boolean.valueOf(val);
        }
        try {
            return Integer.valueOf(val);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Long.valueOf(val);
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    return Double.valueOf(val);
                }
                catch (NumberFormatException numberFormatException3) {
                    return val;
                }
            }
        }
    }

    public String repeat(String str, int n) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }
}

