/*
 * Decompiled with CFR 0.152.
 */
package me.isaiah.multiworld.command;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import me.isaiah.multiworld.ConsoleCommand;
import me.isaiah.multiworld.MultiworldMod;
import me.isaiah.multiworld.command.Command;
import me.isaiah.multiworld.command.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class DeleteCommand
implements Command {
    public static Logger LOGGER = ConsoleCommand.LOGGER;
    private static HashMap<String, Long> map = new HashMap();

    public static int run(MinecraftServer mc, CommandSourceStack source, String[] args) {
        long TIMEOUT;
        if (args.length == 1) {
            LOGGER.error("Usage: /mw delete <id>");
            return 0;
        }
        String id = args[1];
        if (!map.containsKey(id)) {
            map.put(id, System.currentTimeMillis());
            LOGGER.info("NOTE: This command will destroy the life, universe and everything associated with the world.");
            LOGGER.info("For this reason, Please run command again to confirm to delete \"" + id + "\".");
            return 1;
        }
        long start = map.get(id);
        long now = System.currentTimeMillis();
        if (now - start > (TIMEOUT = 20000L)) {
            LOGGER.info("Delete request timed-out (>20s). Please try again.");
            map.remove(id);
            return 0;
        }
        LOGGER.info("Deleting multiworld config for \"" + id + "\"...");
        try {
            File config = Util.get_config_file(MultiworldMod.new_id(id));
            config.delete();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LOGGER.info("Deleting world folder \"" + id + "\"...");
        MultiworldMod.get_world_creator().delete_world(id);
        return 1;
    }
}

