/*
 * Decompiled with CFR 0.152.
 */
package me.isaiah.multiworld;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.io.File;
import me.isaiah.multiworld.ConsoleCommand;
import me.isaiah.multiworld.ICreator;
import me.isaiah.multiworld.InfoSuggest;
import me.isaiah.multiworld.command.CreateCommand;
import me.isaiah.multiworld.command.DifficultyCommand;
import me.isaiah.multiworld.command.GameruleCommand;
import me.isaiah.multiworld.command.PortalCommand;
import me.isaiah.multiworld.command.SetspawnCommand;
import me.isaiah.multiworld.command.SpawnCommand;
import me.isaiah.multiworld.command.TpCommand;
import me.isaiah.multiworld.perm.Perm;
import me.isaiah.multiworld.portal.Portal;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiworldMod {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"multiworld");
    public static final String MOD_ID = "multiworld";
    public static MinecraftServer mc;
    public static String CMD;
    public static ICreator world_creator;
    public static String[] COMMAND_HELP;
    public static final String VERSION = "1.10";
    private static final char COLOR_CHAR = '\u00a7';

    public static void setICreator(ICreator ic) {
        world_creator = ic;
    }

    public static ICreator get_world_creator() {
        return world_creator;
    }

    public static ServerLevel create_world(String id, ResourceLocation dim, ChunkGenerator gen, Difficulty dif, long seed) {
        return world_creator.create_world(id, dim, gen, dif, seed);
    }

    public static void init() {
        System.out.println("Multiworld init");
    }

    public static ResourceLocation new_id(String id) {
        return ResourceLocation.tryParse((String)id);
    }

    public static void on_server_started(MinecraftServer mc) {
        MultiworldMod.mc = mc;
        File cfg_folder = new File("config");
        if (cfg_folder.exists()) {
            int loaded;
            File folder = new File(cfg_folder, MOD_ID);
            File worlds = new File(folder, "worlds");
            if (worlds.exists()) {
                for (File f : worlds.listFiles()) {
                    if (f.getName().equals("minecraft")) continue;
                    for (File fi : f.listFiles()) {
                        String id = f.getName() + ":" + fi.getName().replace(".yml", "");
                        LOGGER.info("Found saved world " + id);
                        CreateCommand.reinit_world_from_config(mc, id);
                    }
                }
            }
            if ((loaded = Portal.reinit_portals_from_config(mc)) > 0) {
                LOGGER.info("Found " + loaded + " saved world portals.");
            }
        }
    }

    public static ServerPlayer get_player(CommandSourceStack s) throws CommandSyntaxException {
        ServerPlayer plr = s.getPlayer();
        if (null == plr) {
            throw CommandSourceStack.ERROR_NOT_PLAYER.create();
        }
        return plr;
    }

    public static boolean isPlayer(CommandSourceStack s) {
        block3: {
            try {
                ServerPlayer plr = s.getPlayer();
                if (null == plr) {
                    return false;
                }
            }
            catch (Exception ex) {
                if (!(ex instanceof CommandSyntaxException) || !s.getTextName().equalsIgnoreCase("Server")) break block3;
                return false;
            }
        }
        return true;
    }

    public static void register_commands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)CMD).requires(source -> {
            try {
                return source.hasPermission(1) || Perm.has(MultiworldMod.get_player(source), "multiworld.cmd") || Perm.has(MultiworldMod.get_player(source), "multiworld.admin");
            }
            catch (Exception e) {
                return source.hasPermission(1);
            }
        })).executes(ctx -> MultiworldMod.broadcast((CommandSourceStack)ctx.getSource(), ChatFormatting.AQUA, null))).then(Commands.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).suggests((SuggestionProvider)new InfoSuggest()).executes(ctx -> {
            try {
                return MultiworldMod.broadcast((CommandSourceStack)ctx.getSource(), ChatFormatting.AQUA, StringArgumentType.getString((CommandContext)ctx, (String)"message"));
            }
            catch (Exception e) {
                e.printStackTrace();
                return 1;
            }
        })));
    }

    public static int broadcast(CommandSourceStack source, ChatFormatting formatting, String message) throws CommandSyntaxException {
        if (!MultiworldMod.isPlayer(source)) {
            ConsoleCommand.broadcast_console(mc, source, message);
            return 1;
        }
        ServerPlayer plr = MultiworldMod.get_player(source);
        if (null == message) {
            MultiworldMod.message((Player)plr, "&bMultiworld Mod for Minecraft " + mc.getServerVersion());
            Level world2 = plr.level();
            ResourceLocation id = world2.dimension().location();
            MultiworldMod.message((Player)plr, "Currently in: " + id.toString());
            return 1;
        }
        boolean ALL = Perm.has(plr, "multiworld.admin");
        String[] args = message.split(" ");
        if (args[0].equalsIgnoreCase("help")) {
            for (String s : COMMAND_HELP) {
                MultiworldMod.message((Player)plr, s);
            }
        }
        if (args[0].equalsIgnoreCase("debugtick")) {
            ServerLevel w = (ServerLevel)plr.level();
            ResourceLocation id = w.dimension().location();
            MultiworldMod.message((Player)plr, "World ID: " + id.toString());
            MultiworldMod.message((Player)plr, "Players : " + w.players().size());
            w.tick(() -> true);
        }
        if (args[0].equalsIgnoreCase("setspawn") && (ALL || Perm.has(plr, "multiworld.setspawn"))) {
            return SetspawnCommand.run(mc, plr, args);
        }
        if (args[0].equalsIgnoreCase("spawn") && (ALL || Perm.has(plr, "multiworld.spawn"))) {
            return SpawnCommand.run(mc, plr, args);
        }
        if (args[0].equalsIgnoreCase("gamerule") && (ALL || Perm.has(plr, "multiworld.gamerule"))) {
            return GameruleCommand.run(mc, plr, args);
        }
        if (args[0].equalsIgnoreCase("difficulty") && (ALL || Perm.has(plr, "multiworld.difficulty"))) {
            return DifficultyCommand.run(mc, plr, args);
        }
        if (args[0].equalsIgnoreCase("tp")) {
            if (!ALL && !Perm.has(plr, "multiworld.tp")) {
                plr.displayClientMessage(Component.nullToEmpty((String)"No permission! Missing permission: multiworld.tp"), false);
                return 1;
            }
            if (args.length == 1) {
                plr.displayClientMessage(MultiworldMod.text_plain("Usage: /" + CMD + " tp <world>"), false);
                return 0;
            }
            return TpCommand.run(mc, plr, args);
        }
        if (args[0].equalsIgnoreCase("list")) {
            if (!ALL && !Perm.has(plr, "multiworld.cmd")) {
                plr.displayClientMessage(Component.nullToEmpty((String)"No permission! Missing permission: multiworld.cmd"), false);
                return 1;
            }
            MultiworldMod.message((Player)plr, "&bAll Worlds:");
            Level pworld = plr.level();
            ResourceLocation pwid = pworld.dimension().location();
            mc.getAllLevels().forEach(world -> {
                ResourceLocation id = world.dimension().location();
                String name = id.toString();
                if (name.startsWith("multiworld:")) {
                    name = name.replace("multiworld:", "");
                }
                if (id.equals((Object)pwid)) {
                    MultiworldMod.message((Player)plr, "- " + name + " &a(Currently in)");
                } else {
                    MultiworldMod.message((Player)plr, "- " + name);
                }
            });
        }
        if (args[0].equalsIgnoreCase("version") && (ALL || Perm.has(plr, "multiworld.cmd"))) {
            MultiworldMod.message((Player)plr, "Multiworld Mod version 1.10");
            return 1;
        }
        if (args[0].equalsIgnoreCase("create")) {
            if (!ALL && !Perm.has(plr, "multiworld.create")) {
                MultiworldMod.message((Player)plr, "No permission! Missing permission: multiworld.create");
                return 1;
            }
            return CreateCommand.run(mc, plr, args);
        }
        if (args[0].equalsIgnoreCase("delete")) {
            if (!ALL) {
                MultiworldMod.message((Player)plr, "No permission! Missing permission: multiworld.admin");
                return 1;
            }
            MultiworldMod.message((Player)plr, "Delete Command is Console-only for security.");
        }
        if (args[0].equalsIgnoreCase("portal")) {
            if (!ALL && !Perm.has(plr, "multiworld.portal")) {
                MultiworldMod.message((Player)plr, "No permission! Missing permission: multiworld.portal");
                return 1;
            }
            PortalCommand.run(mc, plr, args);
        }
        return 1;
    }

    public static Component text(String message) {
        try {
            return Component.nullToEmpty((String)MultiworldMod.translate_alternate_color_codes('&', message));
        }
        catch (Exception e) {
            e.printStackTrace();
            return MultiworldMod.text_plain(message);
        }
    }

    public static void message(Player player, String message) {
        try {
            player.displayClientMessage(Component.nullToEmpty((String)MultiworldMod.translate_alternate_color_codes('&', message)), false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String translate_alternate_color_codes(char altColorChar, String textToTranslate) {
        char[] b = textToTranslate.toCharArray();
        for (int i = 0; i < b.length - 1; ++i) {
            if (b[i] != altColorChar || "0123456789AaBbCcDdEeFfKkLlMmNnOoRr".indexOf(b[i + 1]) <= -1) continue;
            b[i] = 167;
            b[i + 1] = Character.toLowerCase(b[i + 1]);
        }
        return new String(b);
    }

    public static Component text_plain(String txt) {
        return Component.nullToEmpty((String)txt);
    }

    static {
        CMD = "mw";
        COMMAND_HELP = new String[]{"&4Multiworld Mod Commands:&r", "&a/mw spawn&r - Teleport to current world spawn", "&a/mw setspawn&r - Sets the current world spawn", "&a/mw tp <id>&r - Teleport to a world", "&a/mw list&r - List all worlds", "&a/mw gamerule <rule> <value>&r - Change a worlds Gamerules", "&a/mw create <id> <env> [-g=<generator> -s=<seed>]&r - create a new world", "&a/mw difficulty <value> [world id] - Sets the difficulty of a world"};
    }
}

