/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.util;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;

public class BiomeTooltip {
    private static long lastBiomeChangeTime;
    private static int biomePage;

    public static void listBiomes(TagKey<Biome> tag, ITooltipBuilder tooltip) {
        boolean isShift = Screen.hasShiftDown();
        Registry biomeReg = Minecraft.getInstance().getConnection().registryAccess().registryOrThrow(Registries.BIOME);
        biomeReg.getTag(tag).map(t -> {
            Stream<Holder> s = t.stream();
            int size = t.size();
            MutableComponent pg = null;
            if (size > 16) {
                if (!isShift && System.currentTimeMillis() - lastBiomeChangeTime > 2000L) {
                    if (++biomePage * 16 >= size) {
                        biomePage = 0;
                    }
                    lastBiomeChangeTime = System.currentTimeMillis();
                }
                pg = Component.translatable((String)"tooltip.coe.page", (Object[])new Object[]{biomePage + 1, size / 16 + 1});
                s = s.skip(biomePage * 16).limit(16L);
            }
            List comps = s.map(b -> BiomeTooltip.getBiomeId((Registry<Biome>)biomeReg, (Holder<Biome>)b)).map(b -> Component.translatable((String)("biome." + b.getNamespace() + "." + b.getPath()))).collect(Collectors.toList());
            if (pg != null) {
                comps.add(pg);
            }
            return comps;
        }).ifPresent(arg_0 -> ((ITooltipBuilder)tooltip).addAll(arg_0));
    }

    private static ResourceLocation getBiomeId(Registry<Biome> biomeReg, Holder<Biome> h) {
        try {
            if (h.kind() == Holder.Kind.DIRECT) {
                return biomeReg.getKey((Object)((Biome)h.value()));
            }
            return ((Holder.Reference)h).key().location();
        }
        catch (Exception e) {
            return ResourceLocation.parse((String)"null");
        }
    }

    public static void resetPage() {
        biomePage = 0;
        lastBiomeChangeTime = 0L;
    }
}

