/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.cc;

import com.tom.createores.Config;
import com.tom.createores.OreData;
import com.tom.createores.OreDataAttachment;
import com.tom.createores.Registration;
import com.tom.createores.cc.CCRegistration;
import com.tom.createores.recipe.VeinRecipe;
import com.tom.createores.util.ThreeState;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.AbstractTurtleUpgrade;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.upgrades.UpgradeType;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;

public class OreVeinFinderTurtle
extends AbstractTurtleUpgrade {
    protected OreVeinFinderTurtle() {
        super(TurtleUpgradeType.PERIPHERAL, "upgrade.createoreexcavation.vein_finder.adjective", Registration.VEIN_FINDER_ITEM.asStack());
    }

    public IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return new Peripheral(turtle);
    }

    public UpgradeType<? extends ITurtleUpgrade> getType() {
        return (UpgradeType)CCRegistration.VEIN_FINDER_TYPE.get();
    }

    public boolean isItemSuitable(ItemStack stack) {
        return stack.getItem() == Registration.VEIN_FINDER_ITEM.asItem();
    }

    public static class Peripheral
    implements IPeripheral {
        private final ITurtleAccess turtle;
        private AtomicLong time = new AtomicLong();

        public Peripheral(ITurtleAccess turtle) {
            this.turtle = turtle;
        }

        public String getType() {
            return "coe_vein_finder";
        }

        public boolean equals(IPeripheral other) {
            return other instanceof Peripheral;
        }

        public Object getTarget() {
            return this.turtle;
        }

        @LuaFunction
        public final MethodResult search() throws LuaException {
            return this.turtle.executeCommand((TurtleCommand)new VeinFinderCommand(this.time));
        }

        @LuaFunction
        public final MethodResult getCooldown() throws LuaException {
            return this.turtle.executeCommand(new TurtleCommand(){

                public TurtleCommandResult execute(ITurtleAccess turtle) {
                    long t = turtle.getLevel().getGameTime();
                    long dt = t - time.get();
                    long rem = Math.max(0L, (long)Config.veinFinderCd - dt);
                    return TurtleCommandResult.success((Object[])new Object[]{(double)rem});
                }
            });
        }
    }

    private static class VeinFinderCommand
    implements TurtleCommand {
        private AtomicLong time;

        public VeinFinderCommand(AtomicLong time) {
            this.time = time;
        }

        public TurtleCommandResult execute(ITurtleAccess turtle) {
            long time = turtle.getLevel().getGameTime();
            if (time - this.time.get() < (long)Config.veinFinderCd) {
                return TurtleCommandResult.failure((String)"Ore Vein Finder on cooldown");
            }
            if (!turtle.getLevel().getBlockState(turtle.getPosition().below()).isCollisionShapeFullBlock((BlockGetter)turtle.getLevel(), turtle.getPosition().below())) {
                return TurtleCommandResult.failure((String)"Ore Vein Finder requires a full block below the turtle");
            }
            if (turtle.isFuelNeeded() && turtle.getFuelLevel() < 5) {
                return TurtleCommandResult.failure((String)"Ouf of fuel");
            }
            ChunkPos center = new ChunkPos(turtle.getPosition());
            OreData d = OreDataAttachment.getData(turtle.getLevel().getChunk(center.x, center.z));
            ArrayList<Object> result = new ArrayList<Object>();
            RecipeManager m = turtle.getLevel().getRecipeManager();
            if (d != null) {
                RecipeHolder<VeinRecipe> rec = d.getRecipe(m);
                result.add(rec != null);
                if (rec != null) {
                    result.add(rec.id().toString());
                    result.add(Double.valueOf(this.getVeinSize(d, (VeinRecipe)rec.value())));
                }
            } else {
                result.add(false);
            }
            if (turtle.isFuelNeeded()) {
                turtle.consumeFuel(5);
            }
            this.time.set(time);
            return TurtleCommandResult.success((Object[])result.toArray());
        }

        private long getVeinSize(OreData d, VeinRecipe r) {
            if (r.isFinite() != ThreeState.NEVER) {
                if (r.isFinite() == ThreeState.DEFAULT && Config.defaultInfinite) {
                    return 0L;
                }
                double mul = (r.getMaxAmount() - r.getMinAmount()) * d.getRandomMul() + r.getMinAmount();
                long am = Math.round(mul * (double)Config.finiteAmountBase);
                return am;
            }
            return 0L;
        }
    }
}

