/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.block.entity;

import com.tom.createores.block.entity.ExcavatingBlockEntity;
import com.tom.createores.recipe.ExcavatingRecipe;
import com.tom.createores.util.IOBlockType;
import com.tom.createores.util.TooltipUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public abstract class ExcavatingBlockEntityImpl<R extends ExcavatingRecipe>
extends ExcavatingBlockEntity<R> {
    protected FluidTank fluidTank = new FluidTank(16000){

        protected void onContentsChanged() {
            ExcavatingBlockEntityImpl.this.notifyUpdate();
        }
    };

    protected ExcavatingBlockEntityImpl(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public <T> T getCaps(BlockCapability<T, Direction> cap, IOBlockType type) {
        if (type == IOBlockType.FLUID_IN && cap == Capabilities.FluidHandler.BLOCK) {
            return (T)this.fluidTank;
        }
        return null;
    }

    @Override
    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.fluidTank.readFromNBT(registries, tag.getCompound(this.getTankInName()));
    }

    @Override
    public void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        tag.put(this.getTankInName(), (Tag)this.fluidTank.writeToNBT(registries, new CompoundTag()));
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        TooltipUtil.forGoggles(tooltip, Component.translatable((String)"info.coe.drill.fluidInfo"));
        this.containedFluidTooltip(tooltip, isPlayerSneaking, (IFluidHandler)this.fluidTank);
        return true;
    }

    @Override
    public void addToGoggleTooltip(List<Component> tooltip, R rec) {
        ((ExcavatingRecipe)rec).getDrillingFluid().ifPresent(fluid -> {
            if (!fluid.test(this.fluidTank.getFluid()) || this.fluidTank.getFluidAmount() < fluid.getRequiredAmount()) {
                TooltipUtil.forGoggles(tooltip, Component.translatable((String)"info.coe.drill.noFluid"));
            }
        });
    }

    @Override
    protected boolean validateRecipe(R recipe) {
        return super.validateRecipe(recipe) && (((ExcavatingRecipe)recipe).getDrillingFluid().isEmpty() || ((ExcavatingRecipe)recipe).getDrillingFluid().get().test(this.fluidTank.getFluid()));
    }

    @Override
    protected boolean canExtract() {
        return ((ExcavatingRecipe)this.current.value()).getDrillingFluid().isEmpty() || ((ExcavatingRecipe)this.current.value()).getDrillingFluid().get().test(this.fluidTank.getFluid()) && this.fluidTank.getFluidAmount() >= ((ExcavatingRecipe)this.current.value()).getDrillingFluid().get().getRequiredAmount();
    }

    @Override
    protected void onFinished() {
        ((ExcavatingRecipe)this.current.value()).getDrillingFluid().ifPresent(fluid -> this.fluidTank.drain(fluid.getRequiredAmount(), IFluidHandler.FluidAction.EXECUTE));
    }

    protected String getTankInName() {
        return "tank";
    }
}

