/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.entity;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.world.item.PhotographFrameItem;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class PhotographFrameEntity
extends HangingEntity {
    public static final Logger LOGGER = Exposure.LOGGER;
    protected static final EntityDataAccessor<Integer> DATA_SIZE = SynchedEntityData.defineId(PhotographFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<ItemStack> DATA_FRAME_ITEM = SynchedEntityData.defineId(PhotographFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    protected static final EntityDataAccessor<ItemStack> DATA_ITEM = SynchedEntityData.defineId(PhotographFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    protected static final EntityDataAccessor<Integer> DATA_ITEM_ROTATION = SynchedEntityData.defineId(PhotographFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Boolean> DATA_GLOWING = SynchedEntityData.defineId(PhotographFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected int size = 0;

    public PhotographFrameEntity(EntityType<? extends PhotographFrameEntity> entityType, Level level) {
        super(entityType, level);
    }

    public PhotographFrameEntity(Level level, BlockPos pos, Direction facingDirection) {
        this(Exposure.EntityTypes.PHOTOGRAPH_FRAME.get(), level, pos, facingDirection);
    }

    protected PhotographFrameEntity(EntityType<? extends PhotographFrameEntity> entityType, Level level, BlockPos pos, Direction facingDirection) {
        super(entityType, level, pos);
        this.setDirection(facingDirection);
        this.setItem(ItemStack.EMPTY);
    }

    public Component getDisplayName() {
        ItemStack item = this.getItem();
        return !item.isEmpty() ? item.getHoverName() : CommonComponents.EMPTY;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        if (!this.level().isClientSide) {
            double d = 64.0 * PhotographFrameEntity.getViewScale();
            return distance < d * d;
        }
        double d = (double)((Integer)Config.Client.PHOTOGRAPH_FRAME_CULLING_DISTANCE.get()).intValue() * PhotographFrameEntity.getViewScale();
        return distance < d * d;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (key.equals(DATA_ITEM)) {
            this.onItemChanged(this.getItem());
        }
        if (key.equals(DATA_SIZE)) {
            this.size = (Integer)this.getEntityData().get(DATA_SIZE);
            this.recalculateBoundingBox();
        }
    }

    public void recreateFromPacket(@NotNull ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        int packedData = packet.getData();
        int size = packedData >> 8 & 0xFF;
        int direction = packedData & 0xFF;
        this.setSize(size);
        this.setDirection(Direction.from3DDataValue((int)direction));
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        int packedData = this.size << 8 | this.direction.get3DDataValue();
        return new ClientboundAddEntityPacket((Entity)this, packedData, this.getPos());
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        ItemStack frameItem;
        super.addAdditionalSaveData(tag);
        ItemStack item = this.getItem();
        if (!item.isEmpty()) {
            tag.put("Item", item.save((HolderLookup.Provider)this.registryAccess()));
            tag.putBoolean("IsGlowing", this.isGlowing());
            tag.putByte("ItemRotation", (byte)this.getItemRotation());
        }
        if (!(frameItem = this.getFrameItem()).isEmpty()) {
            tag.put("FrameItem", frameItem.save((HolderLookup.Provider)this.registryAccess()));
        }
        tag.putByte("Size", (byte)this.getSize());
        tag.putByte("Facing", (byte)this.direction.get3DDataValue());
        tag.putBoolean("Invisible", this.isInvisible());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        CompoundTag itemTag;
        super.readAdditionalSaveData(tag);
        CompoundTag frameItemTag = tag.getCompound("FrameItem");
        if (!frameItemTag.isEmpty()) {
            ItemStack stack = ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)frameItemTag).orElse(new ItemStack((ItemLike)this.getBaseFrameItem()));
            this.setFrameItem(stack);
        }
        if (!(itemTag = tag.getCompound("Item")).isEmpty()) {
            ItemStack itemstack = ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)itemTag).orElse(ItemStack.EMPTY);
            this.setItem(itemstack);
            this.setGlowing(tag.getBoolean("IsGlowing"));
            this.setItemRotation(tag.getByte("ItemRotation"));
        }
        this.setSize(tag.getByte("Size"));
        this.setDirection(Direction.from3DDataValue((int)tag.getByte("Facing")));
        this.setInvisible(tag.getBoolean("Invisible"));
    }

    @NotNull
    public Vec3 trackingPosition() {
        return Vec3.atLowerCornerOf((Vec3i)this.pos);
    }

    public int getWidth() {
        return this.getSize() * 16 + 16;
    }

    public int getHeight() {
        return this.getSize() * 16 + 16;
    }

    @Nullable
    public ItemStack getPickResult() {
        ItemStack item = this.getItem();
        if (!item.isEmpty()) {
            return item.copy();
        }
        return this.getFrameItem().copy();
    }

    @NotNull
    protected AABB calculateBoundingBox(BlockPos pos, Direction direction) {
        double heightOffset;
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.5;
        double z = (double)pos.getZ() + 0.5;
        double widthOffset = this.getWidth() % 32 == 0 ? 0.5 : 0.0;
        double d = heightOffset = this.getHeight() % 32 == 0 ? 0.5 : 0.0;
        if (this.getSize() == 2) {
            widthOffset += 1.0;
            heightOffset += 1.0;
        }
        double hangOffset = 0.46875;
        if (direction.getAxis().isHorizontal()) {
            x -= (double)this.getDirection().getStepX() * hangOffset;
            z -= (double)this.getDirection().getStepZ() * hangOffset;
            Direction ccwDirection = direction.getCounterClockWise();
            this.setPosRaw(x += widthOffset * (double)ccwDirection.getStepX(), y += heightOffset, z += widthOffset * (double)ccwDirection.getStepZ());
            double xSize = this.getWidth();
            double ySize = this.getHeight();
            double zSize = this.getWidth();
            if (this.getDirection().getAxis() == Direction.Axis.Z) {
                zSize = 1.0;
            } else {
                xSize = 1.0;
            }
            return new AABB(x - (xSize /= 32.0), y - (ySize /= 32.0), z - (zSize /= 32.0), x + xSize, y + ySize, z + zSize);
        }
        this.setPosRaw(x += widthOffset, y -= (double)this.getDirection().getStepY() * hangOffset, z -= heightOffset);
        double xSize = this.getWidth();
        double zSize = this.getHeight();
        return new AABB(x - (xSize /= 32.0), y - 0.03125, z - (zSize /= 32.0), x + xSize, y + 0.03125, z + zSize);
    }

    public boolean survives() {
        if (!this.level().noCollision((Entity)this)) {
            return false;
        }
        int sizeX = Math.max(1, this.getWidth() / 16);
        int sizeY = Math.max(1, this.getHeight() / 16);
        BlockPos baseBlockPos = this.pos.relative(this.direction.getOpposite());
        if (this.getDirection().getAxis().isHorizontal()) {
            Direction direction = this.getDirection().getCounterClockWise();
            BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
            for (int pX = 0; pX < sizeX; ++pX) {
                for (int pY = 0; pY < sizeY; ++pY) {
                    mPos.set((Vec3i)baseBlockPos).move(direction, pX).move(Direction.UP, pY);
                    BlockState blockState = this.level().getBlockState((BlockPos)mPos);
                    if (blockState.isSolid() || DiodeBlock.isDiode((BlockState)blockState)) continue;
                    return false;
                }
            }
        } else {
            BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
            for (int pX = 0; pX < sizeX; ++pX) {
                for (int pY = 0; pY < sizeY; ++pY) {
                    mPos.set((Vec3i)baseBlockPos).move(Direction.NORTH, pX).move(Direction.EAST, pY);
                    BlockState blockState = this.level().getBlockState((BlockPos)mPos);
                    if (blockState.isSolid() || DiodeBlock.isDiode((BlockState)blockState)) continue;
                    return false;
                }
            }
        }
        return this.level().getEntities((Entity)this, this.getBoundingBox(), HANGING_ENTITY).isEmpty();
    }

    protected void setDirection(@NotNull Direction facingDirection) {
        Preconditions.checkNotNull((Object)facingDirection);
        this.direction = facingDirection;
        if (facingDirection.getAxis().isHorizontal()) {
            this.setXRot(0.0f);
            this.setYRot(this.direction.get2DDataValue() * 90);
        } else {
            this.setXRot(-90 * facingDirection.getAxisDirection().getStep());
            this.setYRot(0.0f);
        }
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
        this.recalculateBoundingBox();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.getEntityData().set(DATA_SIZE, (Object)Mth.clamp((int)size, (int)0, (int)2));
        this.size = size;
        this.recalculateBoundingBox();
    }

    public PhotographFrameItem getBaseFrameItem() {
        return Exposure.Items.PHOTOGRAPH_FRAME.get();
    }

    public ItemStack getFrameItem() {
        return (ItemStack)this.getEntityData().get(DATA_FRAME_ITEM);
    }

    public void setFrameItem(ItemStack stack) {
        this.getEntityData().set(DATA_FRAME_ITEM, (Object)stack);
    }

    public ItemStack getItem() {
        return (ItemStack)this.getEntityData().get(DATA_ITEM);
    }

    public void setItem(ItemStack stack) {
        this.getEntityData().set(DATA_ITEM, (Object)stack);
    }

    protected void onItemChanged(ItemStack itemStack) {
        if (!itemStack.isEmpty()) {
            itemStack.setEntityRepresentation((Entity)this);
        }
    }

    public int getItemRotation() {
        return (Integer)this.getEntityData().get(DATA_ITEM_ROTATION);
    }

    public void setItemRotation(int rotation) {
        this.getEntityData().set(DATA_ITEM_ROTATION, (Object)(rotation % 4));
    }

    public boolean isGlowing() {
        return (Boolean)this.getEntityData().get(DATA_GLOWING);
    }

    public void setGlowing(boolean glowing) {
        this.getEntityData().set(DATA_GLOWING, (Object)glowing);
    }

    public boolean isFrameInvisible() {
        return this.isInvisible();
    }

    @NotNull
    public InteractionResult interact(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemInHand = player.getItemInHand(hand);
        if (itemInHand.getItem() instanceof PhotographItem && this.getItem().isEmpty()) {
            this.setItem(itemInHand.copy());
            itemInHand.shrink(1);
            this.gameEvent((Holder)GameEvent.BLOCK_CHANGE, (Entity)player);
            this.playSound(this.getAddItemSound(), 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (itemInHand.is(Items.GLOW_INK_SAC) && !this.isGlowing()) {
            this.setGlowing(true);
            itemInHand.shrink(1);
            if (!this.level().isClientSide) {
                this.playSound(SoundEvents.GLOW_INK_SAC_USE);
                this.gameEvent((Holder)GameEvent.BLOCK_CHANGE, (Entity)player);
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.getItem().isEmpty()) {
            if (!this.level().isClientSide) {
                this.playSound(this.getRotateSound(), 1.0f, this.level().getRandom().nextFloat() * 0.2f + 0.9f);
                this.setItemRotation(this.getItemRotation() + 1);
                this.gameEvent((Holder)GameEvent.BLOCK_CHANGE, (Entity)player);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean hurt(@NotNull DamageSource damageSource, float amount) {
        if (this.isInvulnerableTo(damageSource)) {
            return false;
        }
        if (!damageSource.is(DamageTypeTags.IS_EXPLOSION) && !this.getItem().isEmpty()) {
            if (!this.level().isClientSide) {
                this.dropItem(damageSource.getEntity(), false);
                this.gameEvent((Holder)GameEvent.BLOCK_CHANGE, damageSource.getEntity());
                this.playSound(this.getRemoveItemSound(), 1.0f, 1.0f);
            }
            return true;
        }
        return super.hurt(damageSource, amount);
    }

    public void dropItem(@Nullable Entity brokenEntity) {
        this.playSound(this.getBreakSound(), 1.0f, 1.0f);
        this.dropItem(brokenEntity, true);
        this.gameEvent((Holder)GameEvent.BLOCK_CHANGE, brokenEntity);
    }

    protected void dropItem(@Nullable Entity entity, boolean dropSelf) {
        float yOffset;
        Player player;
        ItemStack itemStack = this.getItem();
        this.setItem(ItemStack.EMPTY);
        if (!this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            return;
        }
        if (entity instanceof Player && (player = (Player)entity).isCreative()) {
            return;
        }
        float f = yOffset = this.getDirection() == Direction.DOWN ? -0.3f : 0.0f;
        if (dropSelf) {
            this.spawnAtLocation(this.getFrameItem(), yOffset);
        }
        if (!itemStack.isEmpty()) {
            this.spawnAtLocation(itemStack.copy(), yOffset);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_SIZE, (Object)0);
        builder.define(DATA_FRAME_ITEM, (Object)ItemStack.EMPTY);
        builder.define(DATA_ITEM, (Object)ItemStack.EMPTY);
        builder.define(DATA_ITEM_ROTATION, (Object)0);
        builder.define(DATA_GLOWING, (Object)false);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide && this.isGlowing() && this.level().getRandom().nextFloat() < 0.003f) {
            AABB bb = this.getBoundingBox();
            Vec3i normal = this.getDirection().getNormal();
            this.level().addParticle((ParticleOptions)ParticleTypes.END_ROD, this.position().x + ((double)this.level().getRandom().nextFloat() * (bb.getXsize() * 0.75) - bb.getXsize() * 0.75 / 2.0), this.position().y + ((double)this.level().getRandom().nextFloat() * (bb.getYsize() * 0.75) - bb.getYsize() * 0.75 / 2.0), this.position().z + ((double)this.level().getRandom().nextFloat() * (bb.getZsize() * 0.75) - bb.getZsize() * 0.75 / 2.0), (double)(this.level().getRandom().nextFloat() * 0.02f * (float)normal.getX()), (double)(this.level().getRandom().nextFloat() * 0.02f * (float)normal.getY()), (double)(this.level().getRandom().nextFloat() * 0.02f * (float)normal.getZ()));
        }
    }

    @NotNull
    public SlotAccess getSlot(int slot) {
        if (slot == 0) {
            return new SlotAccess(){

                @NotNull
                public ItemStack get() {
                    return PhotographFrameEntity.this.getItem();
                }

                public boolean set(ItemStack carried) {
                    PhotographFrameEntity.this.setItem(carried);
                    return true;
                }
            };
        }
        return super.getSlot(slot);
    }

    @NotNull
    protected Component getTypeName() {
        if (this.isGlowing()) {
            return Component.translatable((String)"entity.exposure.glow_photograph_frame");
        }
        return super.getTypeName();
    }

    public void playPlacementSound() {
        this.playSound(this.getPlaceSound(), 1.0f, this.level().getRandom().nextFloat() * 0.2f + 0.7f);
    }

    public SoundEvent getPlaceSound() {
        return Exposure.SoundEvents.PHOTOGRAPH_FRAME_PLACE.get();
    }

    public SoundEvent getBreakSound() {
        return Exposure.SoundEvents.PHOTOGRAPH_FRAME_BREAK.get();
    }

    public SoundEvent getAddItemSound() {
        return Exposure.SoundEvents.PHOTOGRAPH_FRAME_ADD_ITEM.get();
    }

    public SoundEvent getRemoveItemSound() {
        return Exposure.SoundEvents.PHOTOGRAPH_FRAME_REMOVE_ITEM.get();
    }

    public SoundEvent getRotateSound() {
        return Exposure.SoundEvents.PHOTOGRAPH_FRAME_ROTATE_ITEM.get();
    }
}

