/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.integration.jade.component_provider;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.integration.jade.ExposureJadePlugin;
import io.github.mortuusars.exposure.world.block.entity.LightroomBlockEntity;
import io.github.mortuusars.exposure.world.lightroom.PrintingMode;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ItemView;
import snownee.jade.api.view.ViewGroup;

public enum LightroomComponentProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig iPluginConfig) {
        ItemStack paper;
        CompoundTag tag = accessor.getServerData();
        if (tag.getBoolean("Empty")) {
            return;
        }
        IElementHelper helper = IElementHelper.get();
        tooltip.add(helper.spacer(0, 0));
        ItemStack film = ItemStack.parseOptional((HolderLookup.Provider)accessor.getLevel().registryAccess(), (CompoundTag)tag.getCompound("Film"));
        if (!film.isEmpty()) {
            tooltip.append(helper.item(film));
            tooltip.append(helper.text((Component)Component.literal((String)"|").withStyle(ChatFormatting.GRAY)).size(new Vec2(11.0f, 12.0f)).translate(new Vec2(5.0f, 6.0f)).message(null));
        }
        if (!(paper = ItemStack.parseOptional((HolderLookup.Provider)accessor.getLevel().registryAccess(), (CompoundTag)tag.getCompound("Paper"))).isEmpty()) {
            tooltip.append(helper.item(paper));
            tooltip.append(helper.text((Component)Component.literal((String)"+").withStyle(ChatFormatting.GRAY)).size(new Vec2(12.0f, 12.0f)).translate(new Vec2(5.0f, 6.0f)).message(null));
        }
        for (String dye : new String[]{"Cyan", "Yellow", "Magenta", "Black"}) {
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)accessor.getLevel().registryAccess(), (CompoundTag)tag.getCompound(dye));
            if (stack.isEmpty()) continue;
            tooltip.append(helper.item(stack));
        }
        tooltip.append(helper.progress(tag.getFloat("Progress")));
        tooltip.append(helper.item(ItemStack.parseOptional((HolderLookup.Provider)accessor.getLevel().registryAccess(), (CompoundTag)tag.getCompound("Result"))));
        PrintingMode process = PrintingMode.fromStringOrDefault(tag.getString("Process"), PrintingMode.REGULAR);
        if (process != PrintingMode.REGULAR) {
            tooltip.add((IElement)helper.text((Component)Component.translatable((String)("gui.exposure.lightroom.printing_mode." + process.getSerializedName()))));
        }
        tooltip.add(helper.spacer(0, 2));
    }

    public void appendServerData(CompoundTag tag, BlockAccessor blockAccessor) {
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof LightroomBlockEntity) {
            LightroomBlockEntity lightroomBlockEntity = (LightroomBlockEntity)blockEntity;
            if (lightroomBlockEntity.isEmpty()) {
                tag.putBoolean("Empty", true);
                return;
            }
            tag.put("Film", lightroomBlockEntity.getItem(0).saveOptional((HolderLookup.Provider)blockAccessor.getLevel().registryAccess()));
            tag.put("Paper", lightroomBlockEntity.getItem(1).saveOptional((HolderLookup.Provider)blockAccessor.getLevel().registryAccess()));
            tag.put("Cyan", lightroomBlockEntity.getItem(2).saveOptional((HolderLookup.Provider)blockAccessor.getLevel().registryAccess()));
            tag.put("Yellow", lightroomBlockEntity.getItem(4).saveOptional((HolderLookup.Provider)blockAccessor.getLevel().registryAccess()));
            tag.put("Magenta", lightroomBlockEntity.getItem(3).saveOptional((HolderLookup.Provider)blockAccessor.getLevel().registryAccess()));
            tag.put("Black", lightroomBlockEntity.getItem(5).saveOptional((HolderLookup.Provider)blockAccessor.getLevel().registryAccess()));
            tag.put("Result", lightroomBlockEntity.getItem(6).saveOptional((HolderLookup.Provider)blockAccessor.getLevel().registryAccess()));
            tag.putString("Process", lightroomBlockEntity.getActualPrintingMode().getSerializedName());
            tag.putFloat("Progress", lightroomBlockEntity.getProgressPercentage());
        }
    }

    public boolean shouldRequestData(BlockAccessor accessor) {
        return true;
    }

    public ResourceLocation getUid() {
        return ExposureJadePlugin.LIGHTROOM;
    }

    public static class EmptyItemStackExtensionProvider
    implements IServerExtensionProvider<ItemStack>,
    IClientExtensionProvider<ItemStack, ItemView> {
        public static final ResourceLocation ID = Exposure.resource("empty");
        public static final EmptyItemStackExtensionProvider INSTANCE = new EmptyItemStackExtensionProvider();

        private EmptyItemStackExtensionProvider() {
        }

        @Nullable
        public List<ViewGroup<ItemStack>> getGroups(Accessor<?> accessor) {
            return Collections.emptyList();
        }

        public ResourceLocation getUid() {
            return ID;
        }

        public List<ClientViewGroup<ItemView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<ItemStack>> list) {
            return Collections.emptyList();
        }
    }
}

