/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.commands.exposure;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.commands.argument.TextureLocationArgument;
import io.github.mortuusars.exposure.commands.suggestion.ExposureIdSuggestionProvider;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.clientbound.ExposureDataResponseS2CP;
import io.github.mortuusars.exposure.network.packet.clientbound.ShowExposureCommandS2CP;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.level.storage.ExposureIdentifier;
import io.github.mortuusars.exposure.world.level.storage.RequestedPalettedExposure;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class ShowCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"show").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"latest").executes(context -> ShowCommand.latest((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException(), false))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> ShowCommand.latest((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), false))).then(Commands.literal((String)"negative").executes(context -> ShowCommand.latest((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), true))))).then(Commands.literal((String)"negative").executes(context -> ShowCommand.latest((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException(), true))))).then(Commands.literal((String)"id").then(((RequiredArgumentBuilder)Commands.argument((String)"id", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new ExposureIdSuggestionProvider()).executes(context -> ShowCommand.exposureId((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"id"), false))).then(Commands.literal((String)"negative").executes(context -> ShowCommand.exposureId((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"id"), true)))))).then(Commands.literal((String)"texture").then(((RequiredArgumentBuilder)Commands.argument((String)"path", (ArgumentType)new TextureLocationArgument()).executes(context -> ShowCommand.texture((CommandSourceStack)context.getSource(), ResourceLocationArgument.getId((CommandContext)context, (String)"path"), false))).then(Commands.literal((String)"negative").executes(context -> ShowCommand.texture((CommandSourceStack)context.getSource(), ResourceLocationArgument.getId((CommandContext)context, (String)"path"), true)))));
    }

    private static int latest(CommandSourceStack stack, @NotNull ServerPlayer player, boolean negative) {
        List<Frame> frames = ExposureServer.frameHistory().getFramesOf((Entity)player);
        if (frames.isEmpty()) {
            stack.sendFailure((Component)Component.literal((String)(player.getScoreboardName() + " has not taken any photos yet.")));
            return 0;
        }
        Packets.sendToClient(new ShowExposureCommandS2CP(frames, negative), player);
        return 0;
    }

    private static int exposureId(CommandSourceStack stack, String id, boolean negative) {
        ServerPlayer player = stack.getPlayer();
        if (player == null) {
            stack.sendFailure((Component)Component.translatable((String)"command.exposure.show.error.not_a_player"));
            return 1;
        }
        RequestedPalettedExposure palettedExposure = ExposureServer.exposureRepository().load(id);
        if (palettedExposure.getData().isEmpty()) {
            stack.sendFailure((Component)Component.translatable((String)"command.exposure.show.error.not_found", (Object[])new Object[]{id}));
            return 0;
        }
        Packets.sendToClient(new ExposureDataResponseS2CP(id, palettedExposure), player);
        Packets.sendToClient(ShowExposureCommandS2CP.identifier(ExposureIdentifier.id(id), negative), player);
        return 0;
    }

    private static int texture(CommandSourceStack stack, ResourceLocation path, boolean negative) {
        ServerPlayer player = stack.getPlayer();
        if (player == null) {
            stack.sendFailure((Component)Component.translatable((String)"command.exposure.show.error.not_a_player"));
            return 1;
        }
        ExposureIdentifier identifier = ExposureIdentifier.texture(path);
        Packets.sendToClient(ShowExposureCommandS2CP.identifier(identifier, negative), player);
        return 0;
    }
}

