/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.render.model;

import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.PlatformHelperClient;
import io.github.mortuusars.exposure.client.render.model.CompositeModel;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.world.item.camera.Attachment;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import java.util.ArrayList;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class CameraModel {
    public static BakedModel modifyCameraModel(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed, BakedModel original) {
        Item item = stack.getItem();
        if (!(item instanceof CameraItem)) {
            return original;
        }
        CameraItem camera = (CameraItem)item;
        ArrayList<BakedModel> models = new ArrayList<BakedModel>();
        if (camera.isInSelfieMode(stack)) {
            if (entity != null && entity.equals((Object)Minecrft.get().getCameraEntity())) {
                return PlatformHelperClient.getModel(ExposureClient.Models.SELFIE_STICK);
            }
            original = CameraModel.getModelWithOverrides(ExposureClient.Models.CAMERA_SELFIE, stack, level, entity, seed);
            models.add(CameraModel.getModelWithOverrides(ExposureClient.Models.CAMERA_SELFIE_STICK, stack, level, entity, seed));
        } else if (camera.isActive(stack)) {
            original = CameraModel.getModelWithOverrides(ExposureClient.Models.CAMERA_ACTIVE, stack, level, entity, seed);
            models.add(CameraModel.getModelWithOverrides(ExposureClient.Models.CAMERA_VIEWFINDER, stack, level, entity, seed));
        }
        if (Attachment.FLASH.isPresent(stack)) {
            models.add(CameraModel.getModelWithOverrides(ExposureClient.Models.CAMERA_FLASH, stack, level, entity, seed));
        }
        if (Attachment.LENS.isPresent(stack)) {
            models.add(CameraModel.getModelWithOverrides(ExposureClient.Models.CAMERA_LENS, stack, level, entity, seed));
        }
        if (!models.isEmpty()) {
            models.addFirst(original);
            return new CompositeModel(models);
        }
        return original;
    }

    private static BakedModel getModelWithOverrides(ModelResourceLocation location, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
        BakedModel model = PlatformHelperClient.getModel(location);
        return model.getOverrides().resolve(model, stack, level, entity, seed);
    }
}

