/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.animation;

import io.github.mortuusars.exposure.client.animation.EasingFunction;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.world.entity.CameraOperator;
import io.github.mortuusars.exposure.world.entity.CameraStandEntity;
import net.minecraft.client.CameraType;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class CameraPoses {
    public void applyHolding(HumanoidModel<?> model, LivingEntity entity, HumanoidArm arm) {
        boolean rightHanded = arm == HumanoidArm.RIGHT;
        ModelPart mainHand = rightHanded ? model.rightArm : model.leftArm;
        ModelPart offHand = rightHanded ? model.leftArm : model.rightArm;
        model.head.xRot += 0.4f;
        model.head.xRot = Math.clamp(model.head.xRot, -1.0f, 1.15f);
        mainHand.yRot = (rightHanded ? -0.3f : 0.3f) + model.head.yRot;
        offHand.yRot = (rightHanded ? 0.5f : -0.5f) + model.head.yRot;
        mainHand.xRot = model.head.xRot - 1.5f;
        offHand.xRot = model.head.xRot - 1.5f;
        float actionAnim = this.getCameraActionAnim(entity);
        offHand.xRot = offHand.xRot + actionAnim * 0.1f * (float)(rightHanded ? 1 : -1);
        offHand.yRot = offHand.yRot + actionAnim * 0.1f * (float)(rightHanded ? 1 : -1);
        model.head.xRot += 0.3f;
        model.hat.copyFrom(model.head);
    }

    public void applySelfie(HumanoidModel<?> model, LivingEntity entity, HumanoidArm arm, boolean undoArmBobbing) {
        ModelPart cameraArm = arm == HumanoidArm.RIGHT ? model.rightArm : model.leftArm;
        cameraArm.xRot = model.head.xRot + Math.abs(model.head.xRot * 0.13f) + -1.5707964f;
        cameraArm.yRot = model.head.yRot;
        if (Minecrft.get().cameraEntity == entity) {
            cameraArm.yRot = cameraArm.yRot + (arm == HumanoidArm.RIGHT ? -0.25f : 0.25f);
        }
        cameraArm.zRot = model.head.xRot <= 0.0f ? model.head.xRot * 0.15f * (float)(arm == HumanoidArm.RIGHT ? -1 : 1) : model.head.xRot * 0.22f * (float)(arm == HumanoidArm.RIGHT ? -1 : 1);
    }

    public void applyDisassembled(HumanoidModel<?> model, LivingEntity entity, HumanoidArm arm) {
        if (Minecrft.player().equals((Object)entity) && Minecrft.options().getCameraType() == CameraType.FIRST_PERSON) {
            return;
        }
        model.head.xRot += 0.4f;
        model.head.xRot = Math.clamp(model.head.xRot, -0.75f, 0.75f);
        boolean rightHanded = arm == HumanoidArm.RIGHT;
        ModelPart mainHand = rightHanded ? model.rightArm : model.leftArm;
        ModelPart offHand = rightHanded ? model.leftArm : model.rightArm;
        mainHand.yRot = (rightHanded ? -0.6f : 0.6f) + model.head.yRot;
        offHand.yRot = (rightHanded ? 0.6f : -0.6f) + model.head.yRot;
        mainHand.xRot = model.head.xRot - 1.5f;
        offHand.xRot = model.head.xRot - 1.5f;
        float actionAnim = this.getCameraActionAnim(entity);
        offHand.xRot = offHand.xRot + actionAnim * 0.1f * (float)(rightHanded ? 1 : -1);
        offHand.yRot = offHand.yRot + actionAnim * 0.1f * (float)(rightHanded ? 1 : -1);
        model.head.xRot += 0.3f;
        model.hat.copyFrom(model.head);
    }

    public void applyStand(HumanoidModel<?> model, LivingEntity entity, HumanoidArm arm, CameraStandEntity stand) {
        boolean rightHanded = arm == HumanoidArm.RIGHT;
        ModelPart mainHand = rightHanded ? model.rightArm : model.leftArm;
        ModelPart offHand = rightHanded ? model.leftArm : model.rightArm;
        Vec3 direction = entity.getEyePosition().subtract(stand.getEyePosition());
        float yawToStandDegrees = (float)Mth.wrapDegrees((double)(Math.toDegrees(Math.atan2(direction.x, direction.z)) + 180.0));
        float bodyRotDegrees = entity.yBodyRot;
        float yawDegrees = Mth.wrapDegrees((float)(bodyRotDegrees + yawToStandDegrees));
        yawDegrees = Mth.clamp((float)yawDegrees, (float)-60.0f, (float)60.0f);
        float yaw = (float)Math.toRadians(yawDegrees);
        model.head.yRot = -yaw;
        double distanceXZ = Math.sqrt(direction.x * direction.x + direction.z * direction.z);
        float pitch = (float)Math.atan2(-direction.y, distanceXZ);
        model.head.xRot = -pitch;
        model.hat.copyFrom(model.head);
        mainHand.yRot = (rightHanded ? -0.2f : 0.2f) + model.head.yRot;
        offHand.yRot = (rightHanded ? 0.2f : -0.2f) + model.head.yRot;
        mainHand.xRot = -1.2f;
        offHand.xRot = -1.2f;
        float actionAnim = this.getCameraActionAnim(entity);
        offHand.xRot = offHand.xRot + actionAnim * 0.1f * (float)(rightHanded ? 1 : -1);
        offHand.yRot = offHand.yRot + actionAnim * 0.1f * (float)(rightHanded ? 1 : -1);
    }

    public float getCameraActionProgress(LivingEntity entity) {
        if (entity instanceof CameraOperator) {
            CameraOperator operator = (CameraOperator)entity;
            float partialTick = Minecrft.get().getTimer().getGameTimeDeltaPartialTick(true);
            return operator.getExposureCameraActionAnim(partialTick);
        }
        return 0.0f;
    }

    public float getCameraActionAnim(LivingEntity entity) {
        float actionProgress = this.getCameraActionProgress(entity);
        return (actionProgress = (float)EasingFunction.EASE_OUT_CUBIC.ease(actionProgress)) > 0.5f ? 1.0f - actionProgress : actionProgress;
    }
}

