/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.advancements.predicate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.exposure.world.item.camera.Attachment;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import java.util.Optional;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public record CameraPredicate(Optional<ItemPredicate> camera, Optional<ItemPredicate> film, Optional<ItemPredicate> flash, Optional<ItemPredicate> lens, Optional<ItemPredicate> filter, Optional<LocationPredicate> location) {
    public static final Codec<CameraPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemPredicate.CODEC.optionalFieldOf("camera").forGetter(CameraPredicate::camera), (App)ItemPredicate.CODEC.optionalFieldOf("film").forGetter(CameraPredicate::film), (App)ItemPredicate.CODEC.optionalFieldOf("flash").forGetter(CameraPredicate::flash), (App)ItemPredicate.CODEC.optionalFieldOf("lens").forGetter(CameraPredicate::lens), (App)ItemPredicate.CODEC.optionalFieldOf("filter").forGetter(CameraPredicate::filter), (App)LocationPredicate.CODEC.optionalFieldOf("location").forGetter(CameraPredicate::location)).apply((Applicative)instance, CameraPredicate::new));

    public boolean matches(ServerLevel level, ItemStack cameraStack, Vec3 cameraLocation) {
        if (!(cameraStack.getItem() instanceof CameraItem)) {
            return false;
        }
        return !(!this.camera.isEmpty() && !this.camera.get().test(cameraStack) || !this.film.isEmpty() && !this.film.get().test(Attachment.FILM.get(cameraStack).getForReading()) || !this.flash.isEmpty() && !this.flash.get().test(Attachment.FLASH.get(cameraStack).getForReading()) || !this.lens.isEmpty() && !this.lens.get().test(Attachment.LENS.get(cameraStack).getForReading()) || !this.filter.isEmpty() && !this.filter.get().test(Attachment.FILTER.get(cameraStack).getForReading()) || !this.location.isEmpty() && !this.location.get().matches(level, cameraLocation.x, cameraLocation.y, cameraLocation.z));
    }
}

