/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.baguettelib;

import com.leclowndu93150.baguettelib.event.entity.CreativeFlightEvent;
import com.leclowndu93150.baguettelib.example.ExamplePacket;
import com.leclowndu93150.baguettelib.network.NetworkManager;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.stream.Stream;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.slf4j.Logger;

@Mod(value="baguettelib")
public class Baguettelib {
    public static final String MODID = "baguettelib";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static NetworkManager NETWORK;

    public Baguettelib(IEventBus modEventBus, ModContainer modContainer) {
        if (this.isModInFolder("chisel-neoforge") && this.isModInFolder("chisel-1.21.1")) {
            throw new ModLoadingException(ModLoadingIssue.error((String)"Chisel Modern is not compatible with Chisel Reborn. People will not loose their builds if they used the latter mod, as there is auto migration.", (Object[])new Object[0]));
        }
        NETWORK = NetworkManager.create(MODID, modEventBus);
        NETWORK.registerPacket(ExamplePacket.class, "example").codec(ExamplePacket.STREAM_CODEC).serverToClient().handler((packet, context) -> context.enqueueWork(() -> LOGGER.info("Received packet: {} - {}", (Object)packet.value(), (Object)packet.message()))).build();
        NeoForge.EVENT_BUS.addListener(this::onPlayerJoin);
        NeoForge.EVENT_BUS.addListener(this::onCreativeFlight);
    }

    private boolean isModInFolder(String fileNameStart) {
        boolean bl;
        block10: {
            if (fileNameStart == null || fileNameStart.isEmpty()) {
                return false;
            }
            Path modsFolder = FMLPaths.MODSDIR.get();
            if (!Files.exists(modsFolder, new LinkOption[0]) || !Files.isDirectory(modsFolder, new LinkOption[0])) {
                return false;
            }
            Stream<Path> files = Files.list(modsFolder);
            try {
                bl = files.map(Path::getFileName).filter(Objects::nonNull).map(Path::toString).anyMatch(name -> name.startsWith(fileNameStart));
                if (files == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("e: ", (Throwable)e);
                    return false;
                }
            }
            files.close();
        }
        return bl;
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
    }

    @SubscribeEvent
    public void onCreativeFlight(CreativeFlightEvent.Toggle event) {
    }
}

