/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_power_loader.content;

import com.hlysine.create_power_loader.CPLBlockEntityTypes;
import com.hlysine.create_power_loader.CreatePowerLoader;
import com.hlysine.create_power_loader.content.AbstractChunkLoaderBlockEntity;
import com.hlysine.create_power_loader.content.ChunkLoader;
import com.hlysine.create_power_loader.content.LoaderMode;
import com.hlysine.create_power_loader.content.WeakCollection;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.world.chunk.RegisterTicketControllersEvent;
import net.neoforged.neoforge.common.world.chunk.TicketController;
import net.neoforged.neoforge.common.world.chunk.TicketHelper;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ChunkLoadManager {
    private static final TicketController TICKET_CONTROLLER = new TicketController(CreatePowerLoader.asResource("chunk_load_manager"), ChunkLoadManager::validateTickets);
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int SAVED_CHUNKS_DISCARD_TICKS = 100;
    private static final List<Pair<UUID, Set<LoadedChunkPos>>> unforceQueue = new LinkedList<Pair<UUID, Set<LoadedChunkPos>>>();
    private static final Map<UUID, Set<LoadedChunkPos>> savedForcedChunks = new HashMap<UUID, Set<LoadedChunkPos>>();
    private static int savedChunksDiscardCountdown = 100;
    public static Level tickLevel;
    public static final Map<LoaderMode, WeakCollection<ChunkLoader>> allLoaders;

    public static void addLoader(LoaderMode mode, ChunkLoader loader) {
        allLoaders.computeIfAbsent(mode, $ -> new WeakCollection()).add(loader);
    }

    public static void removeLoader(LoaderMode mode, ChunkLoader loader) {
        allLoaders.computeIfAbsent(mode, $ -> new WeakCollection()).remove(loader);
    }

    public static void onServerWorldTick(LevelTickEvent.Pre event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        MinecraftServer server = event.getLevel().getServer();
        if (savedChunksDiscardCountdown == 0) {
            for (Map.Entry<UUID, Set<LoadedChunkPos>> entry : savedForcedChunks.entrySet()) {
                ChunkLoadManager.unforceAllChunks(server, entry.getKey(), entry.getValue());
            }
            savedForcedChunks.clear();
        } else if (savedChunksDiscardCountdown > 0) {
            --savedChunksDiscardCountdown;
        }
        if (!unforceQueue.isEmpty()) {
            for (Pair pair : unforceQueue) {
                ChunkLoadManager.unforceAllChunks(server, (UUID)pair.getFirst(), (Set)pair.getSecond());
            }
            unforceQueue.clear();
        }
    }

    public static <T extends Comparable<? super T>> void updateForcedChunks(MinecraftServer server, LoadedChunkPos center, T owner, int loadingRange, Set<LoadedChunkPos> forcedChunks) {
        Set<LoadedChunkPos> targetChunks = ChunkLoadManager.getChunksAroundCenter(center, loadingRange);
        ChunkLoadManager.updateForcedChunks(server, targetChunks, owner, forcedChunks);
    }

    public static <T extends Comparable<? super T>> void updateForcedChunks(MinecraftServer server, Collection<LoadedChunkPos> centers, T owner, int loadingRange, Set<LoadedChunkPos> forcedChunks) {
        HashSet<LoadedChunkPos> targetChunks = new HashSet<LoadedChunkPos>();
        for (LoadedChunkPos center : centers) {
            targetChunks.addAll(ChunkLoadManager.getChunksAroundCenter(center, loadingRange));
        }
        ChunkLoadManager.updateForcedChunks(server, targetChunks, owner, forcedChunks);
    }

    public static <T extends Comparable<? super T>> void updateForcedChunks(MinecraftServer server, Collection<LoadedChunkPos> newChunks, T owner, Set<LoadedChunkPos> forcedChunks) {
        HashSet<LoadedChunkPos> unforcedChunks = new HashSet<LoadedChunkPos>();
        for (LoadedChunkPos chunk : forcedChunks) {
            if (newChunks.contains(chunk)) {
                newChunks.remove(chunk);
                continue;
            }
            ChunkLoadManager.forceChunk(server, owner, chunk.dimension(), chunk.x(), chunk.z(), false);
            unforcedChunks.add(chunk);
        }
        forcedChunks.removeAll(unforcedChunks);
        for (LoadedChunkPos chunk : newChunks) {
            ChunkLoadManager.forceChunk(server, owner, chunk.dimension(), chunk.x(), chunk.z(), true);
            forcedChunks.add(chunk);
        }
        if (unforcedChunks.size() > 0 || newChunks.size() > 0) {
            LOGGER.debug("CPL: update chunks, unloaded {}, loaded {}.", (Object)unforcedChunks.size(), (Object)newChunks.size());
        }
    }

    public static void enqueueUnforceAll(UUID owner, Set<LoadedChunkPos> forcedChunks) {
        unforceQueue.add((Pair<UUID, Set<LoadedChunkPos>>)Pair.of((Object)owner, forcedChunks));
    }

    public static <T extends Comparable<? super T>> void unforceAllChunks(MinecraftServer server, T owner, Set<LoadedChunkPos> forcedChunks) {
        for (LoadedChunkPos chunk : forcedChunks) {
            ChunkLoadManager.forceChunk(server, owner, chunk.dimension(), chunk.x(), chunk.z(), false);
        }
        if (forcedChunks.size() > 0) {
            LOGGER.debug("CPL: unload all, unloaded {} chunks.", (Object)forcedChunks.size());
        }
        forcedChunks.clear();
    }

    private static Set<LoadedChunkPos> getChunksAroundCenter(LoadedChunkPos center, int radius) {
        HashSet<LoadedChunkPos> ret = new HashSet<LoadedChunkPos>();
        for (int i = center.x() - radius + 1; i <= center.x() + radius - 1; ++i) {
            for (int j = center.z() - radius + 1; j <= center.z() + radius - 1; ++j) {
                ret.add(new LoadedChunkPos(center.dimension(), i, j));
            }
        }
        return ret;
    }

    private static <T extends Comparable<? super T>> void forceChunk(MinecraftServer server, T owner, ResourceLocation dimension, int chunkX, int chunkZ, boolean add) {
        ServerLevel targetLevel = server.getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimension));
        assert (targetLevel != null);
        if (owner instanceof BlockPos) {
            TICKET_CONTROLLER.forceChunk(targetLevel, (BlockPos)owner, chunkX, chunkZ, add, true);
        } else {
            TICKET_CONTROLLER.forceChunk(targetLevel, (UUID)owner, chunkX, chunkZ, add, true);
        }
    }

    public static Set<LoadedChunkPos> getSavedForcedChunks(UUID entityUUID) {
        return savedForcedChunks.remove(entityUUID);
    }

    public static void validateTickets(ServerLevel level, TicketHelper helper) {
        helper.getBlockTickets().forEach((blockPos, tickets) -> {
            LOGGER.debug("CPL: Inspecting level {} position {} which has {} non-ticking tickets and {} ticking tickets.", new Object[]{level.dimension().location(), blockPos.toShortString(), tickets.nonTicking().size(), tickets.ticking().size()});
            AbstractChunkLoaderBlockEntity blockEntity = level.getBlockEntity(blockPos, (BlockEntityType)CPLBlockEntityTypes.BRASS_CHUNK_LOADER.get()).orElse(null);
            if (blockEntity == null) {
                blockEntity = level.getBlockEntity(blockPos, (BlockEntityType)CPLBlockEntityTypes.ANDESITE_CHUNK_LOADER.get()).orElse(null);
            }
            if (blockEntity == null) {
                helper.removeAllTickets(blockPos);
                LOGGER.debug("CPL: level {} position {} unforced: Cannot find block entity.", (Object)level.dimension().location(), (Object)blockPos.toShortString());
                return;
            }
            for (Long chunk : tickets.nonTicking()) {
                ChunkPos chunkPos = new ChunkPos(chunk.longValue());
                helper.removeTicket(blockPos, chunk.longValue(), false);
                LOGGER.debug("CPL: level {} position {} unforced non-ticking {}", new Object[]{level.dimension().location(), blockPos.toShortString(), chunkPos});
            }
            HashSet<LoadedChunkPos> forcedChunks = new HashSet<LoadedChunkPos>();
            for (Long chunk : tickets.ticking()) {
                ChunkPos chunkPos = new ChunkPos(chunk.longValue());
                forcedChunks.add(new LoadedChunkPos(level.dimension().location(), chunkPos));
            }
            blockEntity.reclaimChunks(forcedChunks);
            LOGGER.debug("CPL: level {} position {} reclaimed {} chunks.", new Object[]{level.dimension().location(), blockPos.toShortString(), forcedChunks.size()});
        });
        helper.getEntityTickets().forEach((entityUUID, tickets) -> {
            Set<Object> savedChunks = new HashSet();
            if (savedForcedChunks.containsKey(entityUUID)) {
                savedChunks = savedForcedChunks.get(entityUUID);
            }
            for (Long chunk : tickets.nonTicking()) {
                savedChunks.add(new LoadedChunkPos((Level)level, chunk));
            }
            for (Long chunk : tickets.ticking()) {
                savedChunks.add(new LoadedChunkPos((Level)level, chunk));
            }
            savedForcedChunks.put((UUID)entityUUID, (Set<LoadedChunkPos>)savedChunks);
            LOGGER.debug("CPL: Inspecting entity {} which has {} non-ticking tickets and {} ticking tickets.", new Object[]{entityUUID, tickets.nonTicking().size(), tickets.ticking().size()});
        });
        savedChunksDiscardCountdown = 100;
    }

    public static void reclaimChunks(Level level, UUID owner, Map<ResourceKey<Level>, Set<LoadedChunkPos>> reclaimedChunks) {
        Set<LoadedChunkPos> oldChunks = ChunkLoadManager.getSavedForcedChunks(owner);
        if (oldChunks != null) {
            for (LoadedChunkPos chunk : oldChunks) {
                ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)chunk.dimension());
                Set<LoadedChunkPos> reclaim = reclaimedChunks.get(key);
                if (reclaim != null) {
                    reclaim.add(chunk);
                    continue;
                }
                reclaim = new HashSet<LoadedChunkPos>();
                reclaim.add(chunk);
                reclaimedChunks.put((ResourceKey<Level>)key, reclaim);
            }
        }
        if (!reclaimedChunks.isEmpty()) {
            MinecraftServer server = level.getServer();
            assert (server != null);
            Iterator<Map.Entry<ResourceKey<Level>, Set<LoadedChunkPos>>> iterator = reclaimedChunks.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceKey<Level>, Set<LoadedChunkPos>> entry = iterator.next();
                ServerLevel reclaimLevel = server.getLevel(entry.getKey());
                if (reclaimLevel == null) continue;
                ChunkLoadManager.unforceAllChunks(server, owner, entry.getValue());
                iterator.remove();
            }
        }
    }

    private static void registerTicketControllers(RegisterTicketControllersEvent event) {
        event.register(TICKET_CONTROLLER);
    }

    public static void register(IEventBus modBus) {
        modBus.addListener(ChunkLoadManager::registerTicketControllers);
    }

    static {
        allLoaders = new HashMap<LoaderMode, WeakCollection<ChunkLoader>>();
    }

    public record LoadedChunkPos(@NotNull ResourceLocation dimension, @NotNull ChunkPos chunkPos) {
        public LoadedChunkPos(@NotNull Level level, long chunkPos) {
            this(level.dimension().location(), new ChunkPos(chunkPos));
        }

        public LoadedChunkPos(@NotNull ResourceLocation level, int pX, int pZ) {
            this(level, new ChunkPos(pX, pZ));
        }

        public LoadedChunkPos(@NotNull Level level, BlockPos blockPos) {
            this(level.dimension().location(), new ChunkPos(blockPos));
        }

        public int x() {
            return this.chunkPos.x;
        }

        public int z() {
            return this.chunkPos.z;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LoadedChunkPos)) {
                return false;
            }
            LoadedChunkPos loadedChunk = (LoadedChunkPos)obj;
            if (!Objects.equals(loadedChunk.dimension, this.dimension)) {
                return false;
            }
            return Objects.equals(loadedChunk.chunkPos, this.chunkPos);
        }

        @Override
        public String toString() {
            return String.valueOf(this.dimension) + ":" + String.valueOf(this.chunkPos);
        }
    }
}

