/*
 * Decompiled with CFR 0.152.
 */
package org.aperlambda.lambdacommon.math;

import org.aperlambda.lambdacommon.math.MathHelper;
import org.jetbrains.annotations.NotNull;

public class Vec2i32
implements Comparable<Vec2i32> {
    public static final Vec2i32 ZERO = new Vec2i32(0, 0);
    public final int x;
    public final int y;

    public Vec2i32(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Vec2i32(double x, double y) {
        this(MathHelper.floor(x), MathHelper.floor(y));
    }

    public double standard() {
        return Math.sqrt(Math.pow(this.x, 2.0) + Math.pow(this.y, 2.0));
    }

    public int scalarProduct(Vec2i32 b) {
        return this.x * b.x + this.y * b.y;
    }

    public Vec2i32 add(Vec2i32 other) {
        if (other == null) {
            other = ZERO;
        }
        return new Vec2i32(this.x + other.x, this.y + other.y);
    }

    public Vec2i32 subtract(Vec2i32 other) {
        if (other == null) {
            other = ZERO;
        }
        return new Vec2i32(this.x - other.x, this.y - other.y);
    }

    public Vec2i32 negate() {
        return new Vec2i32(-this.x, -this.y);
    }

    public Vec2i32 multiply(int lambda) {
        return new Vec2i32(lambda * this.x, lambda * this.y);
    }

    @Override
    public int compareTo(@NotNull Vec2i32 vec2i32) {
        return this.y == vec2i32.y ? this.x - vec2i32.x : this.y - vec2i32.y;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Vec2i32)) {
            return false;
        }
        Vec2i32 other = (Vec2i32)object;
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }
}

