/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.neoforge;

import eu.midnightdust.midnightcontrols.MidnightControls;
import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.util.platform.NetworkUtil;
import eu.midnightdust.midnightcontrols.packet.ControlsModePayload;
import eu.midnightdust.midnightcontrols.packet.HelloPayload;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforgespi.locating.IModFile;

@Mod(value="midnightcontrols", dist={Dist.CLIENT})
public class MidnightControlsClientNeoforge {
    public MidnightControlsClientNeoforge() {
        MidnightControlsClient.initClient();
    }

    @EventBusSubscriber(modid="midnightcontrols", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
    public class ClientGameEvents {
        public ClientGameEvents(MidnightControlsClientNeoforge this$0) {
        }

        @SubscribeEvent
        public static void sendPacketOnLogin(ClientPlayerNetworkEvent.LoggingIn event) {
            String version = ModList.get().getModFileById("midnightcontrols").versionString();
            String controlsMode = MidnightControlsConfig.controlsMode.getName();
            NetworkUtil.sendPayloadC2S(new HelloPayload(version, controlsMode));
            NetworkUtil.sendPayloadC2S(new ControlsModePayload(controlsMode));
        }

        @SubscribeEvent
        public static void onDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
            MidnightControlsClient.onLeave();
        }

        @SubscribeEvent
        public static void startClientTick(ClientTickEvent.Pre event) {
            MidnightControlsClient.onTick(MidnightControlsClient.client);
        }
    }

    @EventBusSubscriber(modid="midnightcontrols", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public class ClientEvents {
        public ClientEvents(MidnightControlsClientNeoforge this$0) {
        }

        @SubscribeEvent
        public static void registerKeybinding(RegisterKeyMappingsEvent event) {
            event.register(MidnightControlsClient.BINDING_RING);
            event.register(MidnightControlsClient.BINDING_LOOK_UP);
            event.register(MidnightControlsClient.BINDING_LOOK_DOWN);
            event.register(MidnightControlsClient.BINDING_LOOK_LEFT);
            event.register(MidnightControlsClient.BINDING_LOOK_RIGHT);
        }

        @SubscribeEvent
        public static void addPackFinders(AddPackFindersEvent event) {
            if (event.getPackType() == PackType.CLIENT_RESOURCES) {
                ClientEvents.registerResourcePack(event, MidnightControls.id("bedrock"), false);
                ClientEvents.registerResourcePack(event, MidnightControls.id("legacy"), false);
            }
        }

        private static void registerResourcePack(AddPackFindersEvent event, ResourceLocation id, boolean alwaysEnabled) {
            event.addRepositorySource(profileAdder -> {
                IModFile file = ModList.get().getModFileById(id.getNamespace()).getFile();
                try {
                    PathPackResources.PathResourcesSupplier pack = new PathPackResources.PathResourcesSupplier(file.findResource(new String[]{"resourcepacks/" + id.getPath()}));
                    PackLocationInfo info = new PackLocationInfo(id.toString(), Component.nullToEmpty((String)(id.getNamespace() + "/" + id.getPath())), PackSource.BUILT_IN, Optional.empty());
                    Pack packProfile = Pack.readMetaAndCreate((PackLocationInfo)info, (Pack.ResourcesSupplier)pack, (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)new PackSelectionConfig(alwaysEnabled, Pack.Position.TOP, false));
                    if (packProfile != null) {
                        profileAdder.accept(packProfile);
                    }
                }
                catch (NullPointerException e) {
                    e.fillInStackTrace();
                }
            });
        }
    }
}

