/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.util.platform;

import dev.architectury.injectables.annotations.ExpectPlatform;
import eu.midnightdust.midnightcontrols.client.mixin.CreativeInventoryScreenAccessor;
import eu.midnightdust.midnightcontrols.client.util.platform.neoforge.ItemGroupUtilImpl;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import org.jetbrains.annotations.NotNull;

public class ItemGroupUtil {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static List<CreativeModeTab> getVisibleGroups(CreativeModeInventoryScreen screen) {
        return ItemGroupUtilImpl.getVisibleGroups(screen);
    }

    public static boolean cyclePage(boolean next, CreativeModeInventoryScreen screen) {
        try {
            return screen.children().stream().filter(element -> element instanceof AbstractButton).map(element -> (AbstractButton)element).filter(element -> element.getMessage() != null && element.getMessage().getContents() != null).anyMatch(element -> {
                if (next && element.getMessage().getString().equals(">")) {
                    element.onPress();
                    return true;
                }
                if (element.getMessage().getString().equals("<")) {
                    element.onPress();
                    return true;
                }
                return false;
            });
        }
        catch (Exception exception) {
            return false;
        }
    }

    @NotNull
    public static CreativeModeTab cycleTab(boolean next, Minecraft client) {
        CreativeModeTab currentTab = CreativeInventoryScreenAccessor.getSelectedTab();
        int currentColumn = currentTab.column();
        CreativeModeTab.Row currentRow = currentTab.row();
        CreativeModeTab newTab = null;
        List<CreativeModeTab> visibleTabs = ItemGroupUtil.getVisibleGroups((CreativeModeInventoryScreen)client.screen);
        for (CreativeModeTab tab : visibleTabs) {
            if (!tab.row().equals((Object)currentRow) || !(newTab == null && (next && tab.column() > currentColumn || !next && tab.column() < currentColumn)) && (newTab == null || (!next || tab.column() <= currentColumn || tab.column() >= newTab.column()) && (next || tab.column() >= currentColumn || tab.column() <= newTab.column()))) continue;
            newTab = tab;
        }
        if (newTab == null) {
            for (CreativeModeTab tab : visibleTabs) {
                if (tab.row().compareTo((Enum)currentRow) == 0 || !(next && newTab == null || next && newTab.column() > tab.column() || !next && newTab == null) && (next || newTab.column() >= tab.column())) continue;
                newTab = tab;
            }
        }
        if (newTab == null) {
            for (CreativeModeTab tab : visibleTabs) {
                if ((!next || tab.row() != CreativeModeTab.Row.TOP || tab.column() != 0) && (next || tab.row() != CreativeModeTab.Row.BOTTOM || newTab != null && tab.column() <= newTab.column())) continue;
                newTab = tab;
            }
        }
        if (newTab == null || newTab.equals(currentTab)) {
            newTab = CreativeModeTabs.getDefaultTab();
        }
        return newTab;
    }
}

