/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.touch.gui;

import com.mojang.blaze3d.platform.InputConstants;
import eu.midnightdust.lib.util.PlatformFunctions;
import eu.midnightdust.midnightcontrols.MidnightControls;
import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.compat.EmotecraftCompat;
import eu.midnightdust.midnightcontrols.client.controller.ButtonBinding;
import eu.midnightdust.midnightcontrols.client.controller.InputManager;
import eu.midnightdust.midnightcontrols.client.enums.ButtonState;
import eu.midnightdust.midnightcontrols.client.enums.HudSide;
import eu.midnightdust.midnightcontrols.client.touch.TouchInput;
import eu.midnightdust.midnightcontrols.client.touch.TouchUtils;
import eu.midnightdust.midnightcontrols.client.touch.gui.ItemUseButtonWidget;
import eu.midnightdust.midnightcontrols.client.touch.gui.SilentTexturedButtonWidget;
import eu.midnightdust.midnightcontrols.client.util.KeyBindingAccessor;
import eu.midnightdust.midnightcontrols.client.util.storage.AxisStorage;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.SpriteIconButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.UseAnim;
import org.thinkingstudio.obsidianui.Position;
import org.thinkingstudio.obsidianui.widget.SpruceButtonWidget;

public class TouchscreenOverlay
extends Screen {
    public static final ResourceLocation WIDGETS_LOCATION = MidnightControls.id("textures/gui/widgets.png");
    private SilentTexturedButtonWidget inventoryButton;
    private SilentTexturedButtonWidget swapHandsButton;
    private SilentTexturedButtonWidget dropButton;
    private ItemUseButtonWidget useButton;
    private SilentTexturedButtonWidget jumpButton;
    private SilentTexturedButtonWidget flyButton;
    private SilentTexturedButtonWidget flyUpButton;
    private SilentTexturedButtonWidget flyDownButton;
    private SilentTexturedButtonWidget forwardButton;
    private SilentTexturedButtonWidget forwardLeftButton;
    private SilentTexturedButtonWidget forwardRightButton;
    private SilentTexturedButtonWidget leftButton;
    private SilentTexturedButtonWidget rightButton;
    private SilentTexturedButtonWidget backButton;
    private SilentTexturedButtonWidget startSneakButton;
    private SilentTexturedButtonWidget endSneakButton;
    private int flyButtonEnableTicks = 0;
    private int forwardButtonTick = 0;

    public TouchscreenOverlay() {
        super((Component)Component.literal((String)"Touchscreen Overlay"));
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void renderBackground(GuiGraphics context, int mouseX, int mouseY, float delta) {
    }

    private void pauseGame() {
        assert (this.minecraft != null);
        this.minecraft.setScreen((Screen)new PauseScreen(true));
        if (this.minecraft.hasSingleplayerServer() && !Objects.requireNonNull(this.minecraft.getSingleplayerServer()).isPublished()) {
            this.minecraft.getSoundManager().pause();
        }
    }

    private void updateForwardButtonsState(boolean state) {
        this.forwardButtonTick = state ? -1 : 20;
    }

    private void updateJumpButtons() {
        assert (this.minecraft != null);
        assert (this.minecraft.player != null);
        float transparency = (float)MidnightControlsConfig.touchTransparency / 100.0f;
        if (this.minecraft.player.getAbilities().flying) {
            boolean oldStateFly = this.flyButton.isVisible();
            this.jumpButton.setVisible(false);
            this.flyButton.setVisible(true);
            this.flyUpButton.setVisible(true);
            this.flyDownButton.setVisible(true);
            this.flyButton.setAlpha(transparency);
            this.flyUpButton.setAlpha(transparency);
            this.flyDownButton.setAlpha(transparency);
            if (oldStateFly != this.flyButton.isVisible()) {
                this.flyButtonEnableTicks = 5;
                this.setJump(false);
            } else if (this.flyButtonEnableTicks > 0) {
                --this.flyButtonEnableTicks;
            }
        } else {
            this.jumpButton.setVisible(true);
            this.flyButton.setVisible(false);
            this.flyUpButton.setVisible(false);
            this.flyDownButton.setVisible(false);
            this.jumpButton.setAlpha(transparency);
        }
    }

    private void handleJump(SpruceButtonWidget btn) {
        assert (this.minecraft != null);
        ((KeyBindingAccessor)this.minecraft.options.keyJump).midnightcontrols$handlePressState(btn.isActive());
    }

    private void setJump(boolean state) {
        assert (this.minecraft != null);
        ((KeyBindingAccessor)this.minecraft.options.keyJump).midnightcontrols$handlePressState(state);
    }

    protected void init() {
        int sneakButtonX;
        int swapHandsX;
        int jumpButtonX;
        super.init();
        assert (this.minecraft != null);
        assert (this.minecraft.player != null);
        assert (this.minecraft.gameMode != null);
        int scaledWidth = this.minecraft.getWindow().getGuiScaledWidth();
        int scaledHeight = this.minecraft.getWindow().getGuiScaledHeight();
        int emoteOffset = 0;
        if (PlatformFunctions.isModLoaded((String)"emotecraft")) {
            emoteOffset = 10;
            SpriteIconButton emoteButton = SpriteIconButton.builder((Component)Component.empty(), btn -> EmotecraftCompat.openEmotecraftScreen(this), (boolean)true).width(20).sprite(MidnightControls.id("touch/emote"), 20, 20).build();
            emoteButton.setPosition(scaledWidth / 2 - 30, 0);
            this.addRenderableWidget((GuiEventListener)emoteButton);
        }
        SpriteIconButton chatButton = SpriteIconButton.builder((Component)Component.empty(), btn -> this.minecraft.setScreen((Screen)new ChatScreen("")), (boolean)true).width(20).sprite(MidnightControls.id("touch/chat"), 20, 20).build();
        chatButton.setPosition(scaledWidth / 2 - 20 + emoteOffset, 0);
        this.addRenderableWidget((GuiEventListener)chatButton);
        SpriteIconButton pauseButton = SpriteIconButton.builder((Component)Component.empty(), btn -> this.pauseGame(), (boolean)true).width(20).sprite(MidnightControls.id("touch/pause"), 20, 20).build();
        pauseButton.setPosition(scaledWidth / 2 + emoteOffset, 0);
        this.addRenderableWidget((GuiEventListener)pauseButton);
        int inventoryButtonX = scaledWidth / 2;
        int inventoryButtonY = scaledHeight - 16 - 5;
        inventoryButtonX = this.minecraft.options.mainHand().get() == HumanoidArm.LEFT ? inventoryButtonX - 91 - 24 : inventoryButtonX + 91 + 4;
        this.inventoryButton = new SilentTexturedButtonWidget(Position.of((int)inventoryButtonX, (int)inventoryButtonY), 20, 20, (Component)Component.empty(), btn -> {
            if (this.minecraft.gameMode.isServerControlledInventory()) {
                this.minecraft.player.sendOpenInventory();
            } else {
                this.minecraft.getTutorial().onOpenInventory();
                this.minecraft.setScreen((Screen)new InventoryScreen((Player)this.minecraft.player));
            }
        }, 20, 0, 20, WIDGETS_LOCATION, 256, 256);
        this.addRenderableWidget((GuiEventListener)this.inventoryButton);
        int sneakButtonY = scaledHeight - 10 - 40 - 5;
        if (MidnightControlsConfig.hudSide == HudSide.LEFT) {
            jumpButtonX = scaledWidth - 20 - 20;
            swapHandsX = jumpButtonX - 5 - 40;
            sneakButtonX = 35;
        } else {
            jumpButtonX = 20;
            swapHandsX = jumpButtonX + 5 + 40;
            sneakButtonX = scaledWidth - 10 - 40 - 5;
        }
        this.swapHandsButton = new SilentTexturedButtonWidget(Position.of((int)swapHandsX, (int)sneakButtonY), 20, 20, (Component)Component.empty(), button -> {
            if (button.isActive() && !this.minecraft.player.isSpectator()) {
                Objects.requireNonNull(this.minecraft.getConnection()).sendPacket((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.SWAP_ITEM_WITH_OFFHAND, BlockPos.ZERO, Direction.DOWN));
            }
        }, 0, 160, 20, WIDGETS_LOCATION);
        this.addRenderableWidget((GuiEventListener)this.swapHandsButton);
        this.dropButton = new SilentTexturedButtonWidget(Position.of((int)swapHandsX, (int)(sneakButtonY + 5 + 20)), 20, 20, (Component)Component.empty(), btn -> {
            if (btn.isActive() && !this.minecraft.player.isSpectator() && this.minecraft.player.drop(false)) {
                this.minecraft.player.swing(InteractionHand.MAIN_HAND);
            }
        }, 20, 160, 20, WIDGETS_LOCATION);
        this.addRenderableWidget((GuiEventListener)this.dropButton);
        this.useButton = new ItemUseButtonWidget(Position.of((int)(this.width / 2 - 25), (int)(this.height - 70)), 50, 17, (Component)Component.translatable((String)"midnightcontrols.action.eat"), btn -> this.minecraft.gameMode.useItem((Player)this.minecraft.player, this.minecraft.player.getUsedItemHand()));
        this.addRenderableWidget((GuiEventListener)this.useButton);
        this.jumpButton = new SilentTexturedButtonWidget(Position.of((int)jumpButtonX, (int)sneakButtonY), 20, 20, (Component)Component.empty(), this::handleJump, 0, 40, 20, WIDGETS_LOCATION);
        this.addRenderableWidget((GuiEventListener)this.jumpButton);
        this.flyButton = new SilentTexturedButtonWidget(Position.of((int)jumpButtonX, (int)sneakButtonY), 20, 20, (Component)Component.empty(), btn -> {
            if (this.flyButtonEnableTicks == 0) {
                this.minecraft.player.getAbilities().flying = false;
            }
        }, 20, 40, 20, WIDGETS_LOCATION);
        this.addRenderableWidget((GuiEventListener)this.flyButton);
        this.flyUpButton = new SilentTexturedButtonWidget(Position.of((int)jumpButtonX, (int)(sneakButtonY - 5 - 20)), 20, 20, (Component)Component.empty(), this::handleJump, 40, 40, 20, WIDGETS_LOCATION);
        this.addRenderableWidget((GuiEventListener)this.flyUpButton);
        this.flyDownButton = new SilentTexturedButtonWidget(Position.of((int)jumpButtonX, (int)(sneakButtonY + 20 + 5)), 20, 20, (Component)Component.empty(), btn -> ((KeyBindingAccessor)this.minecraft.options.keyShift).midnightcontrols$handlePressState(btn.isActive()), 60, 40, 20, WIDGETS_LOCATION);
        this.addRenderableWidget((GuiEventListener)this.flyDownButton);
        this.updateJumpButtons();
        this.startSneakButton = new SilentTexturedButtonWidget(Position.of((int)sneakButtonX, (int)sneakButtonY), 20, 20, (Component)Component.empty(), btn -> {
            if (btn.isActive()) {
                ((KeyBindingAccessor)this.minecraft.options.keyShift).midnightcontrols$handlePressState(true);
                this.startSneakButton.setVisible(false);
                this.endSneakButton.setVisible(true);
            }
        }, 0, 120, 20, WIDGETS_LOCATION);
        this.addRenderableWidget((GuiEventListener)this.startSneakButton);
        this.endSneakButton = new SilentTexturedButtonWidget(Position.of((int)sneakButtonX, (int)sneakButtonY), 20, 20, (Component)Component.empty(), btn -> {
            if (btn.isActive()) {
                ((KeyBindingAccessor)this.minecraft.options.keyShift).midnightcontrols$handlePressState(false);
                this.endSneakButton.setVisible(false);
                this.startSneakButton.setVisible(true);
            }
        }, 20, 120, 20, WIDGETS_LOCATION);
        this.addRenderableWidget((GuiEventListener)this.endSneakButton);
        this.forwardLeftButton = new SilentTexturedButtonWidget(Position.of((int)(sneakButtonX - 20 - 5), (int)(sneakButtonY - 5 - 20)), 20, 20, (Component)Component.empty(), btn -> {
            ((KeyBindingAccessor)this.minecraft.options.keyUp).midnightcontrols$handlePressState(btn.isActive());
            ((KeyBindingAccessor)this.minecraft.options.keyLeft).midnightcontrols$handlePressState(btn.isActive());
            this.updateForwardButtonsState(btn.isActive());
        }, 80, 80, 20, WIDGETS_LOCATION);
        this.addRenderableWidget((GuiEventListener)this.forwardLeftButton);
        this.forwardButton = new SilentTexturedButtonWidget(Position.of((int)sneakButtonX, (int)(sneakButtonY - 5 - 20)), 20, 20, (Component)Component.empty(), btn -> {
            ((KeyBindingAccessor)this.minecraft.options.keyUp).midnightcontrols$handlePressState(btn.isActive());
            this.updateForwardButtonsState(btn.isActive());
            this.forwardLeftButton.setVisible(true);
            this.forwardRightButton.setVisible(true);
        }, 0, 80, 20, WIDGETS_LOCATION);
        this.addRenderableWidget((GuiEventListener)this.forwardButton);
        this.forwardRightButton = new SilentTexturedButtonWidget(Position.of((int)(sneakButtonX + 20 + 5), (int)(sneakButtonY - 5 - 20)), 20, 20, (Component)Component.empty(), btn -> {
            ((KeyBindingAccessor)this.minecraft.options.keyUp).midnightcontrols$handlePressState(btn.isActive());
            ((KeyBindingAccessor)this.minecraft.options.keyRight).midnightcontrols$handlePressState(btn.isActive());
            this.updateForwardButtonsState(btn.isActive());
        }, 100, 80, 20, WIDGETS_LOCATION);
        this.addRenderableWidget((GuiEventListener)this.forwardRightButton);
        this.rightButton = new SilentTexturedButtonWidget(Position.of((int)(sneakButtonX + 20 + 5), (int)sneakButtonY), 20, 20, (Component)Component.empty(), btn -> ((KeyBindingAccessor)this.minecraft.options.keyRight).midnightcontrols$handlePressState(btn.isActive()), 20, 80, 20, WIDGETS_LOCATION);
        this.addRenderableWidget((GuiEventListener)this.rightButton);
        this.backButton = new SilentTexturedButtonWidget(Position.of((int)sneakButtonX, (int)(sneakButtonY + 20 + 5)), 20, 20, (Component)Component.empty(), btn -> ((KeyBindingAccessor)this.minecraft.options.keyDown).midnightcontrols$handlePressState(btn.isActive()), 40, 80, 20, WIDGETS_LOCATION);
        this.addRenderableWidget((GuiEventListener)this.backButton);
        this.leftButton = new SilentTexturedButtonWidget(Position.of((int)(sneakButtonX - 20 - 5), (int)sneakButtonY), 20, 20, (Component)Component.empty(), btn -> ((KeyBindingAccessor)this.minecraft.options.keyLeft).midnightcontrols$handlePressState(btn.isActive()), 60, 80, 20, WIDGETS_LOCATION);
        this.addRenderableWidget((GuiEventListener)this.leftButton);
        this.initCustomButtons(true);
        this.initCustomButtons(false);
        this.setButtonProperties((float)MidnightControlsConfig.touchTransparency / 100.0f);
    }

    private void initCustomButtons(boolean left) {
        assert (this.minecraft != null);
        ResourceLocation emptySprite = MidnightControls.id("touch/empty");
        List<String> list = left ? MidnightControlsConfig.leftTouchBinds : MidnightControlsConfig.rightTouchBinds;
        TextureAtlasSprite missingSprite = this.minecraft.getGuiSprites().getSprite(MissingTextureAtlasSprite.getLocation());
        for (int i = 0; i < list.size(); ++i) {
            boolean hasTexture;
            String bindName = list.get(i);
            ButtonBinding binding = InputManager.getBinding(bindName);
            if (binding == null) continue;
            boolean bl = hasTexture = this.minecraft.getGuiSprites().getSprite(MidnightControls.id("binding/" + bindName)) != missingSprite;
            if (MidnightControlsConfig.debug) {
                System.out.println(left + " " + String.valueOf(MidnightControls.id("binding/" + bindName)) + " " + hasTexture);
            }
            SpriteIconButton button = SpriteIconButton.builder((Component)Component.translatable((String)binding.getTranslationKey()), b -> binding.handle(this.minecraft, 1.0f, ButtonState.PRESS), (boolean)hasTexture).sprite(hasTexture ? MidnightControls.id("binding/" + bindName) : emptySprite, 20, 20).size(20, 20).build();
            button.setPosition(left ? 3 + i * 23 : this.width - (23 + i * 23), 3);
            button.setAlpha((float)MidnightControlsConfig.touchTransparency / 100.0f);
            this.addRenderableWidget((GuiEventListener)button);
        }
    }

    private void setButtonProperties(float transparency) {
        this.inventoryButton.setAlpha(transparency);
        this.dropButton.setAlpha(transparency);
        this.swapHandsButton.setAlpha(transparency);
        this.jumpButton.setAlpha(transparency);
        this.flyButton.setAlpha(transparency);
        this.flyUpButton.setAlpha(transparency);
        this.useButton.setAlpha(Math.min(transparency + 0.1f, 1.0f));
        this.flyDownButton.setAlpha(transparency);
        this.startSneakButton.setAlpha(transparency);
        this.endSneakButton.setAlpha(transparency);
        this.forwardButton.setAlpha(transparency);
        this.forwardLeftButton.setAlpha(Math.max(0.05f, transparency - 0.1f));
        this.forwardRightButton.setAlpha(Math.max(0.05f, transparency - 0.1f));
        this.leftButton.setAlpha(transparency);
        this.rightButton.setAlpha(transparency);
        this.backButton.setAlpha(transparency);
        this.useButton.setAlpha(Math.min(transparency + 0.1f, 1.0f));
        this.endSneakButton.setVisible(false);
        this.forwardLeftButton.setVisible(false);
        this.forwardRightButton.setVisible(false);
    }

    public void tick() {
        assert (this.minecraft != null);
        assert (this.minecraft.gameMode != null);
        assert (this.minecraft.player != null);
        if (this.forwardButtonTick > 0) {
            --this.forwardButtonTick;
        } else {
            this.forwardLeftButton.setVisible(false);
            this.forwardRightButton.setVisible(false);
        }
        this.useButton.setVisible(this.minecraft.player.getMainHandItem() != null && (this.minecraft.player.getMainHandItem().getUseAnimation() != UseAnim.NONE || this.minecraft.player.getMainHandItem().getItem() instanceof ArmorItem) && !TouchUtils.hasInWorldUseAction(this.minecraft.player.getMainHandItem()));
        this.updateJumpButtons();
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0 && this.minecraft != null) {
            if (TouchInput.isDragging) {
                if (!MidnightControlsConfig.invertTouch) {
                    deltaX = -deltaX;
                    deltaY = -deltaY;
                }
                MidnightControlsClient.input.handleTouchscreenLook(AxisStorage.of(3, (float)deltaY, 0.25));
                MidnightControlsClient.input.handleTouchscreenLook(AxisStorage.of(2, (float)deltaX, 0.25));
            } else {
                TouchInput.isDragging = true;
            }
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        KeyMapping.click((InputConstants.Key)InputConstants.getKey((int)keyCode, (int)scanCode));
        super.keyPressed(keyCode, scanCode, modifiers);
        return true;
    }
}

