/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.touch;

import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.touch.TouchUtils;
import eu.midnightdust.midnightcontrols.client.touch.gui.TouchscreenOverlay;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class TouchInput {
    private static final Minecraft client = Minecraft.getInstance();
    public static long clickStartTime;
    public static HitResult firstHitResult;
    public static boolean isDragging;

    public static void tick() {
        if (TouchInput.client.screen == null && MidnightControlsConfig.doMixedInput() || TouchInput.client.screen instanceof TouchscreenOverlay) {
            double scaleFactor = client.getWindow().getGuiScale();
            if (clickStartTime > 0L && System.currentTimeMillis() - clickStartTime >= (long)MidnightControlsConfig.touchBreakDelay) {
                TouchInput.mouseHeldDown(TouchInput.client.mouseHandler.xpos() / scaleFactor, TouchInput.client.mouseHandler.ypos() / scaleFactor);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void mouseHeldDown(double mouseX, double mouseY) {
        HitResult hitResult;
        assert (client != null);
        assert (TouchInput.client.player != null);
        assert (TouchInput.client.gameMode != null);
        if (TouchInput.client.player.getMainHandItem() != null && TouchUtils.hasInWorldUseAction(TouchInput.client.player.getMainHandItem())) {
            TouchInput.client.gameMode.useItem((Player)TouchInput.client.player, TouchInput.client.player.getUsedItemHand());
            return;
        }
        HitResult result = TouchUtils.getTargetedObject(mouseX, mouseY);
        if (result == null || firstHitResult == null) {
            TouchInput.client.gameMode.stopDestroyBlock();
            return;
        }
        if (result instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)result;
            hitResult = firstHitResult;
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult firstBlock = (BlockHitResult)hitResult;
                if (blockHit.getBlockPos().equals((Object)firstBlock.getBlockPos())) {
                    if (MidnightControlsConfig.debug) {
                        System.out.println(blockHit.getBlockPos().toString());
                    }
                    if (TouchInput.client.gameMode.continueDestroyBlock(blockHit.getBlockPos(), blockHit.getDirection())) {
                        TouchInput.client.particleEngine.crack(blockHit.getBlockPos(), blockHit.getDirection());
                        TouchInput.client.player.swing(InteractionHand.MAIN_HAND);
                    } else {
                        TouchInput.client.gameMode.stopDestroyBlock();
                    }
                    firstHitResult = TouchUtils.getTargetedObject(mouseX, mouseY);
                    return;
                }
            }
        }
        if (!(result instanceof EntityHitResult)) return;
        EntityHitResult entityHit = (EntityHitResult)result;
        hitResult = firstHitResult;
        if (!(hitResult instanceof EntityHitResult)) return;
        EntityHitResult firstEntity = (EntityHitResult)hitResult;
        if (entityHit.getEntity().getUUID().compareTo(firstEntity.getEntity().getUUID()) != 0) return;
        if (TouchInput.client.gameMode.interact((Player)TouchInput.client.player, entityHit.getEntity(), TouchInput.client.player.getUsedItemHand()) == InteractionResult.SUCCESS) {
            TouchInput.client.player.swing(InteractionHand.MAIN_HAND);
        }
        firstHitResult = TouchUtils.getTargetedObject(mouseX, mouseY);
    }

    public static boolean mouseReleased(double mouseX, double mouseY, int button) {
        isDragging = false;
        firstHitResult = null;
        if (TouchInput.client.gameMode != null) {
            TouchInput.client.gameMode.stopDestroyBlock();
        }
        if (!(TouchInput.client.screen != null && TouchInput.client.screen.mouseReleased(mouseX, mouseY, button) || System.currentTimeMillis() - clickStartTime >= (long)MidnightControlsConfig.touchBreakDelay)) {
            assert (TouchInput.client.player != null);
            assert (TouchInput.client.level != null);
            assert (TouchInput.client.gameMode != null);
            clickStartTime = -1L;
            if (TouchInput.client.player.getMainHandItem() != null && TouchUtils.hasInWorldUseAction(TouchInput.client.player.getMainHandItem())) {
                TouchInput.client.gameMode.releaseUsingItem((Player)TouchInput.client.player);
                return true;
            }
            HitResult result = TouchUtils.getTargetedObject(mouseX, mouseY);
            if (result == null) {
                return false;
            }
            if (result instanceof BlockHitResult) {
                BlockHitResult blockHit = (BlockHitResult)result;
                BlockPos blockPos = blockHit.getBlockPos().relative(blockHit.getDirection());
                BlockState state = TouchInput.client.level.getBlockState(blockPos);
                if (TouchInput.client.level.isEmptyBlock(blockPos) || state.canBeReplaced()) {
                    ItemStack stackInHand = TouchInput.client.player.getMainHandItem();
                    int previousStackCount = stackInHand.getCount();
                    InteractionResult interaction = TouchInput.client.gameMode.useItemOn(TouchInput.client.player, TouchInput.client.player.getUsedItemHand(), blockHit);
                    if (interaction.consumesAction()) {
                        if (interaction.shouldSwing()) {
                            TouchInput.client.player.swing(TouchInput.client.player.swingingArm);
                            if (!stackInHand.isEmpty() && (stackInHand.getCount() != previousStackCount || TouchInput.client.gameMode.hasInfiniteItems())) {
                                TouchInput.client.gameRenderer.itemInHandRenderer.itemUsed(TouchInput.client.player.swingingArm);
                            }
                        }
                        return true;
                    }
                }
            }
            if (result instanceof EntityHitResult) {
                EntityHitResult entityHit = (EntityHitResult)result;
                TouchInput.client.gameMode.attack((Player)TouchInput.client.player, entityHit.getEntity());
                TouchInput.client.player.swing(InteractionHand.MAIN_HAND);
                return true;
            }
        }
        clickStartTime = -1L;
        return false;
    }

    static {
        firstHitResult = null;
        isDragging = false;
    }
}

