/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import eu.midnightdust.lib.util.MidnightColorUtil;
import eu.midnightdust.midnightcontrols.ControlsMode;
import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.enums.TouchMode;
import eu.midnightdust.midnightcontrols.client.touch.TouchInput;
import eu.midnightdust.midnightcontrols.client.util.RainbowColor;
import java.awt.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class WorldRendererMixin {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    private ClientLevel level;
    @Shadow
    @Final
    private RenderBuffers renderBuffers;

    @Shadow
    private static void renderShape(PoseStack matrices, VertexConsumer vertexConsumer, VoxelShape shape, double offsetX, double offsetY, double offsetZ, float red, float green, float blue, float alpha) {
    }

    @Redirect(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/HitResult;getType()Lnet/minecraft/world/phys/HitResult$Type;"))
    private HitResult.Type dontRenderOutline(HitResult instance) {
        if (MidnightControlsConfig.controlsMode == ControlsMode.TOUCHSCREEN && MidnightControlsConfig.touchMode == TouchMode.FINGER_POS) {
            return HitResult.Type.MISS;
        }
        return instance.getType();
    }

    @Inject(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/Minecraft;hitResult:Lnet/minecraft/world/phys/HitResult;", ordinal=1, shift=At.Shift.AFTER)})
    private void onOutlineRender(DeltaTracker tickCounter, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f matrix4f, Matrix4f matrix4f2, CallbackInfo ci, @Local PoseStack matrices) {
        if ((MidnightControlsConfig.controlsMode == ControlsMode.CONTROLLER && MidnightControlsConfig.touchInControllerMode || MidnightControlsConfig.controlsMode == ControlsMode.TOUCHSCREEN) && MidnightControlsConfig.touchMode == TouchMode.FINGER_POS) {
            this.midnightcontrols$renderFingerOutline(matrices, camera);
        }
        this.midnightcontrols$renderReacharoundOutline(matrices, camera);
    }

    @Unique
    private void midnightcontrols$renderFingerOutline(PoseStack matrices, Camera camera) {
        if (TouchInput.firstHitResult == null || TouchInput.firstHitResult.getType() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult result = (BlockHitResult)TouchInput.firstHitResult;
        BlockPos blockPos = result.getBlockPos();
        if (this.level.getWorldBorder().isWithinBounds(blockPos) && this.minecraft.player != null) {
            VoxelShape outlineShape = this.level.getBlockState(blockPos).getShape((BlockGetter)this.minecraft.level, blockPos, CollisionContext.of((Entity)camera.getEntity()));
            Color rgb = MidnightColorUtil.hex2Rgb((String)MidnightControlsConfig.touchOutlineColorHex);
            if (MidnightControlsConfig.touchOutlineColorHex.isEmpty()) {
                rgb = RainbowColor.radialRainbow(1.0f, 1.0f);
            }
            Vec3 pos = camera.getPosition();
            matrices.pushPose();
            VertexConsumer vertexConsumer = this.renderBuffers.bufferSource().getBuffer(RenderType.lines());
            WorldRendererMixin.renderShape(matrices, vertexConsumer, outlineShape, (double)blockPos.getX() - pos.x(), (double)blockPos.getY() - pos.y(), (double)blockPos.getZ() - pos.z(), (float)rgb.getRed() / 255.0f, (float)rgb.getGreen() / 255.0f, (float)rgb.getBlue() / 255.0f, (float)MidnightControlsConfig.touchOutlineColorAlpha / 255.0f);
            matrices.popPose();
        }
    }

    @Unique
    private void midnightcontrols$renderReacharoundOutline(PoseStack matrices, Camera camera) {
        if (this.minecraft.hitResult == null || this.minecraft.hitResult.getType() != HitResult.Type.MISS || !MidnightControlsConfig.shouldRenderReacharoundOutline) {
            return;
        }
        BlockHitResult result = MidnightControlsClient.reacharound.getLastReacharoundResult();
        if (result == null) {
            return;
        }
        BlockPos blockPos = result.getBlockPos();
        if (this.level.getWorldBorder().isWithinBounds(blockPos) && this.minecraft.player != null) {
            BlockPlaceContext context;
            ItemStack stack = this.minecraft.player.getItemInHand(InteractionHand.MAIN_HAND);
            if (stack == null || !(stack.getItem() instanceof BlockItem)) {
                return;
            }
            Block block = ((BlockItem)stack.getItem()).getBlock();
            BlockState placementState = block.getStateForPlacement(context = new BlockPlaceContext(new UseOnContext((Player)this.minecraft.player, InteractionHand.MAIN_HAND, result = MidnightControlsClient.reacharound.withSideForReacharound(result, block))));
            if (placementState == null) {
                return;
            }
            Vec3 pos = camera.getPosition();
            VoxelShape outlineShape = placementState.getShape((BlockGetter)this.minecraft.level, blockPos, CollisionContext.of((Entity)camera.getEntity()));
            Color rgb = MidnightColorUtil.hex2Rgb((String)MidnightControlsConfig.reacharoundOutlineColorHex);
            if (MidnightControlsConfig.reacharoundOutlineColorHex.isEmpty()) {
                rgb = RainbowColor.radialRainbow(1.0f, 1.0f);
            }
            matrices.pushPose();
            VertexConsumer vertexConsumer = this.renderBuffers.bufferSource().getBuffer(RenderType.lines());
            WorldRendererMixin.renderShape(matrices, vertexConsumer, outlineShape, (double)blockPos.getX() - pos.x(), (double)blockPos.getY() - pos.y(), (double)blockPos.getZ() - pos.z(), (float)rgb.getRed() / 255.0f, (float)rgb.getGreen() / 255.0f, (float)rgb.getBlue() / 255.0f, (float)MidnightControlsConfig.reacharoundOutlineColorAlpha / 255.0f);
            matrices.popPose();
        }
    }
}

