/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.gui.widget;

import eu.midnightdust.midnightcontrols.client.controller.ButtonBinding;
import eu.midnightdust.midnightcontrols.client.gui.MidnightControlsRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.thinkingstudio.obsidianui.Position;
import org.thinkingstudio.obsidianui.SpruceTexts;
import org.thinkingstudio.obsidianui.widget.AbstractSpruceIconButtonWidget;
import org.thinkingstudio.obsidianui.widget.SpruceButtonWidget;

public class ControllerButtonWidget
extends AbstractSpruceIconButtonWidget {
    private ButtonBinding binding;
    private int iconWidth;

    public ControllerButtonWidget(Position position, int width, @NotNull ButtonBinding binding, @NotNull SpruceButtonWidget.PressAction action) {
        super(position, width, 20, ButtonBinding.getLocalizedButtonName(binding.getButton()[0]), action);
        this.binding = binding;
    }

    public void update() {
        int length = this.binding.getButton().length;
        this.setMessage((Component)(this.binding.isNotBound() ? SpruceTexts.NOT_BOUND.copy() : (length > 0 ? ButtonBinding.getLocalizedButtonName(this.binding.getButton()[0]) : Component.literal((String)"<>"))));
    }

    public Component getMessage() {
        if (this.binding.getButton().length > 1) {
            return Component.empty();
        }
        return super.getMessage();
    }

    protected int renderIcon(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int x = this.getX();
        if (this.binding.getButton().length > 1) {
            x += this.width / 2 - this.iconWidth / 2 - 4;
        }
        MidnightControlsRenderer.ButtonSize size = MidnightControlsRenderer.drawButton(context, x, this.getY(), this.binding, Minecraft.getInstance());
        this.iconWidth = size.length();
        return size.height();
    }
}

