/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import eu.midnightdust.midnightcontrols.ControlsMode;
import eu.midnightdust.midnightcontrols.MidnightControls;
import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.MidnightInput;
import eu.midnightdust.midnightcontrols.client.compat.CompatHandler;
import eu.midnightdust.midnightcontrols.client.compat.MidnightControlsCompat;
import eu.midnightdust.midnightcontrols.client.controller.ButtonBinding;
import eu.midnightdust.midnightcontrols.client.enums.ControllerType;
import eu.midnightdust.midnightcontrols.client.enums.VirtualMouseSkin;
import eu.midnightdust.midnightcontrols.client.util.HandledScreenAccessor;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class MidnightControlsRenderer {
    public static final int ICON_SIZE = 20;
    private static final int BUTTON_SIZE = 15;
    private static final int AXIS_SIZE = 18;

    public static int getButtonSize(int button) {
        return switch (button) {
            case -1 -> 0;
            case 100, 101, 102, 103, 200, 201, 202, 203 -> 18;
            default -> 15;
        };
    }

    public static int getBindingIconWidth(@NotNull ButtonBinding binding) {
        return MidnightControlsRenderer.getBindingIconWidth(binding.getButton());
    }

    public static int getBindingIconWidth(int[] buttons) {
        int width = 0;
        for (int i = 0; i < buttons.length; ++i) {
            width += 20;
            if (i + 1 >= buttons.length) continue;
            width += 2;
        }
        return width;
    }

    public static ButtonSize drawButton(GuiGraphics context, int x, int y, @NotNull ButtonBinding button, @NotNull Minecraft client) {
        return MidnightControlsRenderer.drawButton(context, x, y, button.getButton(), client);
    }

    public static ButtonSize drawButton(GuiGraphics context, int x, int y, int[] buttons, @NotNull Minecraft client) {
        int height = 0;
        int length = 0;
        int currentX = x;
        for (int i = 0; i < buttons.length; ++i) {
            int btn = buttons[i];
            int size = MidnightControlsRenderer.drawButton(context, currentX, y, btn, client);
            if (size > height) {
                height = size;
            }
            length += size;
            if (i + 1 >= buttons.length) continue;
            currentX = x + (length += 2);
        }
        return new ButtonSize(length, height);
    }

    public static int drawButton(GuiGraphics context, int x, int y, int button, @NotNull Minecraft client) {
        boolean second = false;
        if (button == -1) {
            return 0;
        }
        if (button >= 500) {
            button -= 1000;
            second = true;
        }
        int controllerType = MidnightControlsConfig.controllerType == ControllerType.DEFAULT ? MidnightControlsConfig.matchControllerToType().getId() : MidnightControlsConfig.controllerType.getId();
        boolean axis = false;
        int buttonOffset = button * 15;
        switch (button) {
            case 15: {
                buttonOffset = 0;
                break;
            }
            case 16: {
                buttonOffset = 18;
                break;
            }
            case 17: {
                buttonOffset = 36;
                break;
            }
            case 18: {
                buttonOffset = 54;
                break;
            }
            case 4: {
                buttonOffset = 105;
                break;
            }
            case 5: {
                buttonOffset = 120;
                break;
            }
            case 6: {
                buttonOffset = 60;
                break;
            }
            case 7: {
                buttonOffset = 90;
                break;
            }
            case 8: {
                buttonOffset = 75;
                break;
            }
            case 9: {
                buttonOffset = 225;
                break;
            }
            case 10: {
                buttonOffset = 240;
                break;
            }
            case 100: {
                buttonOffset = 0;
                axis = true;
                break;
            }
            case 101: {
                buttonOffset = 18;
                axis = true;
                break;
            }
            case 102: {
                buttonOffset = 36;
                axis = true;
                break;
            }
            case 103: {
                buttonOffset = 54;
                axis = true;
                break;
            }
            case 200: {
                buttonOffset = 72;
                axis = true;
                break;
            }
            case 201: {
                buttonOffset = 90;
                axis = true;
                break;
            }
            case 202: {
                buttonOffset = 108;
                axis = true;
                break;
            }
            case 203: {
                buttonOffset = 126;
                axis = true;
                break;
            }
            case 104: 
            case 204: {
                buttonOffset = 135;
                break;
            }
            case 105: 
            case 205: {
                buttonOffset = 150;
            }
        }
        RenderSystem.disableDepthTest();
        int assetSize = axis || button >= 15 && button <= 18 ? 18 : 15;
        RenderSystem.setShaderColor((float)1.0f, (float)(second ? 0.0f : 1.0f), (float)1.0f, (float)1.0f);
        context.blit(axis ? MidnightControlsClient.CONTROLLER_AXIS : (button >= 15 && button <= 19 ? MidnightControlsClient.CONTROLLER_EXPANDED : MidnightControlsClient.CONTROLLER_BUTTONS), x + (10 - assetSize / 2), y + (10 - assetSize / 2), (float)buttonOffset, (float)(controllerType * assetSize), assetSize, assetSize, 256, 256);
        RenderSystem.enableDepthTest();
        return 20;
    }

    public static int drawButtonTip(GuiGraphics context, int x, int y, @NotNull ButtonBinding button, boolean display, @NotNull Minecraft client) {
        return MidnightControlsRenderer.drawButtonTip(context, x, y, button.getButton(), button.getTranslationKey(), display, client);
    }

    public static int drawButtonTip(GuiGraphics context, int x, int y, int[] button, @NotNull String action, boolean display, @NotNull Minecraft client) {
        if (display) {
            int buttonWidth = MidnightControlsRenderer.drawButton(context, x, y, button, client).length();
            String translatedAction = I18n.get((String)action, (Object[])new Object[0]);
            Objects.requireNonNull(client.font);
            int textY = 10 - 9 / 2 + 1;
            return context.drawString(client.font, translatedAction, x + buttonWidth + 2, y + textY, 0xE0E0E0);
        }
        return -10;
    }

    private static int getButtonTipWidth(@NotNull String action, @NotNull Font textRenderer) {
        return 20 + textRenderer.width(action);
    }

    public static void renderWaylandCursor(@NotNull GuiGraphics context, @NotNull Minecraft client) {
        if (MidnightControlsConfig.virtualMouse || client.screen == null || MidnightControlsConfig.controlsMode != ControlsMode.CONTROLLER) {
            return;
        }
        float mouseX = (float)client.mouseHandler.xpos() * (float)client.getWindow().getGuiScaledWidth() / (float)client.getWindow().getScreenWidth();
        float mouseY = (float)client.mouseHandler.ypos() * (float)client.getWindow().getGuiScaledHeight() / (float)client.getWindow().getScreenHeight();
        try {
            ResourceLocation spritePath = MidnightControlsClient.WAYLAND_CURSOR_TEXTURE_LIGHT;
            if (MidnightControlsConfig.virtualMouseSkin == VirtualMouseSkin.DEFAULT_DARK || MidnightControlsConfig.virtualMouseSkin == VirtualMouseSkin.SECOND_DARK) {
                spritePath = MidnightControlsClient.WAYLAND_CURSOR_TEXTURE_DARK;
            }
            TextureAtlasSprite sprite = client.getGuiSprites().getSprite(spritePath);
            MidnightControlsRenderer.drawUnalignedTexturedQuad(sprite.atlasLocation(), context, mouseX, mouseX + 8.0f, mouseY, mouseY + 8.0f, 999.0f, sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static void renderVirtualCursor(@NotNull GuiGraphics context, @NotNull Minecraft client) {
        CompatHandler.SlotPos slot;
        if (!MidnightControlsConfig.virtualMouse || client.screen == null || MidnightInput.isScreenInteractive(client.screen)) {
            return;
        }
        float mouseX = (float)client.mouseHandler.xpos() * (float)client.getWindow().getGuiScaledWidth() / (float)client.getWindow().getScreenWidth();
        float mouseY = (float)client.mouseHandler.ypos() * (float)client.getWindow().getGuiScaledHeight() / (float)client.getWindow().getScreenHeight();
        boolean hoverSlot = false;
        Screen screen = client.screen;
        if (screen instanceof HandledScreenAccessor) {
            HandledScreenAccessor inventoryScreen = (HandledScreenAccessor)screen;
            int guiLeft = inventoryScreen.getX();
            int guiTop = inventoryScreen.getY();
            Slot slot2 = inventoryScreen.midnightcontrols$getSlotAt(mouseX, mouseY);
            if (slot2 != null) {
                mouseX = guiLeft + slot2.x;
                mouseY = guiTop + slot2.y;
                hoverSlot = true;
            }
        }
        if (!hoverSlot && client.screen != null && (slot = MidnightControlsCompat.getSlotAt(client.screen, (int)mouseX, (int)mouseY)) != null) {
            mouseX = slot.x();
            mouseY = slot.y();
            hoverSlot = true;
        }
        if (!hoverSlot) {
            mouseX -= 8.0f;
            mouseY -= 8.0f;
        }
        try {
            TextureAtlasSprite sprite = client.getGuiSprites().getSprite(MidnightControls.id(MidnightControlsConfig.virtualMouseSkin.getSpritePath() + (hoverSlot ? "_slot" : "")));
            MidnightControlsRenderer.drawUnalignedTexturedQuad(sprite.atlasLocation(), context, mouseX, mouseX + 16.0f, mouseY, mouseY + 16.0f, 999.0f, sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static void drawUnalignedTexturedQuad(ResourceLocation texture, GuiGraphics context, float x1, float x2, float y1, float y2, float z, float u1, float u2, float v1, float v2) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix4f = context.pose().last().pose();
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(matrix4f, x1, y1, z).setUv(u1, v1);
        bufferBuilder.addVertex(matrix4f, x1, y2, z).setUv(u1, v2);
        bufferBuilder.addVertex(matrix4f, x2, y2, z).setUv(u2, v2);
        bufferBuilder.addVertex(matrix4f, x2, y1, z).setUv(u2, v1);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
    }

    public record ButtonSize(int length, int height) {
    }
}

