/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.gui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import eu.midnightdust.midnightcontrols.ControlsMode;
import eu.midnightdust.midnightcontrols.MidnightControls;
import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.compat.MidnightControlsCompat;
import eu.midnightdust.midnightcontrols.client.controller.ButtonBinding;
import eu.midnightdust.midnightcontrols.client.enums.HudSide;
import eu.midnightdust.midnightcontrols.client.gui.MidnightControlsRenderer;
import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.thinkingstudio.obsidianui.hud.Hud;

public class MidnightControlsHud
extends Hud {
    private final Minecraft client = Minecraft.getInstance();
    private int attackWidth = 0;
    private int attackButtonWidth = 0;
    private int dropItemWidth = 0;
    private int dropItemButtonWidth = 0;
    private int inventoryWidth = 0;
    private int inventoryButtonWidth = 0;
    private int swapHandsWidth = 0;
    private int swapHandsButtonWidth = 0;
    private boolean showSwapHandsAction = false;
    private int useWidth = 0;
    private int useButtonWidth = 0;
    private String attackAction = "";
    private String placeAction = "";
    private int ticksDisplayedCrosshair = 0;
    private static boolean isCrammed = false;

    public MidnightControlsHud() {
        super(MidnightControls.id("hud/button_indicator"));
    }

    public void init(@NotNull Minecraft client, int screenWidth, int screenHeight) {
        super.init(client, screenWidth, screenHeight);
        this.inventoryWidth = this.width(ButtonBinding.INVENTORY);
        this.inventoryButtonWidth = MidnightControlsRenderer.getBindingIconWidth(ButtonBinding.INVENTORY);
        this.swapHandsWidth = this.width(ButtonBinding.SWAP_HANDS);
        this.swapHandsButtonWidth = MidnightControlsRenderer.getBindingIconWidth(ButtonBinding.SWAP_HANDS);
        this.dropItemWidth = this.width(ButtonBinding.DROP_ITEM);
        this.dropItemButtonWidth = MidnightControlsRenderer.getBindingIconWidth(ButtonBinding.DROP_ITEM);
        this.attackButtonWidth = MidnightControlsRenderer.getBindingIconWidth(ButtonBinding.ATTACK);
        this.useButtonWidth = MidnightControlsRenderer.getBindingIconWidth(ButtonBinding.USE);
    }

    public void render(GuiGraphics context, DeltaTracker tickCounter) {
        if (this.client == null) {
            return;
        }
        if (MidnightControlsConfig.controlsMode == ControlsMode.CONTROLLER && this.client.screen == null) {
            isCrammed = this.client.getWindow().getGuiScaledWidth() < 520;
            int y = this.bottom(2);
            PoseStack matrices = context.pose();
            matrices.pushPose();
            this.renderFirstIcons(context, MidnightControlsConfig.hudSide == HudSide.LEFT ? 2 : this.client.getWindow().getGuiScaledWidth() - 2, y);
            this.renderSecondIcons(context, MidnightControlsConfig.hudSide == HudSide.RIGHT ? 2 : this.client.getWindow().getGuiScaledWidth() - 2, y);
            this.renderFirstSection(context, MidnightControlsConfig.hudSide == HudSide.LEFT ? 2 : this.client.getWindow().getGuiScaledWidth() - 2, y);
            this.renderSecondSection(context, MidnightControlsConfig.hudSide == HudSide.RIGHT ? 2 : this.client.getWindow().getGuiScaledWidth() - 2, y);
            matrices.popPose();
        }
        if (MidnightControlsClient.reacharound.isLastReacharoundVertical()) {
            Window window = this.client.getWindow();
            String text = "[  ]";
            float scale = Math.min(5.0f, (float)this.ticksDisplayedCrosshair + tickCounter.getGameTimeDeltaPartialTick(true)) / 5.0f;
            scale *= scale;
            int opacity = (int)(255.0f * scale) << 24;
            context.drawString(this.client.font, text, (int)((float)window.getGuiScaledWidth() / 2.0f - (float)this.client.font.width(text) / 2.0f), (int)((float)window.getGuiScaledHeight() / 2.0f - 4.0f), 0xCCCCCC | opacity, false);
        }
    }

    public void renderFirstIcons(GuiGraphics context, int x, int y) {
        int currentX;
        int offset = 2 + this.inventoryWidth + this.inventoryButtonWidth + 4;
        int n = currentX = MidnightControlsConfig.hudSide == HudSide.LEFT ? x : x - this.inventoryButtonWidth;
        if (!ButtonBinding.INVENTORY.isNotBound()) {
            this.drawButton(context, currentX, y, ButtonBinding.INVENTORY, true);
        }
        if (!ButtonBinding.SWAP_HANDS.isNotBound() && !isCrammed && this.showSwapHandsAction) {
            this.drawButton(context, currentX += MidnightControlsConfig.hudSide == HudSide.LEFT ? offset : -offset, y, ButtonBinding.SWAP_HANDS, true);
        }
        offset = 2 + this.swapHandsWidth + this.dropItemButtonWidth + 4;
        if (((Boolean)this.client.options.showSubtitles().get()).booleanValue() && MidnightControlsConfig.hudSide == HudSide.RIGHT) {
            currentX += -offset;
        } else {
            currentX = MidnightControlsConfig.hudSide == HudSide.LEFT ? x : x - this.dropItemButtonWidth;
            y -= 20;
        }
        if (!ButtonBinding.DROP_ITEM.isNotBound() && this.client.player != null) {
            this.drawButton(context, currentX, y, ButtonBinding.DROP_ITEM, !this.client.player.getMainHandItem().isEmpty());
        }
    }

    public void renderSecondIcons(GuiGraphics context, int x, int y) {
        int currentX = x;
        if (isCrammed && this.showSwapHandsAction && !((Boolean)this.client.options.showSubtitles().get()).booleanValue() && !ButtonBinding.SWAP_HANDS.isNotBound()) {
            if (MidnightControlsConfig.hudSide == HudSide.LEFT) {
                currentX -= this.useButtonWidth;
            }
            this.drawButton(context, currentX, y, ButtonBinding.SWAP_HANDS, true);
            currentX = x;
            y -= 20;
        }
        if (!this.placeAction.isEmpty() && !ButtonBinding.USE.isNotBound()) {
            if (MidnightControlsConfig.hudSide == HudSide.LEFT) {
                currentX -= this.useButtonWidth;
            }
            this.drawButton(context, currentX, y, ButtonBinding.USE, true);
            int offset = 2 + this.useWidth + 4;
            if (((Boolean)this.client.options.showSubtitles().get()).booleanValue() && MidnightControlsConfig.hudSide == HudSide.LEFT) {
                currentX -= offset;
            } else {
                currentX = x;
                y -= 20;
            }
        }
        if (MidnightControlsConfig.hudSide == HudSide.LEFT) {
            currentX -= this.attackButtonWidth;
        }
        if (!ButtonBinding.ATTACK.isNotBound()) {
            this.drawButton(context, currentX, y, ButtonBinding.ATTACK, this.attackWidth != 0);
        }
    }

    public void renderFirstSection(GuiGraphics context, int x, int y) {
        int currentX;
        int n = currentX = MidnightControlsConfig.hudSide == HudSide.LEFT ? x + this.inventoryButtonWidth + 2 : x - this.inventoryButtonWidth - 2 - this.inventoryWidth;
        if (!ButtonBinding.INVENTORY.isNotBound()) {
            this.drawTip(context, currentX, y, ButtonBinding.INVENTORY, true);
        }
        currentX += MidnightControlsConfig.hudSide == HudSide.LEFT ? this.inventoryWidth + 4 + this.swapHandsButtonWidth + 2 : -this.swapHandsWidth - 2 - this.swapHandsButtonWidth - 4;
        if (!ButtonBinding.SWAP_HANDS.isNotBound() && !isCrammed && this.showSwapHandsAction) {
            this.drawTip(context, currentX, y, ButtonBinding.SWAP_HANDS, true);
        }
        if (((Boolean)this.client.options.showSubtitles().get()).booleanValue() && MidnightControlsConfig.hudSide == HudSide.RIGHT) {
            currentX += -this.dropItemWidth - 2 - this.dropItemButtonWidth - 4;
        } else {
            y -= 20;
            int n2 = currentX = MidnightControlsConfig.hudSide == HudSide.LEFT ? x + this.dropItemButtonWidth + 2 : x - this.dropItemButtonWidth - 2 - this.dropItemWidth;
        }
        if (!ButtonBinding.DROP_ITEM.isNotBound() && this.client.player != null) {
            this.drawTip(context, currentX, y, ButtonBinding.DROP_ITEM, !this.client.player.getMainHandItem().isEmpty());
        }
    }

    public void renderSecondSection(GuiGraphics context, int x, int y) {
        int currentX = x;
        if (isCrammed && this.showSwapHandsAction && !((Boolean)this.client.options.showSubtitles().get()).booleanValue() && !ButtonBinding.SWAP_HANDS.isNotBound()) {
            this.drawTip(context, currentX += MidnightControlsConfig.hudSide == HudSide.RIGHT ? this.swapHandsButtonWidth + 2 : -this.swapHandsButtonWidth - 2 - this.swapHandsWidth, y, ButtonBinding.SWAP_HANDS, true);
            currentX = x;
            y -= 20;
        }
        if (!this.placeAction.isEmpty()) {
            this.drawTip(context, currentX += MidnightControlsConfig.hudSide == HudSide.RIGHT ? this.useButtonWidth + 2 : -this.useButtonWidth - 2 - this.useWidth, y, this.placeAction, true);
            if (((Boolean)this.client.options.showSubtitles().get()).booleanValue() && MidnightControlsConfig.hudSide == HudSide.LEFT) {
                currentX -= 4;
            } else {
                currentX = x;
                y -= 20;
            }
        }
        currentX += MidnightControlsConfig.hudSide == HudSide.RIGHT ? this.attackButtonWidth + 2 : -this.attackButtonWidth - 2 - this.attackWidth;
        if (!ButtonBinding.ATTACK.isNotBound()) {
            this.drawTip(context, currentX, y, this.attackAction, this.attackWidth != 0);
        }
    }

    public void tick() {
        if (this.client == null) {
            return;
        }
        super.tick();
        if (MidnightControlsConfig.controlsMode == ControlsMode.CONTROLLER) {
            String customAttackAction;
            Object placeHitResult;
            if (this.client.hitResult == null) {
                return;
            }
            if (this.client.hitResult.getType() == HitResult.Type.MISS) {
                placeHitResult = MidnightControlsClient.reacharound.getLastReacharoundResult();
                this.attackAction = "";
                this.attackWidth = 0;
            } else {
                placeHitResult = this.client.hitResult.getType() == HitResult.Type.BLOCK ? (BlockHitResult)this.client.hitResult : null;
                this.attackAction = this.client.hitResult.getType() == HitResult.Type.BLOCK ? "midnightcontrols.action.hit" : ButtonBinding.ATTACK.getTranslationKey();
                this.attackWidth = this.width(this.attackAction);
            }
            if (MidnightControlsClient.reacharound.isLastReacharoundVertical()) {
                if (this.ticksDisplayedCrosshair < 5) {
                    ++this.ticksDisplayedCrosshair;
                }
            } else {
                this.ticksDisplayedCrosshair = 0;
            }
            if ((customAttackAction = MidnightControlsCompat.getAttackActionAt(this.client, placeHitResult)) != null) {
                this.attackAction = customAttackAction;
                this.attackWidth = this.width(customAttackAction);
            }
            ItemStack stack = null;
            if (this.client.player != null && ((stack = this.client.player.getMainHandItem()) == null || stack.isEmpty())) {
                stack = this.client.player.getOffhandItem();
            }
            String placeAction = stack == null || stack.isEmpty() ? "" : (placeHitResult != null && stack.getItem() instanceof BlockItem ? "midnightcontrols.action.place" : ButtonBinding.USE.getTranslationKey());
            String customUseAction = MidnightControlsCompat.getUseActionAt(this.client, placeHitResult);
            if (customUseAction != null) {
                placeAction = customUseAction;
            }
            this.placeAction = placeAction;
            this.showSwapHandsAction = !this.client.player.getMainHandItem().isEmpty() || !this.client.player.getOffhandItem().isEmpty();
            this.useWidth = this.placeAction.isEmpty() ? 0 : this.width(this.placeAction);
        }
    }

    public boolean hasTicks() {
        return true;
    }

    private int bottom(int y) {
        return this.client.getWindow().getGuiScaledHeight() - y - 20;
    }

    private int width(@NotNull ButtonBinding binding) {
        return this.width(binding.getTranslationKey());
    }

    private int width(@Nullable String text) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        return this.client.font.width(I18n.get((String)text, (Object[])new Object[0]));
    }

    private void drawButton(GuiGraphics context, int x, int y, @NotNull ButtonBinding button, boolean display) {
        if (display) {
            MidnightControlsRenderer.drawButton(context, x, y, button, this.client);
        }
    }

    private void drawTip(GuiGraphics context, int x, int y, @NotNull ButtonBinding button, boolean display) {
        this.drawTip(context, x, y, button.getTranslationKey(), display);
    }

    private void drawTip(GuiGraphics context, int x, int y, @NotNull String action, boolean display) {
        if (!display) {
            return;
        }
        String translatedAction = I18n.get((String)action, (Object[])new Object[0]);
        Objects.requireNonNull(this.client.font);
        int textY = 10 - 9 / 2 + 1;
        context.drawString(this.client.font, translatedAction, x, y + textY, 0xE0E0E0, false);
    }
}

