/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.gui;

import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.controller.Controller;
import eu.midnightdust.midnightcontrols.client.gui.ReloadControllerMappingsOption;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.network.chat.Component;
import org.thinkingstudio.obsidianui.Position;
import org.thinkingstudio.obsidianui.SprucePositioned;
import org.thinkingstudio.obsidianui.option.SpruceOption;
import org.thinkingstudio.obsidianui.option.SpruceSimpleActionOption;
import org.thinkingstudio.obsidianui.widget.SpruceWidget;
import org.thinkingstudio.obsidianui.widget.container.SpruceContainerWidget;
import org.thinkingstudio.obsidianui.widget.text.SpruceTextAreaWidget;

public class MappingsStringInputWidget
extends SpruceContainerWidget {
    private final SpruceOption copyGuidOption;
    private final SpruceOption reloadMappingsOption = ReloadControllerMappingsOption.newOption(btn -> this.writeMappings());
    private String mappings;
    private SpruceTextAreaWidget textArea;

    protected MappingsStringInputWidget(Position position, int width, int height) {
        super(position, width, height);
        this.copyGuidOption = SpruceSimpleActionOption.of((String)"midnightcontrols.menu.copy_controller_guid", button -> this.client.keyboardHandler.setClipboard(MidnightControlsConfig.getController().getGuid()));
        this.init();
    }

    public void removed() {
        this.writeMappings();
        Controller.updateMappings();
    }

    public void onClose() {
        this.removed();
    }

    public void writeMappings() {
        if (this.textArea != null) {
            this.mappings = this.textArea.getText();
            try {
                FileWriter fw = new FileWriter(MidnightControlsClient.MAPPINGS_FILE, false);
                fw.write(this.mappings);
                fw.close();
            }
            catch (IOException e) {
                if (this.client != null) {
                    this.client.getToasts().addToast((Toast)SystemToast.multiline((Minecraft)this.client, (SystemToast.SystemToastId)SystemToast.SystemToastId.PERIODIC_NOTIFICATION, (Component)Component.translatable((String)"midnightcontrols.controller.mappings.error.write"), (Component)Component.empty()));
                }
                e.fillInStackTrace();
            }
        }
    }

    protected void init() {
        if (this.textArea != null) {
            this.mappings = this.textArea.getText();
        }
        String mappings = "";
        if (this.mappings != null) {
            mappings = this.mappings;
        } else if (MidnightControlsClient.MAPPINGS_FILE.exists()) {
            try {
                this.mappings = mappings = String.join((CharSequence)"\n", Files.readAllLines(MidnightControlsClient.MAPPINGS_FILE.toPath()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        int textFieldWidth = (int)((double)this.width * 0.8333333333333334);
        this.textArea = new SpruceTextAreaWidget(Position.of((SprucePositioned)this, (int)(this.width / 2 - textFieldWidth / 2), (int)0), textFieldWidth, this.height - 50, (Component)Component.literal((String)mappings));
        this.textArea.setText(mappings);
        int n = this.textArea.getInnerHeight();
        Objects.requireNonNull(this.client.font);
        this.textArea.setDisplayedLines(n / 9);
        this.addChild((SpruceWidget)this.textArea);
        this.addChild(this.reloadMappingsOption.createWidget(Position.of((int)(this.width / 2 - 155), (int)(this.height - 29)), 257));
        this.addChild(this.copyGuidOption.createWidget(Position.of((int)(this.width / 2 + 105), (int)(this.height - 29)), 65));
    }

    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.renderWidget(context, mouseX, mouseY, delta);
        context.drawCenteredString(this.client.font, (Component)Component.translatable((String)"midnightcontrols.menu.multiple_mapping_tip"), this.textArea.getX() + this.textArea.getWidth() / 2, this.textArea.getY() + this.textArea.getHeight() - 12, 0x888888);
        context.drawCenteredString(this.client.font, (Component)Component.translatable((String)"midnightcontrols.menu.current_controller_guid", (Object[])new Object[]{MidnightControlsConfig.getController().getGuid()}), this.textArea.getX() + this.textArea.getWidth() / 2, this.height - 21, 0xFFFFFF);
    }
}

