/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.enums;

import java.util.Arrays;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public enum VirtualMouseSkin {
    DEFAULT_LIGHT("default_light"),
    DEFAULT_DARK("default_dark"),
    SECOND_LIGHT("second_light"),
    SECOND_DARK("second_dark");

    private final String name;
    private final Component text;

    private VirtualMouseSkin(String name) {
        this.name = name;
        this.text = Component.translatable((String)this.getTranslationKey());
    }

    @NotNull
    public VirtualMouseSkin next() {
        VirtualMouseSkin[] v = VirtualMouseSkin.values();
        if (v.length == this.ordinal() + 1) {
            return v[0];
        }
        return v[this.ordinal() + 1];
    }

    @NotNull
    public String getTranslationKey() {
        return "midnightcontrols.virtual_mouse.skin." + this.getName();
    }

    @NotNull
    public Component getTranslatedText() {
        return this.text;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Deprecated
    @NotNull
    public static Optional<VirtualMouseSkin> byId(@NotNull String id) {
        return Arrays.stream(VirtualMouseSkin.values()).filter(mode -> mode.getName().equalsIgnoreCase(id)).findFirst();
    }

    public String getSpritePath() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "cursor/light/default";
            case 1 -> "cursor/dark/default";
            case 2 -> "cursor/light/secondary";
            case 3 -> "cursor/dark/secondary";
        };
    }
}

