/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.controller;

import eu.midnightdust.midnightcontrols.client.controller.ButtonBinding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import org.aperlambda.lambdacommon.Identifier;
import org.jetbrains.annotations.NotNull;

public class ButtonCategory {
    private final List<ButtonBinding> bindings = new ArrayList<ButtonBinding>();
    private final ResourceLocation id;
    private final int priority;

    public ButtonCategory(@NotNull ResourceLocation id, int priority) {
        this.id = id;
        this.priority = priority;
    }

    public ButtonCategory(@NotNull ResourceLocation id) {
        this(id, 100);
    }

    @Deprecated
    public ButtonCategory(@NotNull Identifier id, int priority) {
        this(ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)id.getName()), priority);
    }

    @Deprecated
    public ButtonCategory(@NotNull Identifier id) {
        this(id, 100);
    }

    public void registerBinding(@NotNull ButtonBinding binding) {
        if (this.bindings.contains(binding)) {
            throw new IllegalStateException("Cannot register twice a button binding in the same category.");
        }
        this.bindings.add(binding);
    }

    public void registerAllBindings(ButtonBinding ... bindings) {
        this.registerAllBindings(Arrays.asList(bindings));
    }

    public void registerAllBindings(@NotNull List<ButtonBinding> bindings) {
        bindings.forEach(this::registerBinding);
    }

    @NotNull
    public List<ButtonBinding> getBindings() {
        return Collections.unmodifiableList(this.bindings);
    }

    @NotNull
    public String getTranslatedName() {
        if (this.id.getNamespace().equals("minecraft")) {
            return I18n.get((String)this.id.getPath(), (Object[])new Object[0]);
        }
        return I18n.get((String)(this.id.getNamespace() + "." + this.id.getPath()), (Object[])new Object[0]);
    }

    public int getPriority() {
        return this.priority;
    }

    @NotNull
    public ResourceLocation getIdentifier() {
        return this.id;
    }
}

