/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client;

import eu.midnightdust.midnightcontrols.MidnightControlsFeature;
import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MidnightReacharound {
    private BlockHitResult lastReacharoundResult = null;
    private boolean lastReacharoundVertical = false;
    private boolean onSlab = false;

    public void tick() {
        this.lastReacharoundResult = this.tryVerticalReachAround();
        if (this.lastReacharoundResult == null) {
            this.lastReacharoundResult = this.tryHorizontalReachAround();
            this.lastReacharoundVertical = false;
        } else {
            this.lastReacharoundVertical = true;
        }
    }

    @Nullable
    public BlockHitResult getLastReacharoundResult() {
        return this.lastReacharoundResult;
    }

    public boolean isLastReacharoundVertical() {
        return this.lastReacharoundVertical;
    }

    public boolean isReacharoundAvailable() {
        return MidnightControlsFeature.HORIZONTAL_REACHAROUND.isAvailable() || MidnightControlsFeature.VERTICAL_REACHAROUND.isAvailable();
    }

    public static float getPlayerRange(@NotNull Minecraft client) {
        return client.player != null ? Double.valueOf(client.player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE)).floatValue() : 0.0f;
    }

    @Nullable
    public BlockHitResult tryVerticalReachAround() {
        if (!MidnightControlsFeature.VERTICAL_REACHAROUND.isAvailable()) {
            return null;
        }
        if (MidnightControlsClient.client.player == null || MidnightControlsClient.client.level == null || MidnightControlsClient.client.hitResult == null || MidnightControlsClient.client.hitResult.getType() != HitResult.Type.MISS || !MidnightControlsClient.client.player.onGround() || MidnightControlsClient.client.player.getViewXRot(0.0f) < 80.0f || MidnightControlsClient.client.player.isHandsBusy()) {
            return null;
        }
        Vec3 pos = MidnightControlsClient.client.player.getEyePosition(1.0f);
        Vec3 rotationVec = MidnightControlsClient.client.player.getViewVector(1.0f);
        float range = MidnightReacharound.getPlayerRange(MidnightControlsClient.client);
        Vec3 rayVec = pos.add(rotationVec.x * (double)range, rotationVec.y * (double)range, rotationVec.z * (double)range).add(0.0, 0.75, 0.0);
        BlockHitResult result = MidnightControlsClient.client.level.clip(new ClipContext(pos, rayVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)MidnightControlsClient.client.player));
        if (result.getType() == HitResult.Type.BLOCK) {
            BlockPos blockPos = result.getBlockPos().below();
            BlockState state = MidnightControlsClient.client.level.getBlockState(blockPos);
            if (MidnightControlsClient.client.player.blockPosition().getY() - blockPos.getY() > 1 && (MidnightControlsClient.client.level.isEmptyBlock(blockPos) || state.canBeReplaced())) {
                return new BlockHitResult(result.getLocation(), Direction.DOWN, blockPos, false);
            }
        }
        return null;
    }

    @Nullable
    public BlockHitResult tryHorizontalReachAround() {
        if (!MidnightControlsFeature.HORIZONTAL_REACHAROUND.isAvailable()) {
            return null;
        }
        if (MidnightControlsClient.client.level != null && MidnightControlsClient.client.player != null && MidnightControlsClient.client.hitResult != null && MidnightControlsClient.client.hitResult.getType() == HitResult.Type.MISS && MidnightControlsClient.client.player.onGround() && MidnightControlsClient.client.player.getViewXRot(0.0f) >= 35.0f) {
            if (MidnightControlsClient.client.player.isHandsBusy()) {
                return null;
            }
            Vec3 playerPosi = MidnightControlsClient.client.player.position();
            Vec3 playerPos = new Vec3(playerPosi.x(), playerPosi.y() - 1.0, playerPosi.z());
            if (MidnightControlsClient.client.player.getY() - playerPos.y() - 1.0 >= 0.25) {
                playerPos = playerPosi;
                this.onSlab = true;
            } else {
                this.onSlab = false;
            }
            Vec3 targetPos = new Vec3(MidnightControlsClient.client.hitResult.getLocation().x(), MidnightControlsClient.client.hitResult.getLocation().y(), MidnightControlsClient.client.hitResult.getLocation().z()).subtract(playerPos);
            Vec3 vector = new Vec3(Mth.clamp((double)targetPos.x(), (double)-1.0, (double)1.0), 0.0, Mth.clamp((double)targetPos.z(), (double)-1.0, (double)1.0));
            Vec3 blockPos = playerPos.add(vector);
            BlockPos blockyPos = BlockPos.containing((Position)blockPos);
            Direction direction = MidnightControlsClient.client.player.getDirection();
            BlockState state = MidnightControlsClient.client.level.getBlockState(blockyPos);
            if (!state.isAir()) {
                return null;
            }
            BlockState adjacentBlockState = MidnightControlsClient.client.level.getBlockState(blockyPos.relative(direction.getOpposite()));
            if (adjacentBlockState.isAir() || adjacentBlockState.getBlock() instanceof LiquidBlock || vector.x() == 0.0 && vector.z() == 0.0) {
                return null;
            }
            return new BlockHitResult(blockPos, direction, blockyPos, false);
        }
        return null;
    }

    @NotNull
    public BlockHitResult withSideForReacharound(@NotNull BlockHitResult result, @Nullable ItemStack stack) {
        if (stack == null || stack.isEmpty() || !(stack.getItem() instanceof BlockItem)) {
            return result;
        }
        return this.withSideForReacharound(result, Block.byItem((Item)stack.getItem()));
    }

    @NotNull
    public BlockHitResult withSideForReacharound(@NotNull BlockHitResult result, @NotNull Block block) {
        if (block instanceof SlabBlock) {
            result = this.onSlab ? result.withDirection(Direction.UP) : result.withDirection(Direction.DOWN);
        }
        return result;
    }
}

