/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client;

import com.google.common.collect.ImmutableSet;
import eu.midnightdust.lib.util.PlatformFunctions;
import eu.midnightdust.midnightcontrols.MidnightControls;
import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.compat.EmotecraftCompat;
import eu.midnightdust.midnightcontrols.client.compat.LibGuiCompat;
import eu.midnightdust.midnightcontrols.client.compat.MidnightControlsCompat;
import eu.midnightdust.midnightcontrols.client.compat.YACLCompat;
import eu.midnightdust.midnightcontrols.client.controller.ButtonBinding;
import eu.midnightdust.midnightcontrols.client.controller.Controller;
import eu.midnightdust.midnightcontrols.client.controller.InputManager;
import eu.midnightdust.midnightcontrols.client.enums.ButtonState;
import eu.midnightdust.midnightcontrols.client.enums.CameraMode;
import eu.midnightdust.midnightcontrols.client.gui.RingScreen;
import eu.midnightdust.midnightcontrols.client.gui.widget.ControllerControlsWidget;
import eu.midnightdust.midnightcontrols.client.mixin.AdvancementsScreenAccessor;
import eu.midnightdust.midnightcontrols.client.mixin.CreativeInventoryScreenAccessor;
import eu.midnightdust.midnightcontrols.client.mixin.MouseAccessor;
import eu.midnightdust.midnightcontrols.client.ring.RingPage;
import eu.midnightdust.midnightcontrols.client.touch.gui.TouchscreenOverlay;
import eu.midnightdust.midnightcontrols.client.util.HandledScreenAccessor;
import eu.midnightdust.midnightcontrols.client.util.InventoryUtil;
import eu.midnightdust.midnightcontrols.client.util.MathUtil;
import eu.midnightdust.midnightcontrols.client.util.storage.AxisStorage;
import eu.midnightdust.midnightcontrols.client.util.storage.ButtonStorage;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.advancements.AdvancementTab;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import net.minecraft.client.gui.screens.options.controls.KeyBindsScreen;
import net.minecraft.client.gui.screens.worldselection.WorldSelectionList;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFWGamepadState;
import org.thinkingstudio.obsidianui.navigation.NavigationDirection;
import org.thinkingstudio.obsidianui.screen.SpruceScreen;
import org.thinkingstudio.obsidianui.widget.AbstractSprucePressableButtonWidget;
import org.thinkingstudio.obsidianui.widget.SpruceElement;
import org.thinkingstudio.obsidianui.widget.SpruceLabelWidget;
import org.thinkingstudio.obsidianui.widget.SpruceWidget;
import org.thinkingstudio.obsidianui.widget.container.SpruceEntryListWidget;
import org.thinkingstudio.obsidianui.widget.container.SpruceParentWidget;

public class MidnightInput {
    public static final Map<Integer, Integer> BUTTON_COOLDOWNS = new HashMap<Integer, Integer>();
    public int actionGuiCooldown = 0;
    public int joystickCooldown = 0;
    public boolean ignoreNextARelease = false;
    public boolean ignoreNextXRelease = false;
    private double targetYaw = 0.0;
    private double targetPitch = 0.0;
    private float prevXAxis = 0.0f;
    private float prevYAxis = 0.0f;
    public float mouseSpeedX = 0.0f;
    public float mouseSpeedY = 0.0f;
    public int inventoryInteractionCooldown = 0;
    public int screenCloseCooldown = 0;
    private ControllerControlsWidget controlsInput = null;
    final MathUtil.PolarUtil polarUtil = new MathUtil.PolarUtil();
    private double prevX = 0.0;
    private double prevY = 0.0;
    private double xValue;
    private AxisStorage.Polarity xPolarity;

    public void tick() {
        this.targetYaw = 0.0;
        this.targetPitch = 0.0;
        if (MidnightControlsClient.BINDING_LOOK_UP.isDown()) {
            this.handleFlatLook(AxisStorage.of(3, -0.8f, 0.0));
        } else if (MidnightControlsClient.BINDING_LOOK_DOWN.isDown()) {
            this.handleFlatLook(AxisStorage.of(3, 0.8f, 0.0));
        }
        if (MidnightControlsClient.BINDING_LOOK_LEFT.isDown()) {
            this.handleFlatLook(AxisStorage.of(2, -0.8f, 0.0));
        } else if (MidnightControlsClient.BINDING_LOOK_RIGHT.isDown()) {
            this.handleFlatLook(AxisStorage.of(2, 0.8f, 0.0));
        }
        InputManager.INPUT_MANAGER.tick();
    }

    public void tickController() {
        boolean allowInput;
        BUTTON_COOLDOWNS.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).forEach(entry -> BUTTON_COOLDOWNS.put((Integer)entry.getKey(), (Integer)entry.getValue() - 1));
        if (this.actionGuiCooldown > 0) {
            --this.actionGuiCooldown;
        }
        if (this.screenCloseCooldown > 0) {
            --this.screenCloseCooldown;
        }
        if (this.joystickCooldown > 0) {
            --this.joystickCooldown;
        }
        InputManager.updateStates();
        Controller controller = MidnightControlsConfig.getController();
        if (controller.isConnected()) {
            GLFWGamepadState state = controller.getState();
            this.fetchButtonInput(state, false);
            this.fetchTriggerInput(state, false);
            this.fetchJoystickInput(state, false, false);
        }
        MidnightControlsConfig.getSecondController().filter(Controller::isConnected).ifPresent(joycon -> {
            GLFWGamepadState state = joycon.getState();
            this.fetchButtonInput(state, true);
            this.fetchTriggerInput(state, true);
            this.fetchJoystickInput(state, true, false);
        });
        boolean bl = allowInput = this.controlsInput == null || this.controlsInput.focusedBinding == null;
        if (allowInput) {
            InputManager.updateBindings();
        }
        if (this.controlsInput != null) {
            InputManager.STATES.forEach((num, button) -> {
                if (button.isPressed()) {
                    System.out.println(num);
                }
            });
        }
        if (this.controlsInput != null && InputManager.STATES.int2ObjectEntrySet().parallelStream().map(Map.Entry::getValue).allMatch(ButtonState::isUnpressed)) {
            if (MidnightControlsConfig.debug) {
                MidnightControls.log("Starting MidnightInput Button Edit");
            }
            if (this.controlsInput.focusedBinding != null && !this.controlsInput.waiting) {
                int[] buttons = new int[this.controlsInput.currentButtons.size()];
                for (int i = 0; i < this.controlsInput.currentButtons.size(); ++i) {
                    buttons[i] = this.controlsInput.currentButtons.get(i);
                }
                this.controlsInput.finishBindingEdit(buttons);
                this.controlsInput = null;
            }
        }
        if (this.inventoryInteractionCooldown > 0) {
            --this.inventoryInteractionCooldown;
        }
    }

    public void tickCameraStick() {
        Controller controller = MidnightControlsConfig.getController();
        if (controller.isConnected()) {
            this.fetchJoystickInput(controller.getState(), false, true);
        }
        MidnightControlsConfig.getSecondController().filter(Controller::isConnected).ifPresent(joycon -> this.fetchJoystickInput(joycon.getState(), true, true));
    }

    public void onPreRenderScreen(@NotNull Screen screen) {
        if (!MidnightInput.isScreenInteractive(screen)) {
            InputManager.INPUT_MANAGER.updateMousePosition(MidnightControlsClient.client);
        }
    }

    public void updateCamera() {
        if (MidnightControlsClient.client.screen != null && !(MidnightControlsClient.client.screen instanceof TouchscreenOverlay)) {
            return;
        }
        LocalPlayer player = MidnightControlsClient.client.player;
        if (player == null) {
            return;
        }
        if (this.targetYaw != 0.0 || this.targetPitch != 0.0) {
            float rotationYaw = (float)((double)MidnightControlsClient.client.player.yRotO + this.targetYaw * 0.175);
            float rotationPitch = (float)((double)MidnightControlsClient.client.player.xRotO + this.targetPitch * 0.175);
            MidnightControlsClient.client.player.yRotO = rotationYaw;
            MidnightControlsClient.client.player.xRotO = Mth.clamp((float)rotationPitch, (float)-90.0f, (float)90.0f);
            MidnightControlsClient.client.player.setYRot(rotationYaw);
            MidnightControlsClient.client.player.setXRot(Mth.clamp((float)rotationPitch, (float)-90.0f, (float)90.0f));
            if (MidnightControlsClient.client.player.isHandsBusy() && MidnightControlsClient.client.player.getVehicle() != null) {
                MidnightControlsClient.client.player.getVehicle().onPassengerTurned((Entity)MidnightControlsClient.client.player);
            }
            MidnightControlsClient.client.getTutorial().onMouse(this.targetPitch, this.targetYaw);
        }
    }

    public void onScreenOpen(int windowWidth, int windowHeight) {
        if (MidnightControlsClient.client.screen == null) {
            this.mouseSpeedY = 0.0f;
            this.mouseSpeedX = 0.0f;
            InputManager.INPUT_MANAGER.resetMousePosition(windowWidth, windowHeight);
        } else if (MidnightInput.isScreenInteractive(MidnightControlsClient.client.screen) && MidnightControlsConfig.virtualMouse) {
            ((MouseAccessor)MidnightControlsClient.client.mouseHandler).midnightcontrols$onCursorPos(MidnightControlsClient.client.getWindow().getWindow(), 0.0, 0.0);
            InputManager.INPUT_MANAGER.resetMouseTarget(MidnightControlsClient.client);
        }
        this.inventoryInteractionCooldown = 5;
    }

    public void beginControlsInput(ControllerControlsWidget widget) {
        this.controlsInput = widget;
        if (widget != null) {
            this.controlsInput.currentButtons.clear();
            this.controlsInput.waiting = true;
        }
    }

    private void fetchButtonInput(@NotNull GLFWGamepadState gamepadState, boolean leftJoycon) {
        ByteBuffer buffer = gamepadState.buttons();
        for (int i = 0; i < buffer.limit(); ++i) {
            int btn = leftJoycon ? ButtonBinding.controller2Button(i) : i;
            boolean pressed = buffer.get() == 1;
            ButtonState state = ButtonState.NONE;
            ButtonState previousState = (ButtonState)((Object)InputManager.STATES.getOrDefault(btn, (Object)ButtonState.NONE));
            if (pressed != previousState.isPressed()) {
                state = pressed ? ButtonState.PRESS : ButtonState.RELEASE;
                this.handleButton(ButtonStorage.of(btn, state));
                if (pressed) {
                    BUTTON_COOLDOWNS.put(btn, 5);
                }
            } else if (pressed) {
                state = ButtonState.REPEAT;
                if (BUTTON_COOLDOWNS.getOrDefault(btn, 0) == 0) {
                    BUTTON_COOLDOWNS.put(btn, 5);
                    this.handleButton(ButtonStorage.of(btn, state));
                }
            }
            InputManager.STATES.put(btn, (Object)state);
        }
    }

    private void fetchJoystickInput(@NotNull GLFWGamepadState gamepadState, boolean leftJoycon, boolean cameraTick) {
        boolean isRadialMenu;
        FloatBuffer buffer = gamepadState.axes();
        this.polarUtil.calculate(buffer.get(0), buffer.get(1), 1.0f, MidnightControlsConfig.leftDeadZone);
        float leftX = this.polarUtil.polarX;
        float leftY = this.polarUtil.polarY;
        this.polarUtil.calculate(buffer.get(2), buffer.get(3), 1.0f, MidnightControlsConfig.rightDeadZone);
        float rightX = this.polarUtil.polarX;
        float rightY = this.polarUtil.polarY;
        boolean bl = isRadialMenu = MidnightControlsClient.client.screen instanceof RingScreen || PlatformFunctions.isModLoaded((String)"emotecraft") && EmotecraftCompat.isEmotecraftScreen(MidnightControlsClient.client.screen);
        if (!isRadialMenu) {
            for (int i = cameraTick ? 2 : 0; i < (cameraTick ? 4 : 2); ++i) {
                int axis = leftJoycon ? ButtonBinding.controller2Button(i) : i;
                float value = buffer.get(i);
                switch (i) {
                    case 0: {
                        if (!MidnightControlsConfig.analogMovement) break;
                        value = leftX;
                        break;
                    }
                    case 1: {
                        if (!MidnightControlsConfig.analogMovement) break;
                        value = leftY;
                        break;
                    }
                    case 2: {
                        value = rightX;
                        break;
                    }
                    case 3: {
                        value = rightY;
                    }
                }
                if (i == 1) {
                    value *= -1.0f;
                }
                this.handleJoystickAxis(AxisStorage.of(axis, value));
            }
        } else {
            boolean leftStickActive = leftX != 0.0f || leftY != 0.0f;
            this.handleRadialMenu(leftStickActive ? leftX : rightX, leftStickActive ? leftY : rightY);
        }
    }

    private void fetchTriggerInput(@NotNull GLFWGamepadState gamepadState, boolean leftJoycon) {
        FloatBuffer buffer = gamepadState.axes();
        for (int i = 4; i <= 5; ++i) {
            int axis = leftJoycon ? ButtonBinding.controller2Button(i) : i;
            float value = buffer.get(i);
            this.handleTriggerAxis(AxisStorage.of(axis, value, MidnightControlsConfig.triggerDeadZone));
        }
    }

    public void handleButton(ButtonStorage storage) {
        if (this.controlsInput != null && this.controlsInput.focusedBinding != null) {
            if (storage.state == ButtonState.PRESS && !this.controlsInput.currentButtons.contains(storage.button)) {
                this.controlsInput.currentButtons.add(storage.button);
                int[] buttons = new int[this.controlsInput.currentButtons.size()];
                for (int i = 0; i < this.controlsInput.currentButtons.size(); ++i) {
                    buttons[i] = this.controlsInput.currentButtons.get(i);
                }
                this.controlsInput.focusedBinding.setButton(buttons);
                this.controlsInput.waiting = false;
            }
            return;
        }
        if (MidnightControlsClient.client.screen != null && storage.state.isPressed() && storage.button == 3 && MidnightControlsConfig.arrowScreens.contains(MidnightControlsClient.client.screen.getClass().getCanonicalName())) {
            this.pressKeyboardKey(MidnightControlsClient.client, 257);
            this.screenCloseCooldown = 5;
        } else if (storage.state.isPressed()) {
            if (MidnightControlsClient.client.screen != null && storage.isDpad() && this.actionGuiCooldown == 0) {
                switch (storage.button) {
                    case 11: {
                        this.changeFocus(MidnightControlsClient.client.screen, NavigationDirection.UP);
                        break;
                    }
                    case 13: {
                        this.changeFocus(MidnightControlsClient.client.screen, NavigationDirection.DOWN);
                        break;
                    }
                    case 14: {
                        this.handleLeftRight(MidnightControlsClient.client.screen, false);
                        break;
                    }
                    case 12: {
                        this.handleLeftRight(MidnightControlsClient.client.screen, true);
                    }
                }
                if (MidnightControlsConfig.wasdScreens.contains(MidnightControlsClient.client.screen.getClass().getCanonicalName())) {
                    switch (storage.button) {
                        case 11: {
                            this.pressKeyboardKey(MidnightControlsClient.client, 87);
                            break;
                        }
                        case 13: {
                            this.pressKeyboardKey(MidnightControlsClient.client, 83);
                            break;
                        }
                        case 14: {
                            this.pressKeyboardKey(MidnightControlsClient.client, 65);
                            break;
                        }
                        case 12: {
                            this.pressKeyboardKey(MidnightControlsClient.client, 68);
                        }
                    }
                }
                return;
            }
        } else if (storage.button == 0 && MidnightControlsClient.client.screen != null && this.actionGuiCooldown == 0) {
            GuiEventListener focused = MidnightControlsClient.client.screen.getFocused();
            if (focused != null && MidnightInput.isScreenInteractive(MidnightControlsClient.client.screen)) {
                if (this.handleAButton(MidnightControlsClient.client.screen, focused)) {
                    this.actionGuiCooldown = 5;
                    return;
                }
            } else if (PlatformFunctions.isModLoaded((String)"libgui")) {
                LibGuiCompat.handlePress(MidnightControlsClient.client.screen);
            }
        }
        if (storage.button == 0 && MidnightControlsClient.client.screen != null && !MidnightInput.isScreenInteractive(MidnightControlsClient.client.screen) && this.actionGuiCooldown == 0) {
            AbstractContainerScreen handledScreen;
            Screen screen = MidnightControlsClient.client.screen;
            if (screen instanceof AbstractContainerScreen && ((HandledScreenAccessor)(handledScreen = (AbstractContainerScreen)screen)).midnightcontrols$getSlotAt(MidnightControlsClient.client.mouseHandler.xpos() * (double)MidnightControlsClient.client.getWindow().getGuiScaledWidth() / (double)MidnightControlsClient.client.getWindow().getScreenWidth(), MidnightControlsClient.client.mouseHandler.ypos() * (double)MidnightControlsClient.client.getWindow().getGuiScaledHeight() / (double)MidnightControlsClient.client.getWindow().getScreenHeight()) != null) {
                return;
            }
            if (!this.ignoreNextARelease && MidnightControlsClient.client.screen != null) {
                MouseAccessor accessor = (MouseAccessor)MidnightControlsClient.client.mouseHandler;
                accessor.midnightcontrols$onCursorPos(MidnightControlsClient.client.getWindow().getWindow(), MidnightControlsClient.client.mouseHandler.xpos(), MidnightControlsClient.client.mouseHandler.ypos());
                switch (storage.state) {
                    case PRESS: {
                        accessor.midnightcontrols$onMouseButton(MidnightControlsClient.client.getWindow().getWindow(), 0, 1, 0);
                        break;
                    }
                    case RELEASE: {
                        accessor.midnightcontrols$onMouseButton(MidnightControlsClient.client.getWindow().getWindow(), 0, 0, 0);
                        MidnightControlsClient.client.screen.setDragging(false);
                        break;
                    }
                    case REPEAT: {
                        MidnightControlsClient.client.screen.setDragging(true);
                    }
                }
                this.screenCloseCooldown = 5;
            } else {
                this.ignoreNextARelease = false;
            }
        } else if (storage.button == 2 && MidnightControlsClient.client.screen != null && !MidnightInput.isScreenInteractive(MidnightControlsClient.client.screen) && this.actionGuiCooldown == 0) {
            AbstractContainerScreen handledScreen;
            double mouseX = MidnightControlsClient.client.mouseHandler.xpos() * (double)MidnightControlsClient.client.getWindow().getGuiScaledWidth() / (double)MidnightControlsClient.client.getWindow().getScreenWidth();
            double mouseY = MidnightControlsClient.client.mouseHandler.ypos() * (double)MidnightControlsClient.client.getWindow().getGuiScaledHeight() / (double)MidnightControlsClient.client.getWindow().getScreenHeight();
            Screen screen = MidnightControlsClient.client.screen;
            if (screen instanceof AbstractContainerScreen && ((HandledScreenAccessor)(handledScreen = (AbstractContainerScreen)screen)).midnightcontrols$getSlotAt(mouseX, mouseY) != null) {
                return;
            }
            if (!this.ignoreNextXRelease && MidnightControlsClient.client.screen != null) {
                if (storage.state == ButtonState.PRESS) {
                    MidnightControlsClient.client.screen.mouseClicked(mouseX, mouseY, 1);
                } else if (storage.state == ButtonState.RELEASE) {
                    MidnightControlsClient.client.screen.mouseReleased(mouseX, mouseY, 1);
                }
                this.screenCloseCooldown = 5;
            } else {
                this.ignoreNextXRelease = false;
            }
        }
    }

    private void handleTriggerAxis(AxisStorage storage) {
        storage.setupButtonStates();
    }

    private void handleJoystickAxis(AxisStorage storage) {
        storage.setupButtonStates();
        this.handleJoystickMovement(storage);
        if (this.handleScreenScrolling(MidnightControlsClient.client.screen, storage)) {
            return;
        }
        storage.absValue = (float)Mth.clamp((double)((double)storage.absValue / MidnightControlsConfig.getAxisMaxValue(storage.axis)), (double)0.0, (double)1.0);
        if (MidnightControlsClient.client.screen == null) {
            this.handleLook(storage);
        } else {
            boolean allowMouseControl = true;
            if (this.actionGuiCooldown == 0 && MidnightControlsConfig.isMovementAxis(storage.axis) && MidnightInput.isScreenInteractive(MidnightControlsClient.client.screen)) {
                if (MidnightControlsConfig.isForwardButton(storage.axis, false, storage.buttonState)) {
                    allowMouseControl = this.changeFocus(MidnightControlsClient.client.screen, NavigationDirection.UP);
                } else if (MidnightControlsConfig.isBackButton(storage.axis, false, storage.buttonState)) {
                    allowMouseControl = this.changeFocus(MidnightControlsClient.client.screen, NavigationDirection.DOWN);
                } else if (MidnightControlsConfig.isLeftButton(storage.axis, false, storage.buttonState)) {
                    allowMouseControl = this.handleLeftRight(MidnightControlsClient.client.screen, false);
                } else if (MidnightControlsConfig.isRightButton(storage.axis, false, storage.buttonState)) {
                    allowMouseControl = this.handleLeftRight(MidnightControlsClient.client.screen, true);
                }
            }
            float movementX = 0.0f;
            float movementY = 0.0f;
            if (MidnightControlsConfig.isBackButton(storage.axis, false, storage.value > 0.0f ? ButtonState.PRESS : ButtonState.RELEASE)) {
                movementY = storage.absValue;
            } else if (MidnightControlsConfig.isForwardButton(storage.axis, false, storage.value > 0.0f ? ButtonState.PRESS : ButtonState.RELEASE)) {
                movementY = -storage.absValue;
            } else if (MidnightControlsConfig.isLeftButton(storage.axis, false, storage.value > 0.0f ? ButtonState.PRESS : ButtonState.RELEASE)) {
                movementX = -storage.absValue;
            } else if (MidnightControlsConfig.isRightButton(storage.axis, false, storage.value > 0.0f ? ButtonState.PRESS : ButtonState.RELEASE)) {
                movementX = storage.absValue;
            }
            if (MidnightControlsClient.client.screen != null && allowMouseControl) {
                boolean moving;
                boolean bl = moving = movementY != 0.0f || movementX != 0.0f;
                if (moving) {
                    if ((double)Math.abs(this.prevXAxis) < storage.deadZone && (double)Math.abs(this.prevYAxis) < storage.deadZone) {
                        InputManager.INPUT_MANAGER.resetMouseTarget(MidnightControlsClient.client);
                    }
                    this.mouseSpeedX = movementX;
                    this.mouseSpeedY = movementY;
                } else {
                    this.mouseSpeedX = 0.0f;
                    this.mouseSpeedY = 0.0f;
                }
                if (Math.abs(this.mouseSpeedX) >= 0.05f || Math.abs(this.mouseSpeedY) >= 0.05f) {
                    InputManager.queueMoveMousePosition((double)this.mouseSpeedX * MidnightControlsConfig.mouseSpeed, (double)this.mouseSpeedY * MidnightControlsConfig.mouseSpeed);
                }
                InventoryUtil.moveMouseToClosestSlot(MidnightControlsClient.client.screen);
            }
            this.prevXAxis = movementX;
            this.prevYAxis = movementY;
        }
    }

    private void handleJoystickMovement(AxisStorage storage) {
        float axisValue = storage.absValue;
        if (!MidnightControlsConfig.analogMovement || MidnightControlsClient.client.player != null && MidnightControlsClient.client.player.getVehicle() instanceof Boat) {
            axisValue = (float)((double)storage.absValue - storage.deadZone);
            axisValue /= (float)(1.0 - storage.deadZone);
            axisValue *= (float)storage.deadZone;
        }
        axisValue = (float)Math.min((double)axisValue / MidnightControlsConfig.getAxisMaxValue(storage.axis), 1.0);
        if (AxisStorage.isLeftAxis(storage.axis)) {
            MidnightControlsCompat.handleMovement(storage, axisValue);
        }
        InputManager.BUTTON_VALUES.put(storage.getButtonId(true), storage.polarity == AxisStorage.Polarity.PLUS ? axisValue : 0.0f);
        InputManager.BUTTON_VALUES.put(storage.getButtonId(false), storage.polarity == AxisStorage.Polarity.MINUS ? axisValue : 0.0f);
        storage.absValue = axisValue;
    }

    private boolean handleScreenScrolling(Screen screen, AxisStorage storage) {
        if (screen == null) {
            return false;
        }
        int preferredAxis = 3;
        if (this.controlsInput != null && this.controlsInput.focusedBinding != null) {
            if (storage.buttonState != ButtonState.NONE && !this.controlsInput.currentButtons.contains(storage.getButtonId(storage.buttonState == ButtonState.PRESS))) {
                this.controlsInput.currentButtons.add(storage.getButtonId(storage.buttonState == ButtonState.PRESS));
                int[] buttons = new int[this.controlsInput.currentButtons.size()];
                for (int i = 0; i < this.controlsInput.currentButtons.size(); ++i) {
                    buttons[i] = this.controlsInput.currentButtons.get(i);
                }
                this.controlsInput.focusedBinding.setButton(buttons);
                this.controlsInput.waiting = false;
            }
            return true;
        }
        if ((double)storage.absValue >= storage.deadZone) {
            if (screen instanceof CreativeModeInventoryScreen) {
                CreativeModeInventoryScreen creativeInventoryScreen = (CreativeModeInventoryScreen)screen;
                if (storage.axis == preferredAxis) {
                    CreativeInventoryScreenAccessor accessor = (CreativeInventoryScreenAccessor)creativeInventoryScreen;
                    if (accessor.midnightcontrols$hasScrollbar() && (double)storage.absValue >= storage.deadZone) {
                        creativeInventoryScreen.mouseScrolled(0.0, 0.0, 0.0, (double)(-(storage.value * 0.0175f)));
                    }
                    return true;
                }
            } else if (screen instanceof AdvancementsScreen) {
                AdvancementsScreen advancementsScreen = (AdvancementsScreen)screen;
                if (storage.axis == 2 || storage.axis == 3) {
                    AdvancementsScreenAccessor accessor = (AdvancementsScreenAccessor)advancementsScreen;
                    AdvancementTab tab = accessor.getSelectedTab();
                    tab.scroll(storage.axis == 2 ? (double)(-storage.value) * 1.0 : 0.0, storage.axis == 3 ? (double)(-storage.value) * 5.0 : 0.0);
                    return true;
                }
            } else if (screen != null) {
                if (storage.axis == preferredAxis && !this.handleListWidgetScrolling(screen.children(), storage.value)) {
                    try {
                        screen.mouseScrolled(0.0, 0.0, 0.0, (double)(-(storage.value * 0.0175f)));
                    }
                    catch (NullPointerException nullPointerException) {}
                } else if (MidnightInput.isScreenInteractive(screen)) {
                    if (this.joystickCooldown == 0) {
                        switch (storage.axis) {
                            case 1: {
                                this.changeFocus(screen, storage.value > 0.0f ? NavigationDirection.UP : NavigationDirection.DOWN);
                                this.joystickCooldown = 4;
                                break;
                            }
                            case 0: {
                                this.handleLeftRight(screen, storage.value > 0.0f);
                                this.joystickCooldown = 4;
                            }
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public void handleRadialMenu(float x, float y) {
        int index = -1;
        float border = 0.3f;
        if (x < -border) {
            index = 3;
            if (y < -border) {
                index = 0;
            } else if (y > border) {
                index = 5;
            }
        } else if (x > border) {
            index = 4;
            if (y < -border) {
                index = 2;
            } else if (y > border) {
                index = 7;
            }
        } else if (y < -border) {
            index = 1;
        } else if (y > border) {
            index = 6;
        }
        if (MidnightControlsClient.client.screen instanceof RingScreen && index > -1) {
            RingPage.selected = index;
        }
        if (PlatformFunctions.isModLoaded((String)"emotecraft") && EmotecraftCompat.isEmotecraftScreen(MidnightControlsClient.client.screen)) {
            EmotecraftCompat.handleEmoteSelector(index);
        }
    }

    public boolean handleListWidgetScrolling(List<? extends GuiEventListener> children, float value) {
        return children.stream().filter(element -> element instanceof SpruceEntryListWidget).map(element -> (SpruceEntryListWidget)element).filter(SpruceWidget::isFocusedOrHovered).anyMatch(element -> {
            element.mouseScrolled(0.0, 0.0, 0.0, (double)(-value));
            return true;
        }) || children.stream().filter(element -> element instanceof AbstractSelectionList).map(element -> (AbstractSelectionList)element).filter(element -> element.narrationPriority().isTerminal()).anyMatch(element -> {
            element.mouseScrolled(0.0, 0.0, 0.0, (double)(-value));
            return true;
        });
    }

    public boolean handleAButton(@NotNull Screen screen, @NotNull GuiEventListener focused) {
        if (focused instanceof AbstractButton) {
            AbstractButton widget = (AbstractButton)focused;
            widget.playDownSound(Minecraft.getInstance().getSoundManager());
            widget.onPress();
            return true;
        }
        if (focused instanceof AbstractSprucePressableButtonWidget) {
            AbstractSprucePressableButtonWidget widget = (AbstractSprucePressableButtonWidget)focused;
            widget.playDownSound();
            widget.onPress();
            return true;
        }
        if (focused instanceof SpruceLabelWidget) {
            SpruceLabelWidget labelWidget = (SpruceLabelWidget)focused;
            labelWidget.onPress();
            return true;
        }
        if (focused instanceof WorldSelectionList) {
            WorldSelectionList list = (WorldSelectionList)focused;
            list.getSelectedOpt().ifPresent(WorldSelectionList.WorldListEntry::joinWorld);
            return true;
        }
        if (focused instanceof ServerSelectionList) {
            ServerSelectionList list = (ServerSelectionList)focused;
            ServerSelectionList.Entry entry = (ServerSelectionList.Entry)list.getSelected();
            if (entry instanceof ServerSelectionList.NetworkServerEntry || entry instanceof ServerSelectionList.OnlineServerEntry) {
                ((JoinMultiplayerScreen)screen).setSelected(entry);
                ((JoinMultiplayerScreen)screen).joinSelectedServer();
            }
        } else if (focused instanceof SpruceParentWidget) {
            SpruceWidget childFocused = ((SpruceParentWidget)focused).getFocused();
            if (childFocused != null) {
                return this.handleAButton(screen, (GuiEventListener)childFocused);
            }
        } else if (focused instanceof ContainerEventHandler) {
            ContainerEventHandler widget = (ContainerEventHandler)focused;
            GuiEventListener childFocused = widget.getFocused();
            if (childFocused != null) {
                return this.handleAButton(screen, childFocused);
            }
        } else {
            if (PlatformFunctions.isModLoaded((String)"yet-another-config-lib") && YACLCompat.handleAButton(screen, focused)) {
                return true;
            }
            this.pressKeyboardKey(screen, 257);
        }
        return false;
    }

    private boolean handleLeftRight(@NotNull Screen screen, boolean right) {
        if (screen instanceof SpruceScreen) {
            SpruceScreen spruceScreen = (SpruceScreen)screen;
            spruceScreen.onNavigation(right ? NavigationDirection.RIGHT : NavigationDirection.LEFT, false);
            this.actionGuiCooldown = 5;
            return false;
        }
        if (PlatformFunctions.isModLoaded((String)"yet-another-config-lib") && YACLCompat.handleLeftRight(screen, right)) {
            this.actionGuiCooldown = 5;
            return false;
        }
        GuiEventListener focused = screen.getFocused();
        if (focused != null && this.handleRightLeftElement(focused, right)) {
            return this.changeFocus(screen, right ? NavigationDirection.RIGHT : NavigationDirection.LEFT);
        }
        return true;
    }

    private boolean handleRightLeftElement(@NotNull GuiEventListener element, boolean right) {
        GuiEventListener guiEventListener = element;
        Objects.requireNonNull(guiEventListener);
        GuiEventListener guiEventListener2 = guiEventListener;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SpruceElement.class, AbstractSliderButton.class, ContainerEventHandler.class}, (Object)guiEventListener2, n)) {
            case 0: {
                SpruceElement spruceElement = (SpruceElement)guiEventListener2;
                if (spruceElement.requiresCursor()) {
                    return true;
                }
                return !spruceElement.onNavigation(right ? NavigationDirection.RIGHT : NavigationDirection.LEFT, false);
            }
            case 1: {
                AbstractSliderButton slider = (AbstractSliderButton)guiEventListener2;
                if (!slider.active) break;
                slider.keyPressed(right ? 262 : 263, 0, 0);
                this.actionGuiCooldown = 2;
                return true;
            }
            case 2: {
                ContainerEventHandler entryList = (ContainerEventHandler)guiEventListener2;
                GuiEventListener focused = entryList.getFocused();
                if (focused == null) {
                    return true;
                }
                return this.handleRightLeftElement(focused, right);
            }
        }
        return true;
    }

    public void handleLook(AxisStorage storage) {
        if (MidnightControlsClient.client.player == null || storage.axis != 3 && storage.axis != 2) {
            return;
        }
        if (MidnightControlsConfig.cameraMode == CameraMode.FLAT) {
            this.handleFlatLook(storage);
        } else {
            this.handleAdaptiveLook(storage);
        }
        MidnightControlsCompat.handleCamera(this.targetYaw, this.targetPitch);
    }

    private void handleFlatLook(AxisStorage storage) {
        if (storage.polarity != AxisStorage.Polarity.ZERO) {
            double rotation = Math.pow(storage.value, 2.0) * 0.11 * (double)storage.polarity.multiplier;
            if (storage.axis == 3) {
                this.targetPitch = rotation * MidnightControlsConfig.getRightYAxisSign() * MidnightControlsConfig.yAxisRotationSpeed / 2.0;
            } else {
                this.targetYaw = rotation * MidnightControlsConfig.getRightXAxisSign() * MidnightControlsConfig.rotationSpeed / 2.0;
            }
        }
    }

    private void handleAdaptiveLook(AxisStorage storage) {
        if (storage.axis == 2) {
            this.xValue = storage.value;
            this.xPolarity = storage.polarity;
        } else {
            double sign;
            double yStep = MidnightControlsConfig.yAxisRotationSpeed / 50.0 * (double)0.6f + (double)0.2f;
            double xStep = MidnightControlsConfig.rotationSpeed / 50.0 * (double)0.6f + (double)0.2f;
            float yValue = storage.value;
            AxisStorage.Polarity yPolarity = storage.polarity;
            double cursorDeltaX = 2.0 * this.xValue - this.prevX;
            double cursorDeltaY = (double)(2.0f * yValue) - this.prevY;
            boolean slowdown = MidnightControlsClient.client.options.getCameraType().isFirstPerson() && Objects.requireNonNull(MidnightControlsClient.client.player).isScoping();
            double x = cursorDeltaX * xStep * (slowdown ? xStep : 1.0);
            double y = cursorDeltaY * yStep * (slowdown ? yStep : 1.0);
            double powXValue = Math.pow(x, 2.0);
            double powYValue = Math.pow(y, 2.0);
            if (this.xPolarity != AxisStorage.Polarity.ZERO) {
                sign = MidnightControlsConfig.getRightXAxisSign() * MidnightControlsConfig.rotationSpeed;
                this.targetYaw = sign * powXValue * 0.11 * (double)this.xPolarity.multiplier;
            }
            if (yPolarity != AxisStorage.Polarity.ZERO) {
                sign = MidnightControlsConfig.getRightYAxisSign() * MidnightControlsConfig.yAxisRotationSpeed;
                this.targetPitch = sign * powYValue * 0.11 * (double)yPolarity.multiplier;
            }
            this.prevY = yValue;
            this.prevX = this.xValue;
        }
    }

    public void handleTouchscreenLook(AxisStorage storage) {
        if (storage.polarity != AxisStorage.Polarity.ZERO) {
            double rotation = (double)storage.value * 0.11 * MidnightControlsConfig.touchSpeed / 5.0;
            if (storage.axis == 3) {
                this.targetPitch = rotation;
            } else {
                this.targetYaw = rotation;
            }
        }
    }

    private boolean changeFocus(@NotNull Screen screen, NavigationDirection direction) {
        if (!MidnightInput.isScreenInteractive(screen) && !screen.getClass().getCanonicalName().contains("me.jellysquid.mods.sodium.client.gui")) {
            return false;
        }
        try {
            if (screen instanceof SpruceScreen) {
                SpruceScreen spruceScreen = (SpruceScreen)screen;
                if (spruceScreen.onNavigation(direction, false)) {
                    this.actionGuiCooldown = 5;
                }
                return true;
            }
            switch (direction) {
                case UP: {
                    this.pressKeyboardKey(screen, 265);
                    break;
                }
                case DOWN: {
                    this.pressKeyboardKey(screen, 264);
                    break;
                }
                case LEFT: {
                    this.pressKeyboardKey(screen, 263);
                    break;
                }
                case RIGHT: {
                    this.pressKeyboardKey(screen, 262);
                }
            }
            this.actionGuiCooldown = 5;
            return true;
        }
        catch (Exception exception) {
            MidnightControls.warn("Unknown exception encountered while trying to change focus: " + String.valueOf(exception));
            return false;
        }
    }

    public boolean tryGoBack(@NotNull Screen screen) {
        ImmutableSet set = ImmutableSet.of((Object)"gui.back", (Object)"gui.done", (Object)"gui.cancel", (Object)"gui.toTitle", (Object)"gui.toMenu");
        if (screen instanceof KeyBindsScreen) {
            return false;
        }
        return screen.children().stream().filter(element -> element instanceof AbstractButton).map(element -> (AbstractButton)element).filter(element -> element.getMessage() != null && element.getMessage().getContents() != null).anyMatch(element -> {
            ComponentContents patt0$temp = element.getMessage().getContents();
            if (patt0$temp instanceof TranslatableContents) {
                TranslatableContents translatableText = (TranslatableContents)patt0$temp;
                if (set.stream().anyMatch(key -> translatableText.getKey().equals(key))) {
                    element.onPress();
                    return true;
                }
            }
            return false;
        });
    }

    public static boolean isScreenInteractive(@NotNull Screen screen) {
        return !(screen instanceof AbstractContainerScreen) && !MidnightControlsConfig.joystickAsMouse && !MidnightControlsConfig.mouseScreens.stream().anyMatch(a -> screen.getClass().toString().contains((CharSequence)a)) && (!(screen instanceof SpruceScreen) || !((SpruceScreen)screen).requiresCursor()) && !MidnightControlsCompat.requireMouseOnScreen(screen);
    }

    public void pressKeyboardKey(Minecraft client, int key) {
        client.keyboardHandler.keyPress(client.getWindow().getWindow(), key, 0, 1, 0);
    }

    public void pressKeyboardKey(Screen screen, int key) {
        screen.keyPressed(key, 0, 1);
    }
}

