/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client;

import com.mojang.blaze3d.platform.InputConstants;
import eu.midnightdust.lib.util.PlatformFunctions;
import eu.midnightdust.midnightcontrols.ControlsMode;
import eu.midnightdust.midnightcontrols.MidnightControls;
import eu.midnightdust.midnightcontrols.MidnightControlsFeature;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.MidnightInput;
import eu.midnightdust.midnightcontrols.client.MidnightReacharound;
import eu.midnightdust.midnightcontrols.client.compat.MidnightControlsCompat;
import eu.midnightdust.midnightcontrols.client.controller.ButtonBinding;
import eu.midnightdust.midnightcontrols.client.controller.ButtonCategory;
import eu.midnightdust.midnightcontrols.client.controller.Controller;
import eu.midnightdust.midnightcontrols.client.controller.InputManager;
import eu.midnightdust.midnightcontrols.client.gui.MidnightControlsHud;
import eu.midnightdust.midnightcontrols.client.gui.RingScreen;
import eu.midnightdust.midnightcontrols.client.mixin.KeyBindingIDAccessor;
import eu.midnightdust.midnightcontrols.client.ring.ButtonBindingRingAction;
import eu.midnightdust.midnightcontrols.client.ring.MidnightRing;
import eu.midnightdust.midnightcontrols.client.touch.TouchInput;
import eu.midnightdust.midnightcontrols.client.touch.gui.TouchscreenOverlay;
import eu.midnightdust.midnightcontrols.client.util.RainbowColor;
import eu.midnightdust.midnightcontrols.client.util.platform.NetworkUtil;
import eu.midnightdust.midnightcontrols.packet.ControlsModePayload;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;
import org.thinkingstudio.obsidianui.hud.Hud;
import org.thinkingstudio.obsidianui.hud.HudManager;

public class MidnightControlsClient
extends MidnightControls {
    public static boolean lateInitDone = false;
    public static final KeyMapping BINDING_LOOK_UP = InputManager.makeKeyBinding(MidnightControlsClient.id("look_up"), InputConstants.Type.KEYSYM, 328, "key.categories.midnightcontrols");
    public static final KeyMapping BINDING_LOOK_RIGHT = InputManager.makeKeyBinding(MidnightControlsClient.id("look_right"), InputConstants.Type.KEYSYM, 326, "key.categories.midnightcontrols");
    public static final KeyMapping BINDING_LOOK_DOWN = InputManager.makeKeyBinding(MidnightControlsClient.id("look_down"), InputConstants.Type.KEYSYM, 322, "key.categories.midnightcontrols");
    public static final KeyMapping BINDING_LOOK_LEFT = InputManager.makeKeyBinding(MidnightControlsClient.id("look_left"), InputConstants.Type.KEYSYM, 324, "key.categories.midnightcontrols");
    public static final KeyMapping BINDING_RING = InputManager.makeKeyBinding(MidnightControlsClient.id("ring"), InputConstants.Type.KEYSYM, InputConstants.UNKNOWN.getValue(), "key.categories.midnightcontrols");
    public static final ResourceLocation CONTROLLER_BUTTONS = MidnightControlsClient.id("textures/gui/controller_buttons.png");
    public static final ResourceLocation CONTROLLER_EXPANDED = MidnightControlsClient.id("textures/gui/controller_expanded.png");
    public static final ResourceLocation CONTROLLER_AXIS = MidnightControlsClient.id("textures/gui/controller_axis.png");
    public static final ResourceLocation WAYLAND_CURSOR_TEXTURE_LIGHT = MidnightControlsClient.id("cursor/light/mouse_pointer");
    public static final ResourceLocation WAYLAND_CURSOR_TEXTURE_DARK = MidnightControlsClient.id("cursor/dark/mouse_pointer");
    public static final File MAPPINGS_FILE = new File("config/gamecontrollercustommappings.txt");
    public static final Minecraft client = Minecraft.getInstance();
    public static final MidnightInput input = new MidnightInput();
    public static final MidnightRing ring = new MidnightRing();
    public static final MidnightReacharound reacharound = new MidnightReacharound();
    public static boolean isWayland;
    private static MidnightControlsHud hud;
    private static ControlsMode previousControlsMode;
    private static final MidnightControlsClient INSTANCE;

    public static void initClient() {
        ring.registerAction("buttonbinding", ButtonBindingRingAction.FACTORY);
        int delay = 0;
        int period = 1;
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    if (lateInitDone && client.isRunning() && MidnightControlsConfig.controlsMode != ControlsMode.DEFAULT && (client.isWindowActive() || MidnightControlsConfig.unfocusedInput)) {
                        input.tickCameraStick();
                        input.updateCamera();
                    }
                }
                catch (Error | Exception e) {
                    MidnightControls.logger.error("Exception encountered in camera loop: ", e);
                }
            }
        }, delay, (long)period);
        hud = new MidnightControlsHud();
        HudManager.register((Hud)hud);
        isWayland = GLFW.glfwGetVersionString().contains("Wayland");
    }

    public static void onMcInit(@NotNull Minecraft client) {
        ButtonBinding.init(client.options);
        MidnightControlsConfig.load();
        if (MidnightControlsConfig.configVersion < 2) {
            MidnightControlsConfig.mouseScreens.remove("me.jellysquid.mods.sodium.client.gui");
            MidnightControlsConfig.mouseScreens.remove("net.coderbot.iris.gui");
            MidnightControlsConfig.mouseScreens.remove("net.minecraft.class_5375");
            MidnightControlsConfig.mouseScreens.remove("net.minecraft.client.gui.screen.pack.PackScreen");
            MidnightControlsConfig.configVersion = 2;
            MidnightControlsConfig.write((String)"midnightcontrols");
        }
        hud.setVisible(MidnightControlsConfig.hudEnable);
        Controller.updateMappings();
        try {
            GLFW.glfwSetJoystickCallback((jid, event) -> {
                if (event == 262145) {
                    Controller controller = Controller.byId(jid);
                    client.getToasts().addToast((Toast)new SystemToast(SystemToast.SystemToastId.PERIODIC_NOTIFICATION, (Component)Component.translatable((String)"midnightcontrols.controller.connected", (Object[])new Object[]{jid}), (Component)Component.literal((String)controller.getName())));
                } else if (event == 262146) {
                    client.getToasts().addToast((Toast)new SystemToast(SystemToast.SystemToastId.PERIODIC_NOTIFICATION, (Component)Component.translatable((String)"midnightcontrols.controller.disconnected", (Object[])new Object[]{jid}), null));
                }
                MidnightControlsClient.switchControlsMode();
            });
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
        MidnightControlsCompat.init();
    }

    public static void initKeybindings() {
        if (lateInitDone) {
            return;
        }
        if (KeyBindingIDAccessor.getALL() == null || KeyBindingIDAccessor.getALL().isEmpty()) {
            return;
        }
        if (PlatformFunctions.isModLoaded((String)"voxelmap") && !KeyBindingIDAccessor.getALL().containsKey("key.minimap.toggleingamewaypoints")) {
            return;
        }
        if (PlatformFunctions.isModLoaded((String)"wynntils") && KeyBindingIDAccessor.getALL().entrySet().stream().noneMatch(b -> Objects.equals(((KeyMapping)b.getValue()).getCategory(), "Wynntils"))) {
            return;
        }
        for (int i = 0; i < KeyBindingIDAccessor.getALL().size(); ++i) {
            KeyMapping keyBinding = (KeyMapping)((Map.Entry)KeyBindingIDAccessor.getALL().entrySet().stream().toList().get(i)).getValue();
            if (!MidnightControlsConfig.excludedKeybindings.stream().noneMatch(excluded -> keyBinding.getName().startsWith((String)excluded)) || keyBinding.getName().contains("midnightcontrols")) continue;
            AtomicReference<ButtonCategory> category = new AtomicReference<ButtonCategory>();
            InputManager.streamCategories().forEach(buttonCategory -> {
                if (buttonCategory.getIdentifier().equals((Object)MidnightControlsClient.validVanillaId(keyBinding.getCategory()))) {
                    category.set((ButtonCategory)buttonCategory);
                }
            });
            if (category.get() == null) {
                category.set(new ButtonCategory(MidnightControlsClient.validVanillaId(keyBinding.getCategory())));
                InputManager.registerCategory((ButtonCategory)category.get());
            }
            ButtonBinding buttonBinding = new ButtonBinding.Builder(keyBinding.getName()).category((ButtonCategory)category.get()).linkKeybind(keyBinding).register();
            if (!MidnightControlsConfig.debug) continue;
            MidnightControls.log(keyBinding.getName());
            MidnightControls.log(String.valueOf(buttonBinding));
        }
        InputManager.loadButtonBindings();
        lateInitDone = true;
    }

    private static ResourceLocation validVanillaId(String path) {
        for (int i = 0; i < path.length(); ++i) {
            if (ResourceLocation.validPathChar((char)path.charAt(i))) continue;
            path = path.replace(path.charAt(i), '_');
        }
        return ResourceLocation.withDefaultNamespace((String)path);
    }

    public static void onTick(@NotNull Minecraft client) {
        MidnightControlsClient.initKeybindings();
        input.tick();
        reacharound.tick();
        if (MidnightControlsConfig.controlsMode == ControlsMode.CONTROLLER && (client.isWindowActive() || MidnightControlsConfig.unfocusedInput)) {
            input.tickController();
        }
        if (BINDING_RING.consumeClick()) {
            ring.loadFromUnbound();
            client.setScreen((Screen)new RingScreen());
        }
        if (client.level != null && MidnightControlsConfig.enableHints && !MidnightControlsConfig.autoSwitchMode && MidnightControlsConfig.controlsMode == ControlsMode.DEFAULT && MidnightControlsConfig.getController().isGamepad()) {
            client.getToasts().addToast((Toast)SystemToast.multiline((Minecraft)client, (SystemToast.SystemToastId)SystemToast.SystemToastId.PERIODIC_NOTIFICATION, (Component)Component.translatable((String)"midnightcontrols.controller.tutorial.title"), (Component)Component.translatable((String)"midnightcontrols.controller.tutorial.description", (Object[])new Object[]{Component.translatable((String)"options.title"), Component.translatable((String)"controls.title"), Component.translatable((String)"midnightcontrols.menu.title.controller")})));
            MidnightControlsConfig.enableHints = false;
            MidnightControlsConfig.save();
        }
        RainbowColor.tick();
        TouchInput.tick();
    }

    public static void onScreenOpen(Screen screen) {
        if (screen == null && MidnightControlsConfig.controlsMode == ControlsMode.TOUCHSCREEN) {
            screen = new TouchscreenOverlay();
            screen.init(client, client.getWindow().getGuiScaledWidth(), client.getWindow().getGuiScaledHeight());
            MidnightControlsClient.client.noRender = false;
            MidnightControlsClient.client.screen = screen;
        } else if (screen != null) {
            input.onScreenOpen(client.getWindow().getScreenWidth(), client.getWindow().getScreenHeight());
        }
    }

    public static void onLeave() {
        MidnightControlsFeature.resetAllAllowed();
    }

    public static void switchControlsMode() {
        if (MidnightControlsConfig.autoSwitchMode) {
            if (MidnightControlsConfig.getController().isGamepad()) {
                previousControlsMode = MidnightControlsConfig.controlsMode;
                MidnightControlsConfig.controlsMode = ControlsMode.CONTROLLER;
            } else {
                if (previousControlsMode == null) {
                    previousControlsMode = ControlsMode.DEFAULT;
                }
                MidnightControlsConfig.controlsMode = previousControlsMode;
            }
            NetworkUtil.sendPayloadC2S(new ControlsModePayload(MidnightControlsConfig.controlsMode.getName()));
        }
    }

    public static void setHudEnabled(boolean enabled) {
        MidnightControlsConfig.hudEnable = enabled;
        hud.setVisible(enabled);
    }

    @Deprecated
    public static MidnightControlsClient get() {
        return INSTANCE;
    }

    static {
        INSTANCE = new MidnightControlsClient();
    }
}

