/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols;

import java.util.Arrays;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public enum ControlsMode {
    DEFAULT,
    CONTROLLER,
    TOUCHSCREEN;


    public ControlsMode next() {
        ControlsMode[] v = ControlsMode.values();
        if (v.length == this.ordinal() + 1) {
            return v[0];
        }
        return v[this.ordinal() + 1];
    }

    public String getTranslationKey() {
        return "midnightcontrols.controls_mode." + this.getName();
    }

    @NotNull
    public String getName() {
        return this.name().toLowerCase();
    }

    public static Optional<ControlsMode> byId(@NotNull String id) {
        return Arrays.stream(ControlsMode.values()).filter(mode -> mode.getName().equalsIgnoreCase(id)).findFirst();
    }
}

