/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.content.effects;

import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;

public class ChorusEffect
extends MobEffect {
    public ChorusEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean shouldApplyEffectTickThisTick(int tick, int lv) {
        return tick == 1;
    }

    public boolean applyEffectTick(LivingEntity user, int lv) {
        this.teleport(user);
        return true;
    }

    public void teleport(LivingEntity target) {
        Level level = target.level();
        if (level.isClientSide) {
            return;
        }
        double d0 = target.getX();
        double d1 = target.getY();
        double d2 = target.getZ();
        for (int i = 0; i < 16; ++i) {
            double d3 = target.getX() + (target.getRandom().nextDouble() - 0.5) * 16.0;
            double d4 = Mth.clamp((double)(target.getY() + (double)(target.getRandom().nextInt(16) - 8)), (double)level.getMinBuildHeight(), (double)(level.getMinBuildHeight() + ((ServerLevel)level).getLogicalHeight() - 1));
            double d5 = target.getZ() + (target.getRandom().nextDouble() - 0.5) * 16.0;
            if (target.isPassenger()) {
                target.stopRiding();
            }
            Vec3 vec3 = target.position();
            level.gameEvent((Holder)GameEvent.TELEPORT, vec3, GameEvent.Context.of((Entity)target));
            EntityTeleportEvent.ChorusFruit event = EventHooks.onChorusFruitTeleport((LivingEntity)target, (double)d3, (double)d4, (double)d5);
            if (event.isCanceled()) {
                return;
            }
            if (!target.randomTeleport(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true)) continue;
            SoundEvent soundevent = target instanceof Fox ? SoundEvents.FOX_TELEPORT : SoundEvents.CHORUS_FRUIT_TELEPORT;
            level.playSound(null, d0, d1, d2, soundevent, SoundSource.PLAYERS, 1.0f, 1.0f);
            target.playSound(soundevent, 1.0f, 1.0f);
            break;
        }
    }
}

