/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.content.blocks.storage_container;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.foundation.block.IBE;
import dev.lopyluna.dndecor.content.blocks.storage_container.ColoredStorageContainerBlock;
import dev.lopyluna.dndecor.content.blocks.storage_container.ColoredStorageContainerBlockEntity;
import dev.lopyluna.dndecor.register.DnDecorBETypes;
import dev.lopyluna.dndecor.register.DnDecorBlocks;
import java.util.Objects;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColoredStorageContainerItem
extends BlockItem {
    private final DyeColor color;

    public ColoredStorageContainerItem(Item.Properties properties, DyeColor color) {
        super((Block)DnDecorBlocks.DYED_STORAGE_CONTAINER.get(), properties);
        this.color = color;
    }

    @Nullable
    protected BlockState getPlacementState(@NotNull BlockPlaceContext pContext) {
        if (super.getPlacementState(pContext) == null) {
            return super.getPlacementState(pContext);
        }
        return (BlockState)Objects.requireNonNull(super.getPlacementState(pContext)).setValue(ColoredStorageContainerBlock.COLOR, (Comparable)this.color);
    }

    @NotNull
    public String getDescriptionId() {
        return "item.design_decor." + RegisteredObjectsHelper.getKeyOrThrow((Item)this).getPath();
    }

    @NotNull
    public InteractionResult place(@NotNull BlockPlaceContext ctx) {
        InteractionResult initialResult = super.place(ctx);
        if (!initialResult.consumesAction()) {
            return initialResult;
        }
        this.tryMultiPlace(ctx);
        return initialResult;
    }

    protected boolean updateCustomBlockEntityTag(@NotNull BlockPos pos, Level level, Player player, @NotNull ItemStack itemStack, @NotNull BlockState blockState) {
        MinecraftServer minecraftserver = level.getServer();
        if (minecraftserver == null) {
            return false;
        }
        CustomData blockEntityData = (CustomData)itemStack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (blockEntityData != null) {
            CompoundTag nbt = blockEntityData.copyTag();
            nbt.remove("Length");
            nbt.remove("Size");
            nbt.remove("Controller");
            nbt.remove("LastKnownPos");
            BlockEntity.addEntityType((CompoundTag)nbt, (BlockEntityType)((IBE)this.getBlock()).getBlockEntityType());
            itemStack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)nbt));
        }
        return super.updateCustomBlockEntityTag(pos, level, player, itemStack, blockState);
    }

    private void tryMultiPlace(BlockPlaceContext ctx) {
        BlockState blockState;
        BlockPos offsetPos;
        int zOffset;
        int xOffset;
        BlockPos startPos;
        Player player = ctx.getPlayer();
        if (player == null) {
            return;
        }
        if (player.isShiftKeyDown()) {
            return;
        }
        Direction face = ctx.getClickedFace();
        ItemStack stack = ctx.getItemInHand();
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        BlockPos placedOnPos = pos.relative(face.getOpposite());
        BlockState placedOnState = world.getBlockState(placedOnPos);
        ColoredStorageContainerBlockEntity tankAt = (ColoredStorageContainerBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)DnDecorBETypes.COLORED_STORAGE_CONTAINER.get()), (BlockGetter)world, (BlockPos)placedOnPos);
        if (tankAt == null) {
            return;
        }
        ColoredStorageContainerBlockEntity controllerBE = tankAt.getControllerBE();
        if (controllerBE == null) {
            return;
        }
        if (!ColoredStorageContainerBlock.isVault(placedOnState)) {
            return;
        }
        int width = controllerBE.radius;
        if (width == 1) {
            return;
        }
        int tanksToPlace = 0;
        Direction.Axis vaultBlockAxis = ColoredStorageContainerBlock.getVaultBlockAxis(placedOnState);
        if (vaultBlockAxis == null) {
            return;
        }
        if (face.getAxis() != vaultBlockAxis) {
            return;
        }
        Direction vaultFacing = Direction.fromAxisAndDirection((Direction.Axis)vaultBlockAxis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        BlockPos blockPos = startPos = face == vaultFacing.getOpposite() ? controllerBE.getBlockPos().relative(vaultFacing.getOpposite()) : controllerBE.getBlockPos().relative(vaultFacing, controllerBE.length);
        if (VecHelper.getCoordinate((Vec3i)startPos, (Direction.Axis)vaultBlockAxis) != VecHelper.getCoordinate((Vec3i)pos, (Direction.Axis)vaultBlockAxis)) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = vaultBlockAxis == Direction.Axis.X ? startPos.offset(0, xOffset, zOffset) : startPos.offset(xOffset, zOffset, 0);
                blockState = world.getBlockState(offsetPos);
                if (ColoredStorageContainerBlock.isVault(blockState)) continue;
                if (!blockState.canBeReplaced()) {
                    return;
                }
                ++tanksToPlace;
            }
        }
        if (!player.isCreative() && stack.getCount() < tanksToPlace) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = vaultBlockAxis == Direction.Axis.X ? startPos.offset(0, xOffset, zOffset) : startPos.offset(xOffset, zOffset, 0);
                blockState = world.getBlockState(offsetPos);
                if (ColoredStorageContainerBlock.isVault(blockState)) continue;
                BlockPlaceContext context = BlockPlaceContext.at((BlockPlaceContext)ctx, (BlockPos)offsetPos, (Direction)face);
                player.getPersistentData().putBoolean("SilenceVaultSound", true);
                super.place(context);
                player.getPersistentData().remove("SilenceVaultSound");
            }
        }
    }
}

