/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.content.blocks.storage_container;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import dev.lopyluna.dndecor.content.blocks.storage_container.ColoredStorageContainerBlock;
import dev.lopyluna.dndecor.register.client.DnDecorSpriteShifts;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class ColoredStorageContainerCTBehaviour
extends ConnectedTextureBehaviour.Base {
    public CTSpriteShiftEntry getShift(BlockState state, Direction direction, @Nullable TextureAtlasSprite sprite) {
        boolean small;
        Direction.Axis vaultBlockAxis = ColoredStorageContainerBlock.getVaultBlockAxis(state);
        boolean bl = small = !ColoredStorageContainerBlock.isLarge(state);
        if (vaultBlockAxis == null) {
            return null;
        }
        DyeColor color = (DyeColor)state.getValue(ColoredStorageContainerBlock.COLOR);
        if (direction.getAxis() == vaultBlockAxis) {
            return DnDecorSpriteShifts.getColoredStorageFront(color, small);
        }
        if (direction == Direction.UP) {
            return DnDecorSpriteShifts.getColoredStorageTop(color, small);
        }
        if (direction == Direction.DOWN) {
            return DnDecorSpriteShifts.getColoredStorageBottom(color, small);
        }
        return DnDecorSpriteShifts.getColoredStorageSide(color, small);
    }

    protected Direction getUpDirection(BlockAndTintGetter reader, BlockPos pos, BlockState state, Direction face) {
        boolean alongX;
        Direction.Axis vaultBlockAxis = ColoredStorageContainerBlock.getVaultBlockAxis(state);
        boolean bl = alongX = vaultBlockAxis == Direction.Axis.X;
        if (face.getAxis().isVertical() && alongX) {
            return super.getUpDirection(reader, pos, state, face).getClockWise();
        }
        if (face.getAxis() == vaultBlockAxis || face.getAxis().isVertical()) {
            return super.getUpDirection(reader, pos, state, face);
        }
        assert (vaultBlockAxis != null);
        return Direction.fromAxisAndDirection((Direction.Axis)vaultBlockAxis, (Direction.AxisDirection)(alongX ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE));
    }

    protected Direction getRightDirection(BlockAndTintGetter reader, BlockPos pos, BlockState state, Direction face) {
        Direction.Axis vaultBlockAxis = ColoredStorageContainerBlock.getVaultBlockAxis(state);
        if (face.getAxis().isVertical() && vaultBlockAxis == Direction.Axis.X) {
            return super.getRightDirection(reader, pos, state, face).getClockWise();
        }
        if (face.getAxis() == vaultBlockAxis || face.getAxis().isVertical()) {
            return super.getRightDirection(reader, pos, state, face);
        }
        return Direction.fromAxisAndDirection((Direction.Axis)Direction.Axis.Y, (Direction.AxisDirection)face.getAxisDirection());
    }

    public boolean buildContextForOccludedDirections() {
        return super.buildContextForOccludedDirections();
    }

    public boolean connectsTo(BlockState state, BlockState other, BlockAndTintGetter reader, BlockPos pos, BlockPos otherPos, Direction face) {
        return state == other && ConnectivityHandler.isConnected((BlockGetter)reader, (BlockPos)pos, (BlockPos)otherPos);
    }
}

