/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Optional;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.lwjgl.opengl.GL30;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import team.lodestar.lodestone.helpers.TextureHelper;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderSystem;

public class VolumeTexture
extends AbstractTexture {
    protected final ResourceLocation location;
    private final int xSlices;
    private final int ySlices;
    private int width;
    private int height;
    private int depth;
    private boolean linear;

    public VolumeTexture(ResourceLocation location, int xSlices, int ySlices) {
        this(location, xSlices, ySlices, false);
    }

    public VolumeTexture(ResourceLocation location, int xSlices, int ySlices, boolean linear) {
        this.location = location;
        this.xSlices = xSlices;
        this.ySlices = ySlices;
        this.linear = linear;
    }

    public void load(ResourceManager resourceManager) throws IOException {
        Optional resource = resourceManager.getResource(this.location);
        if (resource.isPresent()) {
            ByteBuffer textureData = TextureUtil.readResource((InputStream)((Resource)resource.get()).open());
            textureData.rewind();
            try (MemoryStack stack = MemoryStack.stackPush();){
                IntBuffer width = stack.mallocInt(1);
                IntBuffer height = stack.mallocInt(1);
                IntBuffer channels = stack.mallocInt(1);
                ByteBuffer image = STBImage.stbi_load_from_memory((ByteBuffer)textureData, (IntBuffer)width, (IntBuffer)height, (IntBuffer)channels, (int)4);
                if (image == null) {
                    throw new IOException("Could not load image: " + STBImage.stbi_failure_reason());
                }
                int[] resultSize = new int[3];
                ByteBuffer volume = TextureHelper.convertTextureAtlasToVolume(image, width.get(), height.get(), this.xSlices, this.ySlices, 4, resultSize);
                this.width = resultSize[0];
                this.height = resultSize[1];
                this.depth = resultSize[2];
                this.id = GL30.glGenTextures();
                GL30.glBindTexture((int)32879, (int)this.id);
                GL30.glPixelStorei((int)3317, (int)1);
                GL30.glTexImage3D((int)32879, (int)0, (int)6408, (int)this.width, (int)this.height, (int)this.depth, (int)0, (int)6408, (int)5121, (ByteBuffer)volume);
                GL30.glTexParameteri((int)32879, (int)10241, (int)(this.linear ? 9729 : 9728));
                GL30.glTexParameteri((int)32879, (int)10240, (int)(this.linear ? 9729 : 9728));
                GL30.glTexParameteri((int)32879, (int)10242, (int)33069);
                GL30.glTexParameteri((int)32879, (int)10243, (int)33069);
                GL30.glTexParameteri((int)32879, (int)32882, (int)33069);
                GL30.glGenerateMipmap((int)32879);
                GL30.glBindTexture((int)32879, (int)0);
                STBImage.stbi_image_free((ByteBuffer)image);
            }
        }
    }

    public void bind() {
        LodestoneRenderSystem.wrap(() -> GL30.glBindTexture((int)32879, (int)this.id));
    }

    public void setFilter(boolean blur, boolean mipmap) {
        int j;
        int i;
        RenderSystem.assertOnRenderThreadOrInit();
        this.blur = blur;
        this.mipmap = mipmap;
        if (blur) {
            i = mipmap ? 9987 : 9729;
            j = 9729;
        } else {
            i = mipmap ? 9986 : 9728;
            j = 9728;
        }
        this.bind();
        GlStateManager._texParameter((int)32879, (int)10241, (int)i);
        GlStateManager._texParameter((int)32879, (int)10240, (int)j);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getXSlices() {
        return this.xSlices;
    }

    public int getYSlices() {
        return this.ySlices;
    }
}

