/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.rendering.rendeertype;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.Util;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;

public class RenderTypeProvider {
    private final Function<RenderTypeToken, LodestoneRenderType> function;
    private final Function<RenderTypeToken, LodestoneRenderType> simpleCache;
    private final ConcurrentHashMap<RenderTypeProviderKey, LodestoneRenderType> complexCache = new ConcurrentHashMap();

    public RenderTypeProvider(Function<RenderTypeToken, LodestoneRenderType> function) {
        this.function = function;
        this.simpleCache = Util.memoize(function);
    }

    private LodestoneRenderType createRenderType(RenderTypeToken token) {
        return this.simpleCache.apply(token);
    }

    private LodestoneRenderType createRenderType(RenderTypeProviderKey key) {
        if (this.complexCache.containsKey(key)) {
            return this.complexCache.get(key);
        }
        if (key.modifier() != null) {
            LodestoneRenderTypes.addRenderTypeModifier(key.modifier());
        }
        LodestoneRenderType renderType = this.function.apply(key.token());
        if (key.uniformHandler() != null) {
            LodestoneRenderTypes.applyUniformChanges(renderType, key.uniformHandler());
        }
        this.complexCache.put(key, renderType);
        return renderType;
    }

    public LodestoneRenderType apply(RenderTypeToken token) {
        return this.createRenderType(token);
    }

    public LodestoneRenderType apply(RenderTypeToken token, ShaderUniformHandler uniformHandler) {
        return this.createRenderType(new RenderTypeProviderKey(token, uniformHandler));
    }

    public LodestoneRenderType apply(RenderTypeToken token, Consumer<LodestoneRenderTypes.LodestoneCompositeStateBuilder> modifier) {
        return this.createRenderType(new RenderTypeProviderKey(token, modifier));
    }

    public LodestoneRenderType apply(RenderTypeToken token, ShaderUniformHandler uniformHandler, Consumer<LodestoneRenderTypes.LodestoneCompositeStateBuilder> modifier) {
        return this.createRenderType(new RenderTypeProviderKey(token, uniformHandler, modifier));
    }

    @Deprecated(forRemoval=true)
    public LodestoneRenderType applyAndCache(RenderTypeToken token) {
        return this.apply(token);
    }

    @Deprecated(forRemoval=true)
    public LodestoneRenderType applyAndCache(RenderTypeToken token, ShaderUniformHandler uniformHandler) {
        return this.apply(token, uniformHandler);
    }

    @Deprecated(forRemoval=true)
    public LodestoneRenderType applyWithModifier(RenderTypeToken token, Consumer<LodestoneRenderTypes.LodestoneCompositeStateBuilder> modifier) {
        return this.apply(token, modifier);
    }

    @Deprecated(forRemoval=true)
    public LodestoneRenderType applyWithModifier(RenderTypeToken token, ShaderUniformHandler uniformHandler, Consumer<LodestoneRenderTypes.LodestoneCompositeStateBuilder> modifier) {
        return this.apply(token, uniformHandler, modifier);
    }

    @Deprecated(forRemoval=true)
    public LodestoneRenderType applyWithModifierAndCache(RenderTypeToken token, Consumer<LodestoneRenderTypes.LodestoneCompositeStateBuilder> modifier) {
        return this.apply(token, modifier);
    }

    @Deprecated(forRemoval=true)
    public LodestoneRenderType applyWithModifierAndCache(RenderTypeToken token, ShaderUniformHandler uniformHandler, Consumer<LodestoneRenderTypes.LodestoneCompositeStateBuilder> modifier) {
        return this.apply(token, uniformHandler, modifier);
    }

    public record RenderTypeProviderKey(RenderTypeToken token, ShaderUniformHandler uniformHandler, Consumer<LodestoneRenderTypes.LodestoneCompositeStateBuilder> modifier) {
        public RenderTypeProviderKey(RenderTypeToken token) {
            this(token, null, null);
        }

        public RenderTypeProviderKey(RenderTypeToken token, ShaderUniformHandler uniformHandler) {
            this(token, uniformHandler, null);
        }

        public RenderTypeProviderKey(RenderTypeToken token, Consumer<LodestoneRenderTypes.LodestoneCompositeStateBuilder> modifier) {
            this(token, null, modifier);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RenderTypeProviderKey that = (RenderTypeProviderKey)o;
            return Objects.equals(this.token, that.token) && Objects.equals(this.uniformHandler, that.uniformHandler) && Objects.equals(this.modifier, that.modifier);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.token, this.uniformHandler, this.modifier);
        }
    }
}

