/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.rendering;

import com.mojang.blaze3d.pipeline.RenderCall;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.lwjgl.opengl.GL43;
import team.lodestar.lodestone.systems.rendering.IBufferObject;

public class LodestoneRenderSystem
extends RenderSystem {
    private static final List<IBufferObject> bufferObjects = new ArrayList<IBufferObject>();

    public static void wrap(RenderCall renderCall) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall((RenderCall)renderCall);
        } else {
            renderCall.execute();
        }
    }

    public static void registerBufferObject(IBufferObject bufferObject) {
        bufferObjects.add(bufferObject);
    }

    public static void unregisterBufferObject(IBufferObject bufferObject) {
        bufferObjects.remove(bufferObject);
    }

    public static void destroyBufferObjects() {
        Iterator<IBufferObject> objects = bufferObjects.iterator();
        while (objects.hasNext()) {
            IBufferObject object = objects.next();
            object.destroy();
            objects.remove();
        }
    }

    public static void dispatchCompute(int num_groups_x, int num_groups_y, int num_groups_z) {
        LodestoneRenderSystem.wrap(() -> GL43.glDispatchCompute((int)num_groups_x, (int)num_groups_y, (int)num_groups_z));
    }

    public static void memoryBarrier(int barriers) {
        LodestoneRenderSystem.wrap(() -> GL43.glMemoryBarrier((int)barriers));
    }

    public static void bindBufferBase(int target, int index, int buffer) {
        LodestoneRenderSystem.wrap(() -> GL43.glBindBufferBase((int)target, (int)index, (int)buffer));
    }

    public static void mapBuffer(int target, int access, Consumer<ByteBuffer> byteBufferConsumer) {
        LodestoneRenderSystem.wrap(() -> byteBufferConsumer.accept(GL43.glMapBuffer((int)target, (int)access)));
    }

    public static void unmapBuffer(int target) {
        LodestoneRenderSystem.wrap(() -> GL43.glUnmapBuffer((int)target));
    }
}

