/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.block;

import java.awt.Color;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.util.Mth;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import team.lodestar.lodestone.systems.easing.Easing;

public abstract class LodestoneLeavesBlock
extends LeavesBlock {
    public final Color minColor;
    public final Color maxColor;

    public LodestoneLeavesBlock(BlockBehaviour.Properties properties, Color minColor, Color maxColor) {
        super(properties);
        this.minColor = minColor;
        this.maxColor = maxColor;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)this.getColorProperty(), (Comparable)Integer.valueOf(0)));
    }

    public abstract IntegerProperty getColorProperty();

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DISTANCE, PERSISTENT, WATERLOGGED, this.getColorProperty()});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)this.getColorProperty(), (Comparable)Integer.valueOf(0));
    }

    public static void registerSimpleGradientColors(BlockColors blockColors, LodestoneLeavesBlock leavesBlock) {
        blockColors.register((s, l, p, c) -> {
            IntegerProperty colorProperty = leavesBlock.getColorProperty();
            float colorMax = colorProperty.getPossibleValues().size();
            float color = ((Integer)s.getValue((Property)colorProperty)).intValue();
            float pct = colorMax - color / colorMax;
            float value = Easing.SINE_IN_OUT.ease(pct, 0.0f, 1.0f, 1.0f);
            int red = (int)Mth.lerp((float)value, (float)leavesBlock.minColor.getRed(), (float)leavesBlock.maxColor.getRed());
            int green = (int)Mth.lerp((float)value, (float)leavesBlock.minColor.getGreen(), (float)leavesBlock.maxColor.getGreen());
            int blue = (int)Mth.lerp((float)value, (float)leavesBlock.minColor.getBlue(), (float)leavesBlock.maxColor.getBlue());
            return red << 16 | green << 8 | blue;
        }, new Block[]{leavesBlock});
    }
}

