/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.helpers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.helpers.VecHelper;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;

public class RenderHelper {
    public static final int FULL_BRIGHT = 0xF000F0;

    public static Optional<ShaderInstance> getShader(RenderType type) {
        if (type instanceof LodestoneRenderType) {
            LodestoneRenderType renderType = (LodestoneRenderType)type;
            Optional shader = renderType.state.shaderState.shader;
            if (shader.isPresent()) {
                return Optional.ofNullable((ShaderInstance)((Supplier)shader.get()).get());
            }
        }
        return Optional.empty();
    }

    public static RenderStateShard.TransparencyStateShard getTransparencyShard(RenderType type) {
        if (type instanceof LodestoneRenderType) {
            LodestoneRenderType compositeRenderType = (LodestoneRenderType)type;
            return compositeRenderType.state.transparencyState;
        }
        return null;
    }

    public static void vertexPos(VertexConsumer vertexConsumer, Matrix4f last, float x, float y, float z) {
        vertexConsumer.addVertex(last, x, y, z);
    }

    public static void vertexPosUV(VertexConsumer vertexConsumer, Matrix4f last, float x, float y, float z, float u, float v) {
        vertexConsumer.addVertex(last, x, y, z).setUv(u, v);
    }

    public static void vertexPosUVLight(VertexConsumer vertexConsumer, Matrix4f last, float x, float y, float z, float u, float v, int light) {
        vertexConsumer.addVertex(last, x, y, z).setUv(u, v).setLight(light);
    }

    public static void vertexPosColor(VertexConsumer vertexConsumer, Matrix4f last, float x, float y, float z, float r, float g, float b, float a) {
        vertexConsumer.addVertex(last, x, y, z).setColor(r, g, b, a);
    }

    public static void vertexPosColorUV(VertexConsumer vertexConsumer, Matrix4f last, float x, float y, float z, float r, float g, float b, float a, float u, float v) {
        vertexConsumer.addVertex(last, x, y, z).setColor(r, g, b, a).setUv(u, v);
    }

    public static void vertexPosColorUVLight(VertexConsumer vertexConsumer, Matrix4f last, float x, float y, float z, float r, float g, float b, float a, float u, float v, int light) {
        vertexConsumer.addVertex(last, x, y, z).setColor(r, g, b, a).setUv(u, v).setLight(light);
    }

    public static Vector3f parametricSphere(float u, float v, float r) {
        return new Vector3f(Mth.cos((float)u) * Mth.sin((float)v) * r, Mth.cos((float)v) * r, Mth.sin((float)u) * Mth.sin((float)v) * r);
    }

    public static Vector3f parametricTorus(float u, float v, float majorRadius, float minorRadius) {
        float x = (majorRadius + minorRadius * Mth.cos((float)v)) * Mth.cos((float)u);
        float y = minorRadius * Mth.sin((float)v);
        float z = (majorRadius + minorRadius * Mth.cos((float)v)) * Mth.sin((float)u);
        return new Vector3f(x, y, z);
    }

    public static Vec2 perpendicularTrailPoints(Vector4f start, Vector4f end, float width) {
        float x = -start.x();
        float y = -start.y();
        if (Math.abs(start.z()) > 0.0f) {
            float ratio = end.z() / start.z();
            x = end.x() + x * ratio;
            y = end.y() + y * ratio;
        } else if (Math.abs(end.z()) <= 0.0f) {
            x += end.x();
            y += end.y();
        }
        if (start.z() > 0.0f) {
            x = -x;
            y = -y;
        }
        if (x * x + y * y > 0.0f) {
            float normalize = width * 0.5f / DataHelper.distance(x, y);
            x *= normalize;
            y *= normalize;
        }
        return new Vec2(-y, x);
    }

    public static Vector4f midpoint(Vector4f a, Vector4f b) {
        return new Vector4f((a.x() + b.x()) * 0.5f, (a.y() + b.y()) * 0.5f, (a.z() + b.z()) * 0.5f, (a.w() + b.w()) * 0.5f);
    }

    public static Vec2 worldPosToTexCoord(Vector3f worldPos, PoseStack viewModelStack) {
        Matrix4f viewMat = viewModelStack.last().pose();
        Matrix4f projMat = RenderSystem.getProjectionMatrix();
        Vector3f localPos = new Vector3f((Vector3fc)worldPos);
        localPos.sub((Vector3fc)Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().toVector3f());
        Vector4f pos = new Vector4f((Vector3fc)localPos, 0.0f);
        pos.mul((Matrix4fc)viewMat);
        pos.mul((Matrix4fc)projMat);
        VecHelper.Vector4fHelper.perspectiveDivide(pos);
        return new Vec2((pos.x() + 1.0f) / 2.0f, (pos.y() + 1.0f) / 2.0f);
    }

    public static void drawSteppedLineBetween(MultiBufferSource buffer, PoseStack ps, List<Vec3> points, float lineWidth, int r, int g, int b, int a) {
        Vec3 origin = points.get(0);
        for (int i = 1; i < points.size(); ++i) {
            Vec3 target = points.get(i);
            RenderHelper.drawLineBetween(buffer, ps, origin, target, lineWidth, r, g, b, a);
            origin = target;
        }
    }

    public static void drawSteppedLineBetween(MultiBufferSource buffer, PoseStack ps, Vec3 start, Vec3 end, int steps, float lineWidth, int r, int g, int b, int a, Consumer<Vec3> pointConsumer) {
        Vec3 origin = start;
        for (int i = 1; i <= steps; ++i) {
            Vec3 target = start.add(end.subtract(start).scale((double)((float)i / (float)steps)));
            pointConsumer.accept(target);
            RenderHelper.drawLineBetween(buffer, ps, origin, target, lineWidth, r, g, b, a);
            origin = target;
        }
    }

    public static void drawLineBetween(MultiBufferSource buffer, PoseStack ps, Vec3 local, Vec3 target, float lineWidth, int r, int g, int b, int a) {
        VertexConsumer builder = buffer.getBuffer(RenderType.leash());
        float rotY = (float)Mth.atan2((double)(target.x - local.x), (double)(target.z - local.z));
        double distX = target.x - local.x;
        double distZ = target.z - local.z;
        float rotX = (float)Mth.atan2((double)(target.y - local.y), (double)Mth.sqrt((float)((float)(distX * distX + distZ * distZ))));
        ps.pushPose();
        ps.translate(local.x, local.y, local.z);
        ps.mulPose(VecHelper.Vector3fHelper.rotation(rotY, VecHelper.Vector3fHelper.YP));
        ps.mulPose(VecHelper.Vector3fHelper.rotation(rotX, VecHelper.Vector3fHelper.XN));
        float distance = (float)local.distanceTo(target);
        Matrix4f matrix = ps.last().pose();
        float halfWidth = lineWidth / 2.0f;
        builder.addVertex(matrix, -halfWidth, 0.0f, 0.0f).setColor(r, g, b, a).setLight(0xF000F0);
        builder.addVertex(matrix, halfWidth, 0.0f, 0.0f).setColor(r, g, b, a).setLight(0xF000F0);
        builder.addVertex(matrix, halfWidth, 0.0f, distance).setColor(r, g, b, a).setLight(0xF000F0);
        builder.addVertex(matrix, -halfWidth, 0.0f, distance).setColor(r, g, b, a).setLight(0xF000F0);
        builder.addVertex(matrix, 0.0f, -halfWidth, 0.0f).setColor(r, g, b, a).setLight(0xF000F0);
        builder.addVertex(matrix, 0.0f, halfWidth, 0.0f).setColor(r, g, b, a).setLight(0xF000F0);
        builder.addVertex(matrix, 0.0f, halfWidth, distance).setColor(r, g, b, a).setLight(0xF000F0);
        builder.addVertex(matrix, 0.0f, -halfWidth, distance).setColor(r, g, b, a).setLight(0xF000F0);
        ps.popPose();
    }
}

