/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.helpers;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CurioHelper {
    public static Optional<SlotResult> getEquippedCurio(LivingEntity entity, Predicate<ItemStack> predicate) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).flatMap(iCuriosItemHandler -> iCuriosItemHandler.findFirstCurio(predicate));
    }

    public static Optional<SlotResult> getEquippedCurio(LivingEntity entity, Item curio) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).flatMap(iCuriosItemHandler -> iCuriosItemHandler.findFirstCurio(stack -> stack.getItem() == curio));
    }

    public static boolean hasCurioEquipped(LivingEntity entity, Item curio) {
        return CurioHelper.getEquippedCurio(entity, curio).isPresent();
    }

    public static ArrayList<ItemStack> getEquippedCurios(LivingEntity entity) {
        Optional<IItemHandlerModifiable> optional = CuriosApi.getCuriosInventory((LivingEntity)entity).map(ICuriosItemHandler::getEquippedCurios);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (optional.isPresent()) {
            IItemHandlerModifiable handler = optional.get();
            for (int i = 0; i < handler.getSlots(); ++i) {
                stacks.add(handler.getStackInSlot(i));
            }
        }
        return stacks;
    }

    public static ArrayList<ItemStack> getEquippedCurios(LivingEntity entity, Predicate<ItemStack> predicate) {
        Optional<IItemHandlerModifiable> optional = CuriosApi.getCuriosInventory((LivingEntity)entity).map(ICuriosItemHandler::getEquippedCurios);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (optional.isPresent()) {
            IItemHandlerModifiable handler = optional.get();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (!predicate.test(stack)) continue;
                stacks.add(stack);
            }
        }
        return stacks;
    }

    public static Optional<ImmutableTriple<String, Integer, ItemStack>> findCosmeticCurio(Predicate<ItemStack> filter, LivingEntity livingEntity) {
        ImmutableTriple result = CuriosApi.getCuriosInventory((LivingEntity)livingEntity).map(handler -> {
            Map curios = handler.getCurios();
            for (String id : curios.keySet()) {
                ItemStack stack;
                int i;
                ICurioStacksHandler stacksHandler = (ICurioStacksHandler)curios.get(id);
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                IDynamicStackHandler cosmeticStackHelper = stacksHandler.getCosmeticStacks();
                for (i = 0; i < stackHandler.getSlots(); ++i) {
                    stack = stackHandler.getStackInSlot(i);
                    if (stack.isEmpty() || !filter.test(stack)) continue;
                    return new ImmutableTriple((Object)id, (Object)i, (Object)stack);
                }
                for (i = 0; i < cosmeticStackHelper.getSlots(); ++i) {
                    stack = cosmeticStackHelper.getStackInSlot(i);
                    if (stack.isEmpty() || !filter.test(stack)) continue;
                    return new ImmutableTriple((Object)id, (Object)i, (Object)stack);
                }
            }
            return new ImmutableTriple((Object)"", (Object)0, (Object)ItemStack.EMPTY);
        }).orElse(new ImmutableTriple((Object)"", (Object)0, (Object)ItemStack.EMPTY));
        return ((String)result.getLeft()).isEmpty() ? Optional.empty() : Optional.of(result);
    }
}

