/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.handlers;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import team.lodestar.lodestone.attachment.WorldEventAttachment;
import team.lodestar.lodestone.events.types.worldevent.WorldEventCreationEvent;
import team.lodestar.lodestone.events.types.worldevent.WorldEventDiscardEvent;
import team.lodestar.lodestone.events.types.worldevent.WorldEventRenderEvent;
import team.lodestar.lodestone.events.types.worldevent.WorldEventTickEvent;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.network.worldevent.UpdateWorldEventPayload;
import team.lodestar.lodestone.registry.client.LodestoneWorldEventRenderers;
import team.lodestar.lodestone.registry.common.LodestoneAttachmentTypes;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;
import team.lodestar.lodestone.systems.worldevent.WorldEventRenderer;

public class WorldEventHandler {
    public static <T extends WorldEventInstance> T addWorldEvent(Level level, T instance) {
        return WorldEventHandler.addWorldEvent(level, true, instance);
    }

    public static <T extends WorldEventInstance> T addWorldEvent(Level level, boolean shouldStart, T instance) {
        NeoForge.EVENT_BUS.post((Event)new WorldEventCreationEvent(instance, level));
        WorldEventAttachment worldData = (WorldEventAttachment)level.getData(LodestoneAttachmentTypes.WORLD_EVENT_DATA);
        worldData.inboundWorldEvents.add(instance);
        if (shouldStart) {
            instance.start(level);
        }
        instance.sync(level);
        return instance;
    }

    public static void playerJoin(EntityJoinLevelEvent event) {
        Player player;
        Level level;
        Entity entity = event.getEntity();
        if (entity instanceof Player && (level = (player = (Player)entity).level()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            WorldEventAttachment worldData = (WorldEventAttachment)level2.getData(LodestoneAttachmentTypes.WORLD_EVENT_DATA);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                for (WorldEventInstance instance : worldData.activeWorldEvents) {
                    if (!instance.type.isClientSynced()) continue;
                    WorldEventInstance.sync(instance, serverPlayer);
                }
            }
        }
    }

    public static void worldTick(LevelTickEvent.Post event) {
        if (!event.getLevel().isClientSide) {
            WorldEventHandler.tick(event.getLevel());
        }
    }

    public static void tick(Level level) {
        WorldEventAttachment c = (WorldEventAttachment)level.getData(LodestoneAttachmentTypes.WORLD_EVENT_DATA);
        c.activeWorldEvents.addAll(c.inboundWorldEvents);
        c.inboundWorldEvents.clear();
        Iterator<WorldEventInstance> iterator = c.activeWorldEvents.iterator();
        while (iterator.hasNext()) {
            WorldEventInstance instance = iterator.next();
            if (instance.discarded) {
                NeoForge.EVENT_BUS.post((Event)new WorldEventDiscardEvent(instance, level));
                iterator.remove();
                continue;
            }
            if (!instance.isFrozen()) {
                NeoForge.EVENT_BUS.post((Event)new WorldEventTickEvent(instance, level));
                instance.tick(level);
            }
            if (!instance.dirty) continue;
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new UpdateWorldEventPayload(instance), (CustomPacketPayload[])new CustomPacketPayload[0]);
            instance.dirty = false;
        }
    }

    public static class ClientOnly {
        public static void renderWorldEvents(PoseStack stack, float partialTicks) {
            if (Minecraft.getInstance().level != null) {
                WorldEventAttachment worldData = (WorldEventAttachment)Minecraft.getInstance().level.getData(LodestoneAttachmentTypes.WORLD_EVENT_DATA);
                for (WorldEventInstance instance : worldData.activeWorldEvents) {
                    WorldEventRenderer<WorldEventInstance> renderer = LodestoneWorldEventRenderers.RENDERERS.get(instance.type);
                    if (renderer == null || !renderer.canRender(instance)) continue;
                    NeoForge.EVENT_BUS.post((Event)new WorldEventRenderEvent(instance, renderer, stack, (MultiBufferSource)RenderHandler.DELAYED_RENDER.getTarget(), partialTicks));
                    renderer.render(instance, stack, (MultiBufferSource)RenderHandler.DELAYED_RENDER.getTarget(), partialTicks);
                }
            }
        }
    }
}

