/*
 * Decompiled with CFR 0.152.
 */
package com.furglitch.vendingblock.network;

import com.furglitch.vendingblock.blockentity.VendorBlockEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record OwnerChangePacket(BlockPos pos, String newOwner) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<OwnerChangePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"vendingblock", (String)"owner_change"));
    public static final StreamCodec<ByteBuf, OwnerChangePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, OwnerChangePacket::pos, (StreamCodec)ByteBufCodecs.STRING_UTF8, OwnerChangePacket::newOwner, OwnerChangePacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(OwnerChangePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            Level level = player.level();
            BlockEntity patt0$temp = level.getBlockEntity(packet.pos());
            if (patt0$temp instanceof VendorBlockEntity) {
                VendorBlockEntity vendorBlockEntity = (VendorBlockEntity)patt0$temp;
                vendorBlockEntity.setOwnerByUsername(packet.newOwner());
            }
        });
    }
}

